/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resourcegroup;

import com.google.common.collect.Sets;
import java.util.Random;
import java.util.Set;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.resourcegroup.ResourceGroup;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.awaitility.Awaitility;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ResourceGroupConfigListenerTest
extends MockedPulsarServiceBaseTest {
    org.apache.pulsar.common.policies.data.ResourceGroup testAddRg = new org.apache.pulsar.common.policies.data.ResourceGroup();
    final String rgName = "testRG";
    final int MAX_RGS = 10;
    final String tenantName = "test-tenant";
    final String namespaceName = "test-tenant/test-namespace";
    final String clusterName = "test";

    @Override
    @BeforeClass
    protected void setup() throws Exception {
        super.internalSetup();
        this.prepareData();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    public void createResourceGroup(String rgName, org.apache.pulsar.common.policies.data.ResourceGroup rg) throws PulsarAdminException {
        this.admin.resourcegroups().createResourceGroup(rgName, rg);
        Awaitility.await().untilAsserted(() -> {
            ResourceGroup resourceGroup = this.pulsar.getResourceGroupServiceManager().resourceGroupGet(rgName);
            Assert.assertNotNull((Object)resourceGroup);
            Assert.assertEquals((String)rgName, (String)resourceGroup.resourceGroupName);
        });
    }

    public void deleteResourceGroup(String rgName) throws PulsarAdminException {
        this.admin.resourcegroups().deleteResourceGroup(rgName);
        Awaitility.await().untilAsserted(() -> Assert.assertNull((Object)this.pulsar.getResourceGroupServiceManager().resourceGroupGet(rgName)));
    }

    public void updateResourceGroup(String rgName, org.apache.pulsar.common.policies.data.ResourceGroup rg) throws PulsarAdminException {
        this.testAddRg.setPublishRateInMsgs(200000);
        this.admin.resourcegroups().updateResourceGroup(rgName, rg);
        Awaitility.await().untilAsserted(() -> {
            ResourceGroup resourceGroup = this.pulsar.getResourceGroupServiceManager().resourceGroupGet(rgName);
            Assert.assertNotNull((Object)resourceGroup);
            Assert.assertEquals((String)rgName, (String)resourceGroup.resourceGroupName);
        });
    }

    @Test
    public void testResourceGroupCreate() throws Exception {
        this.createResourceGroup("testRG", this.testAddRg);
        this.deleteResourceGroup("testRG");
    }

    @Test
    public void testResourceGroupDeleteNonExistent() throws Exception {
        Assert.assertThrows(PulsarAdminException.class, () -> this.admin.resourcegroups().deleteResourceGroup("testRG"));
    }

    @Test
    public void testResourceGroupUpdate() throws Exception {
        this.createResourceGroup("testRG", this.testAddRg);
        this.updateResourceGroup("testRG", this.testAddRg);
        this.deleteResourceGroup("testRG");
    }

    @Test
    public void testResourceGroupCreateDeleteCreate() throws Exception {
        this.createResourceGroup("testRG", this.testAddRg);
        this.deleteResourceGroup("testRG");
        this.createResourceGroup("testRG", this.testAddRg);
        this.deleteResourceGroup("testRG");
    }

    @Test
    public void testResourceGroupAttachToNamespace() throws Exception {
        this.createResourceGroup("testRG", this.testAddRg);
        this.admin.tenants().createTenant("test-tenant", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"fake-admin-role"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace("test-tenant/test-namespace");
        this.admin.namespaces().setNamespaceResourceGroup("test-tenant/test-namespace", "testRG");
        Awaitility.await().untilAsserted(() -> Assert.assertNotNull((Object)this.pulsar.getResourceGroupServiceManager().getNamespaceResourceGroup("test-tenant/test-namespace")));
        this.admin.namespaces().removeNamespaceResourceGroup("test-tenant/test-namespace");
        Awaitility.await().untilAsserted(() -> Assert.assertNull((Object)this.pulsar.getResourceGroupServiceManager().getNamespaceResourceGroup("test-tenant/test-namespace")));
        this.admin.namespaces().deleteNamespace("test-tenant/test-namespace");
        this.deleteResourceGroup("testRG");
    }

    @Test
    public void testResourceGroupCreateMany() throws Exception {
        String rgName;
        int i;
        Random random = new Random(System.currentTimeMillis());
        for (i = 0; i < 10; ++i) {
            rgName = String.format("testRg-%d", i);
            this.testAddRg.setDispatchRateInBytes((long)random.nextInt());
            this.testAddRg.setDispatchRateInMsgs(random.nextInt());
            this.testAddRg.setPublishRateInBytes((long)random.nextInt());
            this.testAddRg.setPublishRateInMsgs(random.nextInt());
            this.admin.resourcegroups().createResourceGroup(rgName, this.testAddRg);
        }
        Awaitility.await().untilAsserted(() -> {
            for (int i = 0; i < 10; ++i) {
                String rgName = String.format("testRg-%d", i);
                Assert.assertNotNull((Object)this.pulsar.getResourceGroupServiceManager().resourceGroupGet(rgName));
            }
        });
        for (i = 0; i < 10; ++i) {
            rgName = String.format("testRg-%d", i);
            this.admin.resourcegroups().deleteResourceGroup(rgName);
        }
        Awaitility.await().untilAsserted(() -> {
            for (int i = 0; i < 10; ++i) {
                String rgName = String.format("testRg-%d", i);
                Assert.assertNull((Object)this.pulsar.getResourceGroupServiceManager().resourceGroupGet(rgName));
            }
        });
    }

    private void prepareData() throws PulsarAdminException {
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        this.testAddRg.setPublishRateInBytes(10000L);
        this.testAddRg.setPublishRateInMsgs(100);
        this.testAddRg.setDispatchRateInMsgs(20000);
        this.testAddRg.setDispatchRateInBytes(200L);
    }
}

