/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resourcegroup;

import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.resourcegroup.ResourceQuotaCalculatorImpl;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ResourceQuotaCalculatorImplTest
extends MockedPulsarServiceBaseTest {
    private ResourceQuotaCalculatorImpl rqCalc;

    @Override
    @BeforeClass
    protected void setup() throws Exception {
        super.internalSetup();
        this.rqCalc = new ResourceQuotaCalculatorImpl();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testRQCalcNegativeConfTest() throws PulsarAdminException {
        long[] allUsage = new long[]{0L};
        long calculatedQuota = this.rqCalc.computeLocalQuota(-1L, 0L, allUsage);
        Assert.assertEquals((long)calculatedQuota, (long)Long.MAX_VALUE);
    }

    @Test
    public void testRQCalcNegativeLocalUsageTest() {
        long[] allUsage = new long[]{0L};
        Assert.assertThrows(PulsarAdminException.class, () -> this.rqCalc.computeLocalQuota(0L, -1L, allUsage));
    }

    @Test
    public void testRQCalcNegativeAllUsageTest() {
        long[] allUsage = new long[]{-1L};
        Assert.assertThrows(PulsarAdminException.class, () -> this.rqCalc.computeLocalQuota(0L, 0L, allUsage));
    }

    @Test
    public void testRQCalcGlobUsedLessThanConfigTest() throws PulsarAdminException {
        long config = 100L;
        long localUsed = 20L;
        long[] allUsage = new long[]{40L};
        long newQuota = this.rqCalc.computeLocalQuota(100L, 20L, allUsage);
        Assert.assertTrue((newQuota > 20L ? 1 : 0) != 0);
    }

    @Test
    public void testRQCalcGlobUsedEqualsToConfigTest() throws PulsarAdminException {
        long config = 100L;
        long localUsed = 20L;
        long[] allUsage = new long[]{100L};
        long newQuota = this.rqCalc.computeLocalQuota(100L, 20L, allUsage);
        Assert.assertTrue((newQuota == 20L ? 1 : 0) != 0);
    }

    @Test
    public void testRQCalcGlobUsedGreaterThanConfigTest() throws PulsarAdminException {
        long config = 100L;
        long localUsed = 20L;
        long[] allUsage = new long[]{150L};
        long newQuota = this.rqCalc.computeLocalQuota(100L, 20L, allUsage);
        Assert.assertTrue((newQuota < 20L ? 1 : 0) != 0);
    }

    @Test
    public void testRQCalcProportionalIncrementTest() throws PulsarAdminException {
        long config = 100L;
        long[] allUsage = new long[]{60L};
        long localUsed1 = 20L;
        long localUsed2 = 40L;
        float initialUsageRatio = 0.5f;
        long newQuota1 = this.rqCalc.computeLocalQuota(100L, 20L, allUsage);
        long newQuota2 = this.rqCalc.computeLocalQuota(100L, 40L, allUsage);
        float proposedUsageRatio = (float)newQuota1 / (float)newQuota2;
        Assert.assertEquals((float)0.5f, (float)proposedUsageRatio);
    }
}

