/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pulsar.broker.service.GracefulExecutorServicesShutdown;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GracefulExecutorServicesShutdownTest {
    @Test
    public void shouldShutdownExecutorsImmediately() throws ExecutionException, InterruptedException, TimeoutException {
        GracefulExecutorServicesShutdown shutdown = GracefulExecutorServicesShutdown.initiate();
        ExecutorService executorService = (ExecutorService)Mockito.mock(ExecutorService.class);
        Mockito.when((Object)executorService.isTerminated()).thenReturn((Object)true);
        Mockito.when((Object)executorService.isShutdown()).thenReturn((Object)true);
        shutdown.shutdown(new ExecutorService[]{executorService});
        CompletableFuture future = shutdown.handle();
        ((ExecutorService)Mockito.verify((Object)executorService, (VerificationMode)Mockito.atLeastOnce())).shutdown();
        future.get(1L, TimeUnit.SECONDS);
        ((ExecutorService)Mockito.verify((Object)executorService, (VerificationMode)Mockito.never())).shutdownNow();
        Assert.assertTrue((boolean)future.isDone());
    }

    @Test
    public void shouldTerminateExecutorOnTimeout() throws ExecutionException, InterruptedException, TimeoutException {
        GracefulExecutorServicesShutdown shutdown = GracefulExecutorServicesShutdown.initiate();
        shutdown.timeout(Duration.ofMillis(500L));
        ExecutorService executorService = (ExecutorService)Mockito.mock(ExecutorService.class);
        Mockito.when((Object)executorService.isShutdown()).thenReturn((Object)true);
        AtomicBoolean terminated = new AtomicBoolean();
        Mockito.when((Object)executorService.isTerminated()).thenAnswer(invocation -> terminated.get());
        Mockito.when(executorService.shutdownNow()).thenAnswer(invocation -> {
            terminated.set(true);
            return null;
        });
        Mockito.when((Object)executorService.awaitTermination(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()))).thenAnswer(invocation -> {
            long timeout = (Long)invocation.getArgument(0);
            TimeUnit unit = (TimeUnit)((Object)((Object)invocation.getArgument(1)));
            Thread.sleep(unit.toMillis(timeout));
            return terminated.get();
        });
        shutdown.shutdown(new ExecutorService[]{executorService});
        CompletableFuture future = shutdown.handle();
        future.get(1L, TimeUnit.SECONDS);
        ((ExecutorService)Mockito.verify((Object)executorService, (VerificationMode)Mockito.atLeastOnce())).shutdownNow();
        Assert.assertTrue((boolean)future.isDone());
    }

    @Test
    public void shouldWaitForExecutorToTerminate() throws ExecutionException, InterruptedException, TimeoutException {
        GracefulExecutorServicesShutdown shutdown = GracefulExecutorServicesShutdown.initiate();
        shutdown.timeout(Duration.ofMillis(500L));
        ExecutorService executorService = (ExecutorService)Mockito.mock(ExecutorService.class);
        Mockito.when((Object)executorService.isShutdown()).thenReturn((Object)true);
        AtomicBoolean terminated = new AtomicBoolean();
        Mockito.when((Object)executorService.isTerminated()).thenAnswer(invocation -> terminated.get());
        Mockito.when((Object)executorService.awaitTermination(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()))).thenAnswer(invocation -> {
            long timeout = (Long)invocation.getArgument(0);
            TimeUnit unit = (TimeUnit)((Object)((Object)invocation.getArgument(1)));
            Thread.sleep(unit.toMillis(timeout /= 2L));
            terminated.set(true);
            return terminated.get();
        });
        shutdown.shutdown(new ExecutorService[]{executorService});
        CompletableFuture future = shutdown.handle();
        future.get(1L, TimeUnit.SECONDS);
        ((ExecutorService)Mockito.verify((Object)executorService, (VerificationMode)Mockito.times((int)1))).awaitTermination(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()));
        ((ExecutorService)Mockito.verify((Object)executorService, (VerificationMode)Mockito.never())).shutdownNow();
        Assert.assertTrue((boolean)future.isDone());
    }

    @Test
    public void shouldTerminateWhenFutureIsCancelled() throws InterruptedException, ExecutionException {
        GracefulExecutorServicesShutdown shutdown = GracefulExecutorServicesShutdown.initiate();
        shutdown.timeout(Duration.ofMillis(15000L));
        ExecutorService executorService = (ExecutorService)Mockito.mock(ExecutorService.class);
        Mockito.when((Object)executorService.isShutdown()).thenReturn((Object)true);
        AtomicBoolean terminated = new AtomicBoolean();
        CompletableFuture awaitTerminationInterrupted = new CompletableFuture();
        Mockito.when((Object)executorService.isTerminated()).thenAnswer(invocation -> terminated.get());
        CountDownLatch awaitingTerminationEntered = new CountDownLatch(1);
        Mockito.when((Object)executorService.awaitTermination(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()))).thenAnswer(invocation -> {
            long timeout = (Long)invocation.getArgument(0);
            TimeUnit unit = (TimeUnit)((Object)((Object)invocation.getArgument(1)));
            awaitingTerminationEntered.countDown();
            try {
                Thread.sleep(unit.toMillis(timeout));
            }
            catch (InterruptedException e) {
                awaitTerminationInterrupted.complete(true);
                Thread.currentThread().interrupt();
                throw e;
            }
            awaitTerminationInterrupted.complete(false);
            throw new IllegalStateException("Thread.sleep should have been interrupted");
        });
        Mockito.when(executorService.shutdownNow()).thenAnswer(invocation -> {
            terminated.set(true);
            return null;
        });
        shutdown.shutdown(new ExecutorService[]{executorService});
        CompletableFuture future = shutdown.handle();
        awaitingTerminationEntered.await();
        future.cancel(false);
        Assert.assertTrue((boolean)((Boolean)awaitTerminationInterrupted.get()), (String)"awaitTermination should have been interrupted");
        ((ExecutorService)Mockito.verify((Object)executorService, (VerificationMode)Mockito.times((int)1))).awaitTermination(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()));
        ((ExecutorService)Mockito.verify((Object)executorService, (VerificationMode)Mockito.times((int)1))).shutdownNow();
    }

    @Test
    public void shouldAcceptNullReferenceAndIgnoreIt() {
        Object executorService = null;
        CompletableFuture future = GracefulExecutorServicesShutdown.initiate().shutdown(new ExecutorService[]{executorService}).handle();
        Assert.assertTrue((boolean)future.isDone());
    }
}

