/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.Collections;
import org.apache.pulsar.broker.service.BrokerTestBase;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.RecordSchemaBuilder;
import org.apache.pulsar.client.api.schema.SchemaBuilder;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaImpl;
import org.apache.pulsar.client.impl.schema.generic.GenericAvroSchema;
import org.apache.pulsar.client.impl.schema.generic.GenericSchemaImpl;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class KeyValueTest
extends BrokerTestBase {
    private static final Logger log = LoggerFactory.getLogger(KeyValueTest.class);

    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        super.baseSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void keyValueAutoConsumeTest() throws Exception {
        String topic = "persistent://prop/ns-abc/kv-record";
        this.admin.topics().createNonPartitionedTopic(topic);
        RecordSchemaBuilder builder = SchemaBuilder.record((String)"test");
        builder.field("test").type(SchemaType.STRING);
        GenericSchemaImpl schema = GenericAvroSchema.of((SchemaInfo)builder.build(SchemaType.AVRO));
        GenericRecord key = schema.newRecordBuilder().set("test", (Object)"foo").build();
        GenericRecord value = schema.newRecordBuilder().set("test", (Object)"bar").build();
        Producer producer = this.pulsarClient.newProducer(KeyValueSchemaImpl.of((Schema)schema, (Schema)schema)).topic(topic).create();
        try {
            producer.newMessage().value((Object)new KeyValue((Object)key, (Object)value)).send();
            Consumer consumer = this.pulsarClient.newConsumer(KeyValueSchemaImpl.of((Schema)Schema.AUTO_CONSUME(), (Schema)Schema.AUTO_CONSUME())).topic(new String[]{topic}).subscriptionName("test").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
            try {
                Message message = consumer.receive();
                Assert.assertEquals((Object)key.getField("test"), (Object)((GenericRecord)((KeyValue)message.getValue()).getKey()).getField("test"));
                Assert.assertEquals((Object)value.getField("test"), (Object)((GenericRecord)((KeyValue)message.getValue()).getValue()).getField("test"));
            }
            finally {
                if (Collections.singletonList(consumer).get(0) != null) {
                    consumer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(producer).get(0) != null) {
                producer.close();
            }
        }
    }
}

