/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.JsonSchemaGenerator;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.pulsar.broker.service.schema.BaseAvroSchemaCompatibilityTest;
import org.apache.pulsar.broker.service.schema.JsonSchemaCompatibilityCheck;
import org.apache.pulsar.broker.service.schema.SchemaCompatibilityCheck;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.impl.schema.JSONSchema;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class JsonSchemaCompatibilityCheckTest
extends BaseAvroSchemaCompatibilityTest {
    @Override
    public SchemaCompatibilityCheck getSchemaCheck() {
        return new JsonSchemaCompatibilityCheck();
    }

    @Test
    public void testJsonSchemaBackwardsCompatibility() throws JsonProcessingException {
        SchemaData from = SchemaData.builder().data(OldJSONSchema.of(Foo.class).getSchemaInfo().getSchema()).build();
        SchemaData to = SchemaData.builder().data(JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build()).getSchemaInfo().getSchema()).build();
        JsonSchemaCompatibilityCheck jsonSchemaCompatibilityCheck = new JsonSchemaCompatibilityCheck();
        Assert.assertTrue((boolean)jsonSchemaCompatibilityCheck.isCompatible(from, to, SchemaCompatibilityStrategy.FULL));
        from = SchemaData.builder().data(JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build()).getSchemaInfo().getSchema()).build();
        to = SchemaData.builder().data(OldJSONSchema.of(Foo.class).getSchemaInfo().getSchema()).build();
        Assert.assertTrue((boolean)jsonSchemaCompatibilityCheck.isCompatible(from, to, SchemaCompatibilityStrategy.FULL));
    }

    public static class OldJSONSchema<T>
    implements Schema<T> {
        private final SchemaInfo info;
        private final ObjectMapper objectMapper;
        private final Class<T> pojo;

        private OldJSONSchema(SchemaInfo info, Class<T> pojo, ObjectMapper objectMapper) {
            this.info = info;
            this.pojo = pojo;
            this.objectMapper = objectMapper;
        }

        public byte[] encode(T message) throws SchemaSerializationException {
            try {
                return this.objectMapper.writeValueAsBytes(message);
            }
            catch (JsonProcessingException e) {
                throw new SchemaSerializationException((Throwable)e);
            }
        }

        public T decode(byte[] bytes) {
            try {
                return (T)this.objectMapper.readValue(new String(bytes), this.pojo);
            }
            catch (IOException e) {
                throw new RuntimeException((Throwable)new SchemaSerializationException((Throwable)e));
            }
        }

        public SchemaInfo getSchemaInfo() {
            return this.info;
        }

        public static <T> OldJSONSchema<T> of(Class<T> pojo) throws JsonProcessingException {
            return OldJSONSchema.of(pojo, Collections.emptyMap());
        }

        public static <T> OldJSONSchema<T> of(Class<T> pojo, Map<String, String> properties) throws JsonProcessingException {
            ObjectMapper mapper = new ObjectMapper();
            JsonSchemaGenerator schemaGen = new JsonSchemaGenerator(mapper);
            JsonSchema schema = schemaGen.generateSchema(pojo);
            SchemaInfoImpl info = SchemaInfoImpl.builder().name("").properties(properties).type(SchemaType.JSON).schema(mapper.writeValueAsBytes((Object)schema)).build();
            return new OldJSONSchema<T>((SchemaInfo)info, pojo, mapper);
        }

        public Schema<T> clone() {
            return this;
        }
    }

    private static class Bar {
        private boolean field1;

        public boolean isField1() {
            return this.field1;
        }

        public void setField1(boolean field1) {
            this.field1 = field1;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Bar)) {
                return false;
            }
            Bar other = (Bar)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isField1() == other.isField1();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Bar;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isField1() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "JsonSchemaCompatibilityCheckTest.Bar(field1=" + this.isField1() + ")";
        }
    }

    private static class Foo {
        private String field1;
        private String field2;
        private int field3;
        private Bar field4;

        public String getField1() {
            return this.field1;
        }

        public String getField2() {
            return this.field2;
        }

        public int getField3() {
            return this.field3;
        }

        public Bar getField4() {
            return this.field4;
        }

        public void setField1(String field1) {
            this.field1 = field1;
        }

        public void setField2(String field2) {
            this.field2 = field2;
        }

        public void setField3(int field3) {
            this.field3 = field3;
        }

        public void setField4(Bar field4) {
            this.field4 = field4;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Foo)) {
                return false;
            }
            Foo other = (Foo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getField3() != other.getField3()) {
                return false;
            }
            String this$field1 = this.getField1();
            String other$field1 = other.getField1();
            if (this$field1 == null ? other$field1 != null : !this$field1.equals(other$field1)) {
                return false;
            }
            String this$field2 = this.getField2();
            String other$field2 = other.getField2();
            if (this$field2 == null ? other$field2 != null : !this$field2.equals(other$field2)) {
                return false;
            }
            Bar this$field4 = this.getField4();
            Bar other$field4 = other.getField4();
            return !(this$field4 == null ? other$field4 != null : !((Object)this$field4).equals(other$field4));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Foo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getField3();
            String $field1 = this.getField1();
            result = result * 59 + ($field1 == null ? 43 : $field1.hashCode());
            String $field2 = this.getField2();
            result = result * 59 + ($field2 == null ? 43 : $field2.hashCode());
            Bar $field4 = this.getField4();
            result = result * 59 + ($field4 == null ? 43 : ((Object)$field4).hashCode());
            return result;
        }

        public String toString() {
            return "JsonSchemaCompatibilityCheckTest.Foo(field1=" + this.getField1() + ", field2=" + this.getField2() + ", field3=" + this.getField3() + ", field4=" + this.getField4() + ")";
        }
    }
}

