/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheck;
import org.apache.pulsar.broker.service.schema.BookkeeperSchemaStorage;
import org.apache.pulsar.broker.service.schema.SchemaRegistry;
import org.apache.pulsar.broker.service.schema.SchemaRegistryServiceImpl;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.protocol.schema.SchemaStorage;
import org.apache.pulsar.common.protocol.schema.SchemaVersion;
import org.apache.pulsar.common.schema.LongSchemaVersion;
import org.apache.pulsar.common.schema.SchemaType;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class SchemaServiceTest
extends MockedPulsarServiceBaseTest {
    private static final Clock MockClock = Clock.fixed(Instant.EPOCH, ZoneId.systemDefault());
    private final String schemaId1 = "1/2/3/4";
    private static final String userId = "user";
    private static final String schemaJson1 = "{\"type\":\"record\",\"name\":\"DefaultTest\",\"namespace\":\"org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheckTest\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"}]}";
    private static final SchemaData schemaData1 = SchemaServiceTest.getSchemaData("{\"type\":\"record\",\"name\":\"DefaultTest\",\"namespace\":\"org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheckTest\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"}]}");
    private static final String schemaJson2 = "{\"type\":\"record\",\"name\":\"DefaultTest\",\"namespace\":\"org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheckTest\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"},{\"name\":\"field2\",\"type\":\"string\",\"default\":\"foo\"}]}";
    private static final SchemaData schemaData2 = SchemaServiceTest.getSchemaData("{\"type\":\"record\",\"name\":\"DefaultTest\",\"namespace\":\"org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheckTest\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"},{\"name\":\"field2\",\"type\":\"string\",\"default\":\"foo\"}]}");
    private static final String schemaJson3 = "{\"type\":\"record\",\"name\":\"DefaultTest\",\"namespace\":\"org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheckTest\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"},{\"name\":\"field2\",\"type\":\"string\"}]}";
    private static final SchemaData schemaData3 = SchemaServiceTest.getSchemaData("{\"type\":\"record\",\"name\":\"DefaultTest\",\"namespace\":\"org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheckTest\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"},{\"name\":\"field2\",\"type\":\"string\"}]}");
    private SchemaRegistryServiceImpl schemaRegistryService;

    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        this.conf.setSchemaRegistryStorageClassName("org.apache.pulsar.broker.service.schema.BookkeeperSchemaStorageFactory");
        super.internalSetup();
        BookkeeperSchemaStorage storage = new BookkeeperSchemaStorage(this.pulsar);
        storage.start();
        HashMap<SchemaType, AvroSchemaCompatibilityCheck> checkMap = new HashMap<SchemaType, AvroSchemaCompatibilityCheck>();
        checkMap.put(SchemaType.AVRO, new AvroSchemaCompatibilityCheck());
        this.schemaRegistryService = new SchemaRegistryServiceImpl((SchemaStorage)storage, checkMap, MockClock);
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
        this.schemaRegistryService.close();
    }

    @Test
    public void writeReadBackDeleteSchemaEntry() throws Exception {
        this.putSchema("1/2/3/4", schemaData1, this.version(0L));
        SchemaData latest = this.getLatestSchema("1/2/3/4", this.version(0L));
        AssertJUnit.assertEquals((Object)schemaData1, (Object)latest);
        this.deleteSchema("1/2/3/4", this.version(1L));
        AssertJUnit.assertNull(this.schemaRegistryService.getSchema("1/2/3/4").get());
    }

    @Test
    public void findSchemaVersionTest() throws Exception {
        this.putSchema("1/2/3/4", schemaData1, this.version(0L));
        AssertJUnit.assertEquals((long)0L, (long)((Long)this.schemaRegistryService.findSchemaVersion("1/2/3/4", schemaData1).get()));
    }

    @Test
    public void deleteSchemaAndAddSchema() throws Exception {
        this.putSchema("1/2/3/4", schemaData1, this.version(0L));
        SchemaData latest = this.getLatestSchema("1/2/3/4", this.version(0L));
        AssertJUnit.assertEquals((Object)schemaData1, (Object)latest);
        this.deleteSchema("1/2/3/4", this.version(1L));
        AssertJUnit.assertNull(this.schemaRegistryService.getSchema("1/2/3/4").get());
        this.putSchema("1/2/3/4", schemaData1, this.version(2L));
        latest = this.getLatestSchema("1/2/3/4", this.version(2L));
        AssertJUnit.assertEquals((Object)schemaData1, (Object)latest);
    }

    @Test
    public void getReturnsTheLastWrittenEntry() throws Exception {
        this.putSchema("1/2/3/4", schemaData1, this.version(0L));
        this.putSchema("1/2/3/4", schemaData2, this.version(1L));
        SchemaData latest = this.getLatestSchema("1/2/3/4", this.version(1L));
        AssertJUnit.assertEquals((Object)schemaData2, (Object)latest);
    }

    @Test
    public void getByVersionReturnsTheCorrectEntry() throws Exception {
        this.putSchema("1/2/3/4", schemaData1, this.version(0L));
        this.putSchema("1/2/3/4", schemaData2, this.version(1L));
        SchemaData version0 = this.getSchema("1/2/3/4", this.version(0L));
        AssertJUnit.assertEquals((Object)schemaData1, (Object)version0);
    }

    @Test
    public void getByVersionReturnsTheCorrectEntry2() throws Exception {
        this.putSchema("1/2/3/4", schemaData1, this.version(0L));
        this.putSchema("1/2/3/4", schemaData2, this.version(1L));
        SchemaData version1 = this.getSchema("1/2/3/4", this.version(1L));
        AssertJUnit.assertEquals((Object)schemaData2, (Object)version1);
    }

    @Test
    public void getByVersionReturnsTheCorrectEntry3() throws Exception {
        this.putSchema("1/2/3/4", schemaData1, this.version(0L));
        SchemaData version1 = this.getSchema("1/2/3/4", this.version(0L));
        AssertJUnit.assertEquals((Object)schemaData1, (Object)version1);
    }

    @Test
    public void getAllVersionSchema() throws Exception {
        this.putSchema("1/2/3/4", schemaData1, this.version(0L));
        this.putSchema("1/2/3/4", schemaData2, this.version(1L));
        this.putSchema("1/2/3/4", schemaData3, this.version(2L));
        List<SchemaData> allSchemas = this.getAllSchemas("1/2/3/4");
        AssertJUnit.assertEquals((Object)schemaData1, (Object)allSchemas.get(0));
        AssertJUnit.assertEquals((Object)schemaData2, (Object)allSchemas.get(1));
        AssertJUnit.assertEquals((Object)schemaData3, (Object)allSchemas.get(2));
    }

    @Test
    public void addLotsOfEntriesThenDelete() throws Exception {
        this.putSchema("1/2/3/4", schemaData1, this.version(0L));
        this.putSchema("1/2/3/4", schemaData2, this.version(1L));
        this.putSchema("1/2/3/4", schemaData3, this.version(2L));
        SchemaData version0 = this.getSchema("1/2/3/4", this.version(0L));
        AssertJUnit.assertEquals((Object)schemaData1, (Object)version0);
        SchemaData version1 = this.getSchema("1/2/3/4", this.version(1L));
        AssertJUnit.assertEquals((Object)schemaData2, (Object)version1);
        SchemaData version2 = this.getSchema("1/2/3/4", this.version(2L));
        AssertJUnit.assertEquals((Object)schemaData3, (Object)version2);
        this.deleteSchema("1/2/3/4", this.version(3L));
        SchemaRegistry.SchemaAndMetadata version3 = (SchemaRegistry.SchemaAndMetadata)this.schemaRegistryService.getSchema("1/2/3/4", this.version(3L)).get();
        AssertJUnit.assertNull((Object)version3);
    }

    @Test
    public void writeSchemasToDifferentIds() throws Exception {
        this.putSchema("1/2/3/4", schemaData1, this.version(0L));
        String schemaId2 = "id2";
        this.putSchema(schemaId2, schemaData3, this.version(0L));
        SchemaData withFirstId = this.getLatestSchema("1/2/3/4", this.version(0L));
        SchemaData withDifferentId = this.getLatestSchema(schemaId2, this.version(0L));
        AssertJUnit.assertEquals((Object)schemaData1, (Object)withFirstId);
        AssertJUnit.assertEquals((Object)schemaData3, (Object)withDifferentId);
    }

    @Test
    public void dontReAddExistingSchemaAtRoot() throws Exception {
        this.putSchema("1/2/3/4", schemaData1, this.version(0L));
        this.putSchema("1/2/3/4", schemaData1, this.version(0L));
        this.putSchema("1/2/3/4", schemaData1, this.version(0L));
    }

    @Test
    public void trimDeletedSchemaAndGetListTest() throws Exception {
        ArrayList<SchemaRegistry.SchemaAndMetadata> list = new ArrayList<SchemaRegistry.SchemaAndMetadata>();
        CompletableFuture put = this.schemaRegistryService.putSchemaIfAbsent("1/2/3/4", schemaData1, SchemaCompatibilityStrategy.FULL);
        SchemaVersion newVersion = (SchemaVersion)put.get();
        list.add(new SchemaRegistry.SchemaAndMetadata("1/2/3/4", schemaData1, newVersion));
        put = this.schemaRegistryService.putSchemaIfAbsent("1/2/3/4", schemaData2, SchemaCompatibilityStrategy.FULL);
        newVersion = (SchemaVersion)put.get();
        list.add(new SchemaRegistry.SchemaAndMetadata("1/2/3/4", schemaData2, newVersion));
        List list1 = (List)this.schemaRegistryService.trimDeletedSchemaAndGetList("1/2/3/4").get();
        AssertJUnit.assertEquals((int)list.size(), (int)list1.size());
        HashFunction hashFunction = Hashing.sha256();
        for (int i = 0; i < list.size(); ++i) {
            SchemaRegistry.SchemaAndMetadata schemaAndMetadata1 = (SchemaRegistry.SchemaAndMetadata)list.get(i);
            SchemaRegistry.SchemaAndMetadata schemaAndMetadata2 = (SchemaRegistry.SchemaAndMetadata)list1.get(i);
            AssertJUnit.assertEquals((byte[])hashFunction.hashBytes(schemaAndMetadata1.schema.getData()).asBytes(), (byte[])hashFunction.hashBytes(schemaAndMetadata2.schema.getData()).asBytes());
            AssertJUnit.assertEquals((long)((LongSchemaVersion)schemaAndMetadata1.version).getVersion(), (long)((LongSchemaVersion)schemaAndMetadata2.version).getVersion());
            AssertJUnit.assertEquals((String)schemaAndMetadata1.id, (String)schemaAndMetadata2.id);
        }
    }

    @Test
    public void dontReAddExistingSchemaInMiddle() throws Exception {
        this.putSchema("1/2/3/4", schemaData1, this.version(0L));
        this.putSchema("1/2/3/4", schemaData2, this.version(1L));
        this.putSchema("1/2/3/4", schemaData3, this.version(2L));
        this.putSchema("1/2/3/4", schemaData2, this.version(1L));
    }

    @Test(expectedExceptions={ExecutionException.class})
    public void checkIsCompatible() throws Exception {
        this.putSchema("1/2/3/4", schemaData1, this.version(0L), SchemaCompatibilityStrategy.BACKWARD_TRANSITIVE);
        this.putSchema("1/2/3/4", schemaData2, this.version(1L), SchemaCompatibilityStrategy.BACKWARD_TRANSITIVE);
        AssertJUnit.assertTrue((boolean)((Boolean)this.schemaRegistryService.isCompatible("1/2/3/4", schemaData3, SchemaCompatibilityStrategy.BACKWARD).get()));
        AssertJUnit.assertFalse((boolean)((Boolean)this.schemaRegistryService.isCompatible("1/2/3/4", schemaData3, SchemaCompatibilityStrategy.BACKWARD_TRANSITIVE).get()));
        this.putSchema("1/2/3/4", schemaData3, this.version(2L), SchemaCompatibilityStrategy.BACKWARD_TRANSITIVE);
    }

    @Test(expectedExceptions={PulsarServerException.class})
    public void testSchemaStorageFailed() throws Exception {
        this.conf.setSchemaRegistryStorageClassName("Unknown class name");
        this.restartBroker();
    }

    private void putSchema(String schemaId, SchemaData schema, SchemaVersion expectedVersion) throws Exception {
        this.putSchema(schemaId, schema, expectedVersion, SchemaCompatibilityStrategy.FULL);
    }

    private void putSchema(String schemaId, SchemaData schema, SchemaVersion expectedVersion, SchemaCompatibilityStrategy strategy) throws ExecutionException, InterruptedException {
        CompletableFuture put = this.schemaRegistryService.putSchemaIfAbsent(schemaId, schema, strategy);
        SchemaVersion newVersion = (SchemaVersion)put.get();
        AssertJUnit.assertEquals((Object)expectedVersion, (Object)newVersion);
    }

    private SchemaData getLatestSchema(String schemaId, SchemaVersion expectedVersion) throws Exception {
        SchemaRegistry.SchemaAndMetadata schemaAndVersion = (SchemaRegistry.SchemaAndMetadata)this.schemaRegistryService.getSchema(schemaId).get();
        AssertJUnit.assertEquals((Object)expectedVersion, (Object)schemaAndVersion.version);
        AssertJUnit.assertEquals((String)schemaId, (String)schemaAndVersion.id);
        return schemaAndVersion.schema;
    }

    private SchemaData getSchema(String schemaId, SchemaVersion version) throws Exception {
        SchemaRegistry.SchemaAndMetadata schemaAndVersion = (SchemaRegistry.SchemaAndMetadata)this.schemaRegistryService.getSchema(schemaId, version).get();
        AssertJUnit.assertEquals((Object)version, (Object)schemaAndVersion.version);
        AssertJUnit.assertEquals((String)schemaId, (String)schemaAndVersion.id);
        return schemaAndVersion.schema;
    }

    private List<SchemaData> getAllSchemas(String schemaId) throws Exception {
        ArrayList<SchemaData> result = new ArrayList<SchemaData>();
        for (CompletableFuture schema : (List)this.schemaRegistryService.getAllSchemas(schemaId).get()) {
            result.add(((SchemaRegistry.SchemaAndMetadata)schema.get()).schema);
        }
        return result;
    }

    private void deleteSchema(String schemaId, SchemaVersion expectedVersion) throws Exception {
        SchemaVersion version = (SchemaVersion)this.schemaRegistryService.deleteSchema(schemaId, userId).get();
        AssertJUnit.assertEquals((Object)expectedVersion, (Object)version);
    }

    private SchemaData randomSchema() {
        UUID randomString = UUID.randomUUID();
        return SchemaData.builder().user(userId).type(SchemaType.JSON).timestamp(MockClock.millis()).isDeleted(false).data(randomString.toString().getBytes()).props(new TreeMap()).build();
    }

    private static SchemaData getSchemaData(String schemaJson) {
        return SchemaData.builder().data(schemaJson.getBytes()).type(SchemaType.AVRO).user(userId).build();
    }

    private SchemaVersion version(long version) {
        return new LongSchemaVersion(version);
    }
}

