/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus;

import org.apache.pulsar.broker.stats.prometheus.AggregatedNamespaceStats;
import org.apache.pulsar.broker.stats.prometheus.AggregatedReplicationStats;
import org.apache.pulsar.broker.stats.prometheus.AggregatedSubscriptionStats;
import org.apache.pulsar.broker.stats.prometheus.TopicStats;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class AggregatedNamespaceStatsTest {
    @Test
    public void testSimpleAggregation() {
        String namespace = "tenant/cluster/ns";
        TopicStats topicStats1 = new TopicStats();
        topicStats1.subscriptionsCount = 2;
        topicStats1.producersCount = 1;
        topicStats1.consumersCount = 3;
        topicStats1.rateIn = 10.0;
        topicStats1.rateOut = 20.0;
        topicStats1.throughputIn = 10240.0;
        topicStats1.throughputOut = 20480.0;
        topicStats1.managedLedgerStats.storageSize = 5120L;
        topicStats1.managedLedgerStats.storageLogicalSize = 2048L;
        topicStats1.msgBacklog = 30L;
        topicStats1.managedLedgerStats.storageWriteRate = 12.0;
        topicStats1.managedLedgerStats.storageReadRate = 6.0;
        AggregatedReplicationStats replStats1 = new AggregatedReplicationStats();
        replStats1.msgRateIn = 1.0;
        replStats1.msgThroughputIn = 126.0;
        replStats1.msgRateOut = 2.0;
        replStats1.msgThroughputOut = 256.0;
        replStats1.replicationBacklog = 1L;
        replStats1.connectedCount = 0L;
        replStats1.msgRateExpired = 3.0;
        replStats1.replicationDelayInSeconds = 20L;
        topicStats1.replicationStats.put("tenant/cluster/ns", replStats1);
        AggregatedSubscriptionStats subStats1 = new AggregatedSubscriptionStats();
        subStats1.msgBacklog = 50L;
        subStats1.msgRateRedeliver = 1.5;
        subStats1.unackedMessages = 2L;
        subStats1.msgBacklogNoDelayed = 30L;
        topicStats1.subscriptionStats.put("tenant/cluster/ns", subStats1);
        TopicStats topicStats2 = new TopicStats();
        topicStats2.subscriptionsCount = 10;
        topicStats2.producersCount = 3;
        topicStats2.consumersCount = 5;
        topicStats2.rateIn = 0.1;
        topicStats2.rateOut = 0.5;
        topicStats2.throughputIn = 512.0;
        topicStats2.throughputOut = 1024.5;
        topicStats2.managedLedgerStats.storageSize = 1024L;
        topicStats2.managedLedgerStats.storageLogicalSize = 512L;
        topicStats2.msgBacklog = 7L;
        topicStats2.managedLedgerStats.storageWriteRate = 5.0;
        topicStats2.managedLedgerStats.storageReadRate = 2.5;
        AggregatedReplicationStats replStats2 = new AggregatedReplicationStats();
        replStats2.msgRateIn = 3.5;
        replStats2.msgThroughputIn = 512.0;
        replStats2.msgRateOut = 10.5;
        replStats2.msgThroughputOut = 1536.0;
        replStats2.replicationBacklog = 99L;
        replStats2.connectedCount = 1L;
        replStats2.msgRateExpired = 3.0;
        replStats2.replicationDelayInSeconds = 20L;
        topicStats2.replicationStats.put("tenant/cluster/ns", replStats2);
        AggregatedSubscriptionStats subStats2 = new AggregatedSubscriptionStats();
        subStats2.msgBacklog = 27L;
        subStats2.msgRateRedeliver = 0.7;
        subStats2.unackedMessages = 0L;
        subStats2.msgBacklogNoDelayed = 20L;
        topicStats2.subscriptionStats.put("tenant/cluster/ns", subStats2);
        AggregatedNamespaceStats nsStats = new AggregatedNamespaceStats();
        nsStats.updateStats(topicStats1);
        nsStats.updateStats(topicStats2);
        Assert.assertEquals((int)nsStats.topicsCount, (int)2);
        Assert.assertEquals((int)nsStats.subscriptionsCount, (int)12);
        Assert.assertEquals((int)nsStats.producersCount, (int)4);
        Assert.assertEquals((int)nsStats.consumersCount, (int)8);
        Assert.assertEquals((double)nsStats.rateIn, (double)10.1);
        Assert.assertEquals((double)nsStats.rateOut, (double)20.5);
        Assert.assertEquals((double)nsStats.throughputIn, (double)10752.0);
        Assert.assertEquals((double)nsStats.throughputOut, (double)21504.5);
        Assert.assertEquals((long)nsStats.managedLedgerStats.storageSize, (long)6144L);
        Assert.assertEquals((long)nsStats.msgBacklog, (long)37L);
        Assert.assertEquals((double)nsStats.managedLedgerStats.storageWriteRate, (double)17.0);
        Assert.assertEquals((double)nsStats.managedLedgerStats.storageReadRate, (double)8.5);
        Assert.assertEquals((long)nsStats.managedLedgerStats.storageSize, (long)6144L);
        Assert.assertEquals((long)nsStats.managedLedgerStats.storageLogicalSize, (long)2560L);
        AggregatedReplicationStats nsReplStats = (AggregatedReplicationStats)nsStats.replicationStats.get("tenant/cluster/ns");
        Assert.assertNotNull((Object)nsReplStats);
        Assert.assertEquals((double)nsReplStats.msgRateIn, (double)4.5);
        Assert.assertEquals((double)nsReplStats.msgThroughputIn, (double)638.0);
        Assert.assertEquals((double)nsReplStats.msgRateOut, (double)12.5);
        Assert.assertEquals((double)nsReplStats.msgThroughputOut, (double)1792.0);
        Assert.assertEquals((long)nsReplStats.replicationBacklog, (long)100L);
        Assert.assertEquals((long)nsReplStats.connectedCount, (long)1L);
        Assert.assertEquals((double)nsReplStats.msgRateExpired, (double)6.0);
        Assert.assertEquals((long)nsReplStats.replicationDelayInSeconds, (long)40L);
        AggregatedSubscriptionStats nsSubStats = (AggregatedSubscriptionStats)nsStats.subscriptionStats.get("tenant/cluster/ns");
        Assert.assertNotNull((Object)nsSubStats);
        Assert.assertEquals((long)nsSubStats.msgBacklog, (long)77L);
        Assert.assertEquals((long)nsSubStats.msgBacklogNoDelayed, (long)50L);
        Assert.assertEquals((double)nsSubStats.msgRateRedeliver, (double)2.2);
        Assert.assertEquals((long)nsSubStats.unackedMessages, (long)2L);
    }
}

