/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction;

import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.transaction.TransactionTestBase;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.common.api.proto.MessageIdData;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.common.protocol.Commands;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class TransactionConsumeTest
extends TransactionTestBase {
    private static final Logger log = LoggerFactory.getLogger(TransactionConsumeTest.class);
    private static final String CONSUME_TOPIC = "persistent://public/txn/txn-consume-test";
    private static final String NORMAL_MSG_CONTENT = "Normal - ";
    private static final String TXN_MSG_CONTENT = "Txn - ";

    @BeforeMethod(alwaysRun=true)
    public void setup() throws Exception {
        this.setBrokerCount(1);
        super.internalSetup();
        String[] brokerServiceUrlArr = this.getPulsarServiceList().get(0).getBrokerServiceUrl().split(":");
        String webServicePort = brokerServiceUrlArr[brokerServiceUrlArr.length - 1];
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl("http://localhost:" + webServicePort).build());
        this.admin.tenants().createTenant("public", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet(), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace("public/txn", 10);
        this.admin.topics().createNonPartitionedTopic(CONSUME_TOPIC);
    }

    @AfterMethod(alwaysRun=true)
    protected void cleanup() {
        super.internalCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void noSortedTest() throws Exception {
        int messageCntBeforeTxn = 10;
        int transactionMessageCnt = 10;
        int messageCntAfterTxn = 10;
        int totalMsgCnt = messageCntBeforeTxn + transactionMessageCnt + messageCntAfterTxn;
        Producer producer = this.pulsarClient.newProducer().topic(CONSUME_TOPIC).create();
        try {
            Consumer exclusiveConsumer = this.pulsarClient.newConsumer().topic(new String[]{CONSUME_TOPIC}).subscriptionName("exclusive-test").subscribe();
            try {
                Consumer sharedConsumer = this.pulsarClient.newConsumer().topic(new String[]{CONSUME_TOPIC}).subscriptionName("shared-test").subscriptionType(SubscriptionType.Shared).subscribe();
                try {
                    Message message;
                    int i;
                    Awaitility.await().until(() -> ((Consumer)exclusiveConsumer).isConnected());
                    Awaitility.await().until(() -> ((Consumer)sharedConsumer).isConnected());
                    long mostSigBits = 2L;
                    long leastSigBits = 5L;
                    TxnID txnID = new TxnID(mostSigBits, leastSigBits);
                    PersistentTopic persistentTopic = (PersistentTopic)((Optional)this.getPulsarServiceList().get(0).getBrokerService().getTopic(CONSUME_TOPIC, false).get()).get();
                    log.info("transactionBuffer init finish.");
                    ArrayList<String> sendMessageList = new ArrayList<String>();
                    this.sendNormalMessages((Producer<byte[]>)producer, 0, messageCntBeforeTxn, sendMessageList);
                    this.appendTransactionMessages(txnID, persistentTopic, transactionMessageCnt, sendMessageList);
                    this.sendNormalMessages((Producer<byte[]>)producer, messageCntBeforeTxn, messageCntAfterTxn, sendMessageList);
                    for (i = 0; i < totalMsgCnt; ++i) {
                        if (i < messageCntBeforeTxn) {
                            message = exclusiveConsumer.receive(2, TimeUnit.SECONDS);
                            Assert.assertNotNull((Object)message);
                            log.info("Receive exclusive normal msg: {}" + new String(message.getData(), StandardCharsets.UTF_8));
                            message = sharedConsumer.receive(2, TimeUnit.SECONDS);
                            Assert.assertNotNull((Object)message);
                            log.info("Receive shared normal msg: {}" + new String(message.getData(), StandardCharsets.UTF_8));
                            continue;
                        }
                        message = exclusiveConsumer.receive(500, TimeUnit.MILLISECONDS);
                        Assert.assertNull((Object)message);
                        log.info("exclusive consumer can't receive message before commit.");
                        message = sharedConsumer.receive(500, TimeUnit.MILLISECONDS);
                        Assert.assertNull((Object)message);
                        log.info("shared consumer can't receive message before commit.");
                    }
                    persistentTopic.endTxn(txnID, 0, 0L).get();
                    log.info("Commit txn.");
                    for (i = 0; i < transactionMessageCnt + messageCntAfterTxn; ++i) {
                        message = exclusiveConsumer.receive(5, TimeUnit.SECONDS);
                        Assert.assertNotNull((Object)message);
                        log.info("Receive txn exclusive id: {}, msg: {}", (Object)message.getMessageId(), (Object)new String(message.getData()));
                        message = sharedConsumer.receive(5, TimeUnit.SECONDS);
                        Assert.assertNotNull((Object)message);
                        log.info("Receive txn shared id: {}, msg: {}", (Object)message.getMessageId(), (Object)new String(message.getData()));
                    }
                    log.info("TransactionConsumeTest noSortedTest finish.");
                }
                finally {
                    if (Collections.singletonList(sharedConsumer).get(0) != null) {
                        sharedConsumer.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(exclusiveConsumer).get(0) != null) {
                    exclusiveConsumer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(producer).get(0) != null) {
                producer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sortedTest() throws Exception {
        int messageCntBeforeTxn = 10;
        int transactionMessageCnt = 10;
        int messageCntAfterTxn = 10;
        int totalMsgCnt = messageCntBeforeTxn + transactionMessageCnt + messageCntAfterTxn;
        Producer producer = this.pulsarClient.newProducer().topic(CONSUME_TOPIC).create();
        try {
            Consumer exclusiveConsumer = this.pulsarClient.newConsumer().topic(new String[]{CONSUME_TOPIC}).subscriptionName("exclusive-test").subscribe();
            try {
                Consumer sharedConsumer = this.pulsarClient.newConsumer().topic(new String[]{CONSUME_TOPIC}).subscriptionName("shared-test").subscriptionType(SubscriptionType.Shared).subscribe();
                try {
                    Awaitility.await().until(() -> ((Consumer)exclusiveConsumer).isConnected());
                    Awaitility.await().until(() -> ((Consumer)sharedConsumer).isConnected());
                    long mostSigBits = 2L;
                    long leastSigBits = 5L;
                    TxnID txnID = new TxnID(mostSigBits, leastSigBits);
                    PersistentTopic persistentTopic = (PersistentTopic)((Optional)this.getPulsarServiceList().get(0).getBrokerService().getTopic(CONSUME_TOPIC, false).get()).get();
                    ArrayList<String> sendMessageList = new ArrayList<String>();
                    this.sendNormalMessages((Producer<byte[]>)producer, 0, messageCntBeforeTxn, sendMessageList);
                    this.appendTransactionMessages(txnID, persistentTopic, transactionMessageCnt, sendMessageList);
                    persistentTopic.endTxn(txnID, 0, 0L).get();
                    log.info("Commit txn.");
                    this.sendNormalMessages((Producer<byte[]>)producer, messageCntBeforeTxn, messageCntAfterTxn, sendMessageList);
                    for (int i = 0; i < totalMsgCnt; ++i) {
                        Message message = exclusiveConsumer.receive(2, TimeUnit.SECONDS);
                        Assert.assertNotNull((Object)message);
                        Assert.assertEquals((String)((String)sendMessageList.get(i)), (String)new String(message.getData()));
                        log.info("Receive exclusive normal msg: {}, index: {}", (Object)new String(message.getData(), StandardCharsets.UTF_8), (Object)i);
                        message = sharedConsumer.receive(2, TimeUnit.SECONDS);
                        Assert.assertNotNull((Object)message);
                        Assert.assertEquals((String)((String)sendMessageList.get(i)), (String)new String(message.getData()));
                        log.info("Receive shared normal msg: {}, index: {}", (Object)new String(message.getData(), StandardCharsets.UTF_8), (Object)i);
                    }
                    log.info("TransactionConsumeTest sortedTest finish.");
                }
                finally {
                    if (Collections.singletonList(sharedConsumer).get(0) != null) {
                        sharedConsumer.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(exclusiveConsumer).get(0) != null) {
                    exclusiveConsumer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(producer).get(0) != null) {
                producer.close();
            }
        }
    }

    private void sendNormalMessages(Producer<byte[]> producer, int startMsgCnt, int messageCnt, List<String> sendMessageList) throws PulsarClientException {
        for (int i = 0; i < messageCnt; ++i) {
            String msg = NORMAL_MSG_CONTENT + (startMsgCnt + i);
            sendMessageList.add(msg);
            producer.newMessage().value((Object)msg.getBytes(StandardCharsets.UTF_8)).send();
        }
    }

    private List<MessageIdData> appendTransactionMessages(TxnID txnID, PersistentTopic topic, int transactionMsgCnt, List<String> sendMessageList) throws ExecutionException, InterruptedException {
        ArrayList<MessageIdData> positionList = new ArrayList<MessageIdData>();
        for (int i = 0; i < transactionMsgCnt; ++i) {
            final int j = i;
            MessageMetadata metadata = new MessageMetadata().setProducerName("producerName").setSequenceId((long)i).setTxnidMostBits(txnID.getMostSigBits()).setTxnidLeastBits(txnID.getLeastSigBits()).setPublishTime(System.currentTimeMillis());
            String msg = TXN_MSG_CONTENT + i;
            sendMessageList.add(msg);
            ByteBuf headerAndPayload = Commands.serializeMetadataAndPayload((Commands.ChecksumType)Commands.ChecksumType.Crc32c, (MessageMetadata)metadata, (ByteBuf)Unpooled.copiedBuffer((byte[])msg.getBytes(StandardCharsets.UTF_8)));
            final CompletableFuture completableFuture = new CompletableFuture();
            topic.publishTxnMessage(txnID, headerAndPayload, new Topic.PublishContext(){

                public String getProducerName() {
                    return "test";
                }

                public long getSequenceId() {
                    return j + 30;
                }

                public String getOriginalProducerName() {
                    return "test";
                }

                public long getOriginalSequenceId() {
                    return j + 30;
                }

                public long getHighestSequenceId() {
                    return j + 30;
                }

                public long getOriginalHighestSequenceId() {
                    return j + 30;
                }

                public long getNumberOfMessages() {
                    return j + 30;
                }

                public void completed(Exception e, long ledgerId, long entryId) {
                    completableFuture.complete(PositionImpl.get((long)ledgerId, (long)entryId));
                }
            });
            positionList.add(new MessageIdData().setLedgerId(((PositionImpl)completableFuture.get()).getLedgerId()).setEntryId(((PositionImpl)completableFuture.get()).getEntryId()));
        }
        log.info("append messages to TB finish.");
        return positionList;
    }
}

