/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction;

import com.google.common.util.concurrent.MoreExecutors;
import io.netty.channel.EventLoopGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.client.PulsarMockBookKeeper;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.pulsar.broker.BookKeeperClientFactory;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.auth.SameThreadOrderedSafeExecutor;
import org.apache.pulsar.broker.intercept.CounterBrokerInterceptor;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.metadata.impl.ZKMetadataStore;
import org.apache.pulsar.tests.TestRetrySupport;
import org.apache.pulsar.transaction.coordinator.TransactionCoordinatorID;
import org.apache.pulsar.transaction.coordinator.TransactionMetadataStore;
import org.apache.pulsar.transaction.coordinator.TransactionMetadataStoreState;
import org.apache.pulsar.transaction.coordinator.impl.MLTransactionMetadataStore;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.pulsar.zookeeper.ZookeeperClientFactoryImpl;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.MockZooKeeper;
import org.apache.zookeeper.MockZooKeeperSession;
import org.apache.zookeeper.ZooKeeper;
import org.awaitility.Awaitility;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.AssertJUnit;

public abstract class TransactionTestBase
extends TestRetrySupport {
    private static final Logger log = LoggerFactory.getLogger(TransactionTestBase.class);
    public static final String CLUSTER_NAME = "test";
    private int brokerCount = 3;
    private final List<SameThreadOrderedSafeExecutor> orderedExecutorList = new ArrayList<SameThreadOrderedSafeExecutor>();
    private final List<ServiceConfiguration> serviceConfigurationList = new ArrayList<ServiceConfiguration>();
    private final List<PulsarService> pulsarServiceList = new ArrayList<PulsarService>();
    protected PulsarAdmin admin;
    protected PulsarClient pulsarClient;
    private MockZooKeeper mockZooKeeper;
    private OrderedExecutor bkExecutor;
    private NonClosableMockBookKeeper mockBookKeeper;
    protected ZooKeeperClientFactory mockZooKeeperClientFactory = new ZooKeeperClientFactory(){

        public CompletableFuture<ZooKeeper> create(String serverList, ZooKeeperClientFactory.SessionType sessionType, int zkSessionTimeoutMillis) {
            return CompletableFuture.completedFuture(TransactionTestBase.this.mockZooKeeper);
        }
    };
    private final BookKeeperClientFactory mockBookKeeperClientFactory = new BookKeeperClientFactory(){

        public BookKeeper create(ServiceConfiguration conf, ZooKeeper zkClient, EventLoopGroup eventLoopGroup, Optional<Class<? extends EnsemblePlacementPolicy>> ensemblePlacementPolicyClass, Map<String, Object> properties) {
            return TransactionTestBase.this.mockBookKeeper;
        }

        public BookKeeper create(ServiceConfiguration conf, ZooKeeper zkClient, EventLoopGroup eventLoopGroup, Optional<Class<? extends EnsemblePlacementPolicy>> ensemblePlacementPolicyClass, Map<String, Object> properties, StatsLogger statsLogger) {
            return TransactionTestBase.this.mockBookKeeper;
        }

        public void close() {
        }
    };

    public void internalSetup() throws Exception {
        this.incrementSetupNumber();
        this.init();
        if (this.admin != null) {
            this.admin.close();
        }
        this.admin = (PulsarAdmin)Mockito.spy((Object)PulsarAdmin.builder().serviceHttpUrl(this.pulsarServiceList.get(0).getWebServiceAddress()).build());
        if (this.pulsarClient != null) {
            this.pulsarClient.shutdown();
        }
        this.pulsarClient = PulsarClient.builder().serviceUrl(this.pulsarServiceList.get(0).getBrokerServiceUrl()).build();
    }

    private void init() throws Exception {
        this.mockZooKeeper = TransactionTestBase.createMockZooKeeper();
        this.bkExecutor = OrderedExecutor.newBuilder().numThreads(1).name("mock-pulsar-bk").build();
        this.mockBookKeeper = TransactionTestBase.createMockBookKeeper(this.bkExecutor);
        this.startBroker();
    }

    protected void startBroker() throws Exception {
        for (int i = 0; i < this.brokerCount; ++i) {
            ServiceConfiguration conf = new ServiceConfiguration();
            conf.setClusterName(CLUSTER_NAME);
            conf.setAdvertisedAddress("localhost");
            conf.setManagedLedgerCacheSizeMB(8);
            conf.setActiveConsumerFailoverDelayTimeMillis(0);
            conf.setDefaultNumberOfNamespaceBundles(1);
            conf.setZookeeperServers("localhost:2181");
            conf.setConfigurationStoreServers("localhost:3181");
            conf.setAllowAutoTopicCreationType("non-partitioned");
            conf.setBookkeeperClientExposeStatsToPrometheus(true);
            conf.setAcknowledgmentAtBatchIndexLevelEnabled(true);
            conf.setBrokerShutdownTimeoutMs(0L);
            conf.setBrokerServicePort(Optional.of(0));
            conf.setBrokerServicePortTls(Optional.of(0));
            conf.setAdvertisedAddress("localhost");
            conf.setWebServicePort(Optional.of(0));
            conf.setWebServicePortTls(Optional.of(0));
            conf.setTransactionCoordinatorEnabled(true);
            conf.setBrokerDeduplicationEnabled(true);
            conf.setSystemTopicEnabled(true);
            conf.setTransactionBufferSnapshotMaxTransactionCount(2);
            conf.setTransactionBufferSnapshotMinTimeInMillis(2000);
            this.serviceConfigurationList.add(conf);
            PulsarService pulsar = (PulsarService)Mockito.spy((Object)new PulsarService(conf));
            this.setupBrokerMocks(pulsar);
            pulsar.start();
            this.pulsarServiceList.add(pulsar);
        }
    }

    protected void setupBrokerMocks(PulsarService pulsar) throws Exception {
        ((PulsarService)Mockito.doReturn((Object)this.mockZooKeeperClientFactory).when((Object)pulsar)).getZooKeeperClientFactory();
        ((PulsarService)Mockito.doReturn((Object)this.mockBookKeeperClientFactory).when((Object)pulsar)).newBookKeeperClientFactory();
        MockZooKeeperSession mockZooKeeperSession = MockZooKeeperSession.newInstance((MockZooKeeper)this.mockZooKeeper);
        ((PulsarService)Mockito.doReturn((Object)new ZKMetadataStore((ZooKeeper)mockZooKeeperSession)).when((Object)pulsar)).createLocalMetadataStore();
        ((PulsarService)Mockito.doReturn((Object)new ZKMetadataStore((ZooKeeper)mockZooKeeperSession)).when((Object)pulsar)).createConfigurationMetadataStore();
        Supplier<NamespaceService> namespaceServiceSupplier = () -> (NamespaceService)Mockito.spy((Object)new NamespaceService(pulsar));
        ((PulsarService)Mockito.doReturn(namespaceServiceSupplier).when((Object)pulsar)).getNamespaceServiceProvider();
        SameThreadOrderedSafeExecutor executor = new SameThreadOrderedSafeExecutor();
        this.orderedExecutorList.add(executor);
        ((PulsarService)Mockito.doReturn((Object)((Object)executor)).when((Object)pulsar)).getOrderedExecutor();
        ((PulsarService)Mockito.doReturn((Object)new CounterBrokerInterceptor()).when((Object)pulsar)).getBrokerInterceptor();
        ((PulsarService)Mockito.doAnswer(invocation -> Mockito.spy((Object)invocation.callRealMethod())).when((Object)pulsar)).newCompactor();
    }

    public static MockZooKeeper createMockZooKeeper() throws Exception {
        MockZooKeeper zk = MockZooKeeper.newInstance((ExecutorService)MoreExecutors.newDirectExecutorService());
        ArrayList dummyAclList = new ArrayList(0);
        ZkUtils.createFullPathOptimistic((ZooKeeper)zk, (String)"/ledgers/available/192.168.1.1:5000", (byte[])"".getBytes(ZookeeperClientFactoryImpl.ENCODING_SCHEME), dummyAclList, (CreateMode)CreateMode.PERSISTENT);
        zk.create("/ledgers/LAYOUT", "1\nflat:1".getBytes(ZookeeperClientFactoryImpl.ENCODING_SCHEME), dummyAclList, CreateMode.PERSISTENT);
        return zk;
    }

    public static NonClosableMockBookKeeper createMockBookKeeper(OrderedExecutor executor) throws Exception {
        return (NonClosableMockBookKeeper)((Object)Mockito.spy((Object)((Object)new NonClosableMockBookKeeper(executor))));
    }

    protected final void internalCleanup() {
        block15: {
            this.markCurrentSetupNumberCleaned();
            try {
                if (this.admin != null) {
                    this.admin.close();
                    this.admin = null;
                }
                if (this.pulsarClient != null) {
                    this.pulsarClient.shutdown();
                    this.pulsarClient = null;
                }
                if (this.pulsarServiceList.size() > 0) {
                    for (PulsarService pulsarService : this.pulsarServiceList) {
                        pulsarService.close();
                    }
                    this.pulsarServiceList.clear();
                }
                if (this.serviceConfigurationList.size() > 0) {
                    this.serviceConfigurationList.clear();
                }
                if (this.mockBookKeeper != null) {
                    this.mockBookKeeper.reallyShutdown();
                }
                if (this.mockZooKeeper != null) {
                    this.mockZooKeeper.shutdown();
                }
                if (this.orderedExecutorList.size() > 0) {
                    for (int i = 0; i < this.orderedExecutorList.size(); ++i) {
                        SameThreadOrderedSafeExecutor sameThreadOrderedSafeExecutor = this.orderedExecutorList.get(i);
                        if (sameThreadOrderedSafeExecutor == null) continue;
                        try {
                            sameThreadOrderedSafeExecutor.shutdownNow();
                            sameThreadOrderedSafeExecutor.awaitTermination(5L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException ex) {
                            log.error("sameThreadOrderedSafeExecutor shutdown had error", (Throwable)ex);
                            Thread.currentThread().interrupt();
                        }
                        this.orderedExecutorList.set(i, null);
                    }
                }
                if (this.bkExecutor == null) break block15;
                try {
                    this.bkExecutor.shutdownNow();
                    this.bkExecutor.awaitTermination(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ex) {
                    log.error("bkExecutor shutdown had error", (Throwable)ex);
                    Thread.currentThread().interrupt();
                }
                this.bkExecutor = null;
            }
            catch (Exception e) {
                log.warn("Failed to clean up mocked pulsar service:", (Throwable)e);
            }
        }
    }

    public boolean waitForCoordinatorToBeAvailable(int numOfBroker, int numOfTCPerBroker) {
        Awaitility.await().untilAsserted(() -> {
            TransactionMetadataStore transactionMetadataStore = (TransactionMetadataStore)this.getPulsarServiceList().get(numOfBroker - 1).getTransactionMetadataStoreService().getStores().get(TransactionCoordinatorID.get((long)(numOfTCPerBroker - 1)));
            AssertJUnit.assertNotNull((Object)transactionMetadataStore);
            AssertJUnit.assertEquals((Object)((MLTransactionMetadataStore)transactionMetadataStore).getState(), (Object)TransactionMetadataStoreState.State.Ready);
        });
        return true;
    }

    public void setBrokerCount(int brokerCount) {
        this.brokerCount = brokerCount;
    }

    public List<ServiceConfiguration> getServiceConfigurationList() {
        return this.serviceConfigurationList;
    }

    public List<PulsarService> getPulsarServiceList() {
        return this.pulsarServiceList;
    }

    public static class NonClosableMockBookKeeper
    extends PulsarMockBookKeeper {
        public NonClosableMockBookKeeper(OrderedExecutor executor) throws Exception {
            super(executor);
        }

        public void close() {
        }

        public void shutdown() {
        }

        public void reallyShutdown() {
            super.shutdown();
        }
    }
}

