/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.coordinator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.transaction.coordinator.TransactionMetaStoreTestBase;
import org.awaitility.Awaitility;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class TransactionMetaStoreAssignmentTest
extends TransactionMetaStoreTestBase {
    @Test(groups={"broker"})
    public void testTransactionMetaStoreAssignAndFailover() throws IOException {
        Awaitility.await().untilAsserted(() -> {
            int transactionMetaStoreCount = Arrays.stream(this.pulsarServices).mapToInt(pulsarService -> pulsarService.getTransactionMetadataStoreService().getStores().size()).sum();
            Assert.assertEquals((int)transactionMetaStoreCount, (int)16);
        });
        PulsarService crashedMetaStore = null;
        for (int i = this.pulsarServices.length - 1; i >= 0; --i) {
            if (this.pulsarServices[i].getTransactionMetadataStoreService().getStores().size() <= 0) continue;
            crashedMetaStore = this.pulsarServices[i];
            break;
        }
        Assert.assertNotNull(crashedMetaStore);
        ArrayList<PulsarService> services = new ArrayList<PulsarService>(this.pulsarServices.length - 1);
        for (PulsarService pulsarService : this.pulsarServices) {
            if (pulsarService == crashedMetaStore) continue;
            services.add(pulsarService);
        }
        this.pulsarServices = new PulsarService[this.pulsarServices.length - 1];
        for (int i = 0; i < services.size(); ++i) {
            this.pulsarServices[i] = (PulsarService)services.get(i);
        }
        crashedMetaStore.close();
        Awaitility.await().untilAsserted(() -> {
            int transactionMetaStoreCount2 = Arrays.stream(this.pulsarServices).mapToInt(pulsarService -> pulsarService.getTransactionMetadataStoreService().getStores().size()).sum();
            Assert.assertEquals((int)transactionMetaStoreCount2, (int)16);
        });
        this.transactionCoordinatorClient.close();
    }
}

