/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.coordinator;

import java.util.Optional;
import org.apache.pulsar.PulsarTransactionCoordinatorMetadataSetup;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.transaction.TransactionCoordinatorClient;
import org.apache.pulsar.client.impl.transaction.TransactionCoordinatorClientImpl;
import org.apache.pulsar.tests.TestRetrySupport;
import org.apache.pulsar.zookeeper.LocalBookkeeperEnsemble;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public abstract class TransactionMetaStoreTestBase
extends TestRetrySupport {
    private static final Logger log = LoggerFactory.getLogger(TransactionMetaStoreTestBase.class);
    LocalBookkeeperEnsemble bkEnsemble;
    protected PulsarAdmin[] pulsarAdmins = new PulsarAdmin[BROKER_COUNT];
    protected PulsarClient pulsarClient;
    protected static int BROKER_COUNT = 5;
    protected ServiceConfiguration[] configurations = new ServiceConfiguration[BROKER_COUNT];
    protected PulsarService[] pulsarServices = new PulsarService[BROKER_COUNT];
    protected TransactionCoordinatorClient transactionCoordinatorClient;

    @BeforeClass(alwaysRun=true)
    protected final void setup() throws Exception {
        log.info("---- Initializing {} -----", (Object)((Object)((Object)this)).getClass().getSimpleName());
        this.bkEnsemble = new LocalBookkeeperEnsemble(3, 0, () -> 0);
        this.bkEnsemble.start();
        String[] args = new String[]{"--cluster", "my-cluster", "--configuration-store", "localhost:" + this.bkEnsemble.getZookeeperPort(), "--initial-num-transaction-coordinators", "16"};
        PulsarTransactionCoordinatorMetadataSetup.main((String[])args);
        for (int i = 0; i < BROKER_COUNT; ++i) {
            ServiceConfiguration config = new ServiceConfiguration();
            config.setBrokerShutdownTimeoutMs(0L);
            config.setBrokerServicePort(Optional.of(0));
            config.setClusterName("my-cluster");
            config.setAdvertisedAddress("localhost");
            config.setWebServicePort(Optional.of(0));
            config.setZookeeperServers("127.0.0.1:" + this.bkEnsemble.getZookeeperPort());
            config.setDefaultNumberOfNamespaceBundles(1);
            config.setLoadBalancerEnabled(false);
            config.setAcknowledgmentAtBatchIndexLevelEnabled(true);
            config.setTransactionCoordinatorEnabled(true);
            this.configurations[i] = config;
            this.pulsarServices[i] = (PulsarService)Mockito.spy((Object)new PulsarService(config));
            this.pulsarServices[i].start();
            this.pulsarAdmins[i] = PulsarAdmin.builder().serviceHttpUrl(this.pulsarServices[i].getWebServiceAddress()).build();
        }
        Thread.sleep(100L);
        this.afterPulsarStart();
        if (this.pulsarClient != null) {
            this.pulsarClient.shutdown();
        }
        this.pulsarClient = PulsarClient.builder().serviceUrl(this.pulsarServices[0].getBrokerServiceUrl()).build();
        this.transactionCoordinatorClient = new TransactionCoordinatorClientImpl(this.pulsarClient);
        this.transactionCoordinatorClient.start();
        Thread.sleep(3000L);
        this.afterSetup();
    }

    protected void afterSetup() throws Exception {
    }

    protected void afterPulsarStart() throws Exception {
    }

    @AfterClass(alwaysRun=true)
    public final void shutdownAll() throws Exception {
        this.cleanup();
    }

    protected void cleanup() throws Exception {
        for (PulsarAdmin pulsarAdmin : this.pulsarAdmins) {
            if (pulsarAdmin == null) continue;
            pulsarAdmin.close();
        }
        if (this.pulsarClient != null) {
            this.pulsarClient.close();
        }
        for (PulsarAdmin pulsarAdmin : this.pulsarServices) {
            if (pulsarAdmin == null) continue;
            pulsarAdmin.close();
        }
        Mockito.reset((Object[])new Object[0]);
    }
}

