/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.pendingack;

import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.mledger.impl.ManagedCursorImpl;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.persistent.PersistentSubscription;
import org.apache.pulsar.broker.transaction.TransactionTestBase;
import org.apache.pulsar.broker.transaction.pendingack.impl.PendingAckHandleImpl;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashMap;
import org.apache.pulsar.transaction.coordinator.TransactionCoordinatorID;
import org.apache.pulsar.transaction.coordinator.TransactionMetadataStoreState;
import org.apache.pulsar.transaction.coordinator.impl.MLTransactionMetadataStore;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class PendingAckInMemoryDeleteTest
extends TransactionTestBase {
    private static final Logger log = LoggerFactory.getLogger(PendingAckInMemoryDeleteTest.class);
    private static final String TENANT = "tnx";
    private static final String NAMESPACE1 = "tnx/ns1";

    @BeforeMethod
    protected void setup() throws Exception {
        this.setBrokerCount(1);
        this.internalSetup();
        String[] brokerServiceUrlArr = this.getPulsarServiceList().get(0).getBrokerServiceUrl().split(":");
        String webServicePort = brokerServiceUrlArr[brokerServiceUrlArr.length - 1];
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl("http://localhost:" + webServicePort).build());
        this.admin.tenants().createTenant(TENANT, (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.tenants().createTenant(NamespaceName.SYSTEM_NAMESPACE.getTenant(), (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace(NAMESPACE1);
        this.admin.namespaces().createNamespace(NamespaceName.SYSTEM_NAMESPACE.toString());
        this.admin.topics().createPartitionedTopic(TopicName.TRANSACTION_COORDINATOR_ASSIGN.toString(), 16);
        if (this.pulsarClient != null) {
            this.pulsarClient.shutdown();
        }
        this.pulsarClient = PulsarClient.builder().serviceUrl(this.getPulsarServiceList().get(0).getBrokerServiceUrl()).statsInterval(0L, TimeUnit.SECONDS).enableTransaction(true).build();
        Map stores = this.getPulsarServiceList().get(0).getTransactionMetadataStoreService().getStores();
        Awaitility.await().until(() -> {
            if (stores.size() == 16) {
                for (TransactionCoordinatorID transactionCoordinatorID : stores.keySet()) {
                    if (((MLTransactionMetadataStore)stores.get(transactionCoordinatorID)).getState() == TransactionMetadataStoreState.State.Ready) continue;
                    return false;
                }
                return true;
            }
            return false;
        });
    }

    @AfterMethod(alwaysRun=true)
    protected void cleanup() {
        super.internalCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void txnAckTestNoBatchAndSharedSubMemoryDeleteTest() throws Exception {
        String normalTopic = "tnx/ns1/normal-topic";
        String subscriptionName = "test";
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{normalTopic}).isAckReceiptEnabled(true).subscriptionName(subscriptionName).enableBatchIndexAcknowledgment(true).subscriptionType(SubscriptionType.Shared).ackTimeout(2L, TimeUnit.SECONDS).acknowledgmentGroupTime(0L, TimeUnit.MICROSECONDS).subscribe();
        try {
            Producer producer = this.pulsarClient.newProducer().topic(normalTopic).enableBatching(false).create();
            try {
                for (int retryCnt = 0; retryCnt < 2; ++retryCnt) {
                    int messageCnt = 1000;
                    for (int i = 0; i < messageCnt; ++i) {
                        producer.newMessage().value((Object)"hello".getBytes()).sendAsync();
                    }
                    Transaction commitTxn = this.getTxn();
                    for (int i = 0; i < messageCnt - 1; ++i) {
                        Message message = consumer.receive(2, TimeUnit.SECONDS);
                        Assert.assertNotNull((Object)message);
                        if (i % 2 == 0) {
                            consumer.acknowledgeAsync(message.getMessageId(), commitTxn).get();
                            log.info("txn receive msgId: {}, count: {}", (Object)message.getMessageId(), (Object)i);
                            continue;
                        }
                        consumer.acknowledge(message.getMessageId());
                        log.info("normal receive msgId: {}, count: {}", (Object)message.getMessageId(), (Object)i);
                    }
                    commitTxn.commit().get();
                    int count = 0;
                    for (int i = 0; i < this.getPulsarServiceList().size(); ++i) {
                        Optional topic;
                        Field field = BrokerService.class.getDeclaredField("topics");
                        field.setAccessible(true);
                        ConcurrentOpenHashMap topics = (ConcurrentOpenHashMap)field.get(this.getPulsarServiceList().get(i).getBrokerService());
                        CompletableFuture completableFuture = (CompletableFuture)topics.get((Object)("persistent://" + normalTopic));
                        if (completableFuture == null || !(topic = (Optional)completableFuture.get()).isPresent()) continue;
                        PersistentSubscription persistentSubscription = (PersistentSubscription)((Topic)topic.get()).getSubscription(subscriptionName);
                        field = PersistentSubscription.class.getDeclaredField("pendingAckHandle");
                        field.setAccessible(true);
                        PendingAckHandleImpl pendingAckHandle = (PendingAckHandleImpl)field.get(persistentSubscription);
                        field = PendingAckHandleImpl.class.getDeclaredField("individualAckOfTransaction");
                        field.setAccessible(true);
                        LinkedMap individualAckOfTransaction = (LinkedMap)field.get(pendingAckHandle);
                        Assert.assertTrue((boolean)individualAckOfTransaction.isEmpty());
                        if (retryCnt == 0) {
                            Assert.assertEquals((long)((org.apache.pulsar.broker.service.Consumer)persistentSubscription.getConsumers().get(0)).getPendingAcks().size(), (long)1L);
                        } else {
                            Assert.assertEquals((long)((org.apache.pulsar.broker.service.Consumer)persistentSubscription.getConsumers().get(0)).getPendingAcks().size(), (long)2L);
                        }
                        ++count;
                    }
                    Assert.assertEquals((int)count, (int)1);
                }
            }
            finally {
                if (Collections.singletonList(producer).get(0) != null) {
                    producer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer).get(0) != null) {
                consumer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void txnAckTestBatchAndSharedSubMemoryDeleteTest() throws Exception {
        String normalTopic = "tnx/ns1/normal-topic";
        String subscriptionName = "test";
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{normalTopic}).subscriptionName(subscriptionName).enableBatchIndexAcknowledgment(true).subscriptionType(SubscriptionType.Shared).subscribe();
        try {
            Producer producer = this.pulsarClient.newProducer().topic(normalTopic).enableBatching(true).batchingMaxMessages(200).create();
            try {
                PendingAckHandleImpl pendingAckHandle = null;
                LinkedMap individualAckOfTransaction = null;
                ManagedCursorImpl managedCursor = null;
                MessageId[] messageIds = new MessageId[2];
                for (int retryCnt = 0; retryCnt < 2; ++retryCnt) {
                    int messageCnt = 1000;
                    for (int i = 0; i < messageCnt; ++i) {
                        producer.newMessage().value((Object)"hello".getBytes()).sendAsync();
                    }
                    Transaction commitTxn = this.getTxn();
                    for (int i = 0; i < messageCnt; ++i) {
                        Message message = consumer.receive(2, TimeUnit.SECONDS);
                        Assert.assertNotNull((Object)message);
                        if (i != 500) {
                            if (i % 2 == 0) {
                                consumer.acknowledgeAsync(message.getMessageId(), commitTxn).get();
                                log.info("txn receive msgId: {}, count: {}", (Object)message.getMessageId(), (Object)i);
                                continue;
                            }
                            consumer.acknowledge(message.getMessageId());
                            log.info("normal receive msgId: {}, count: {}", (Object)message.getMessageId(), (Object)i);
                            continue;
                        }
                        messageIds[retryCnt] = message.getMessageId();
                    }
                    commitTxn.commit().get();
                    int count = 0;
                    for (int i = 0; i < this.getPulsarServiceList().size(); ++i) {
                        Optional topic;
                        Field field = BrokerService.class.getDeclaredField("topics");
                        field.setAccessible(true);
                        ConcurrentOpenHashMap topics = (ConcurrentOpenHashMap)field.get(this.getPulsarServiceList().get(i).getBrokerService());
                        CompletableFuture completableFuture = (CompletableFuture)topics.get((Object)("persistent://" + normalTopic));
                        if (completableFuture == null || !(topic = (Optional)completableFuture.get()).isPresent()) continue;
                        PersistentSubscription testPersistentSubscription = (PersistentSubscription)((Topic)topic.get()).getSubscription(subscriptionName);
                        field = PersistentSubscription.class.getDeclaredField("pendingAckHandle");
                        field.setAccessible(true);
                        pendingAckHandle = (PendingAckHandleImpl)field.get(testPersistentSubscription);
                        field = PendingAckHandleImpl.class.getDeclaredField("individualAckOfTransaction");
                        field.setAccessible(true);
                        individualAckOfTransaction = (LinkedMap)field.get(pendingAckHandle);
                        Assert.assertTrue((boolean)individualAckOfTransaction.isEmpty());
                        managedCursor = (ManagedCursorImpl)testPersistentSubscription.getCursor();
                        field = ManagedCursorImpl.class.getDeclaredField("batchDeletedIndexes");
                        field.setAccessible(true);
                        ConcurrentSkipListMap batchDeletedIndexes = (ConcurrentSkipListMap)field.get(managedCursor);
                        if (retryCnt == 0) {
                            Awaitility.await().until(() -> ((org.apache.pulsar.broker.service.Consumer)testPersistentSubscription.getConsumers().get(0)).getPendingAcks().size() == 1L);
                            Assert.assertEquals((int)batchDeletedIndexes.size(), (int)1);
                            Assert.assertEquals((long)((org.apache.pulsar.broker.service.Consumer)testPersistentSubscription.getConsumers().get(0)).getPendingAcks().size(), (long)1L);
                        } else {
                            Awaitility.await().until(() -> ((org.apache.pulsar.broker.service.Consumer)testPersistentSubscription.getConsumers().get(0)).getPendingAcks().size() == 2L);
                            Transaction commitTwice = this.getTxn();
                            consumer.acknowledge(messageIds[0]);
                            Awaitility.await().until(() -> batchDeletedIndexes.size() == 1);
                            Assert.assertEquals((long)((org.apache.pulsar.broker.service.Consumer)testPersistentSubscription.getConsumers().get(0)).getPendingAcks().size(), (long)1L);
                            consumer.acknowledgeAsync(messageIds[1], commitTwice).get();
                            Assert.assertEquals((int)batchDeletedIndexes.size(), (int)1);
                            Assert.assertEquals((long)((org.apache.pulsar.broker.service.Consumer)testPersistentSubscription.getConsumers().get(0)).getPendingAcks().size(), (long)0L);
                            commitTwice.commit().get();
                            Assert.assertEquals((int)batchDeletedIndexes.size(), (int)0);
                            Assert.assertEquals((long)((org.apache.pulsar.broker.service.Consumer)testPersistentSubscription.getConsumers().get(0)).getPendingAcks().size(), (long)0L);
                        }
                        ++count;
                    }
                    Assert.assertEquals((int)count, (int)1);
                }
            }
            finally {
                if (Collections.singletonList(producer).get(0) != null) {
                    producer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer).get(0) != null) {
                consumer.close();
            }
        }
    }

    private Transaction getTxn() throws Exception {
        return (Transaction)this.pulsarClient.newTransaction().withTransactionTimeout(10L, TimeUnit.SECONDS).build().get();
    }
}

