/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.pendingack;

import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.broker.service.persistent.PersistentSubscription;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.transaction.TransactionTestBase;
import org.apache.pulsar.broker.transaction.pendingack.impl.MLPendingAckStore;
import org.apache.pulsar.broker.transaction.pendingack.impl.PendingAckHandleImpl;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.ClusterDataImpl;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PendingAckPersistentTest
extends TransactionTestBase {
    private static final Logger log = LoggerFactory.getLogger(PendingAckPersistentTest.class);
    private static final String PENDING_ACK_REPLAY_TOPIC = "persistent://public/txn/pending-ack-replay";

    @BeforeMethod
    public void setup() throws Exception {
        this.setBrokerCount(1);
        super.internalSetup();
        String[] brokerServiceUrlArr = this.getPulsarServiceList().get(0).getBrokerServiceUrl().split(":");
        String webServicePort = brokerServiceUrlArr[brokerServiceUrlArr.length - 1];
        this.admin.clusters().createCluster("test", (ClusterData)ClusterDataImpl.builder().serviceUrl("http://localhost:" + webServicePort).build());
        this.admin.tenants().createTenant(NamespaceName.SYSTEM_NAMESPACE.getTenant(), (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace(NamespaceName.SYSTEM_NAMESPACE.toString());
        this.admin.topics().createPartitionedTopic(TopicName.TRANSACTION_COORDINATOR_ASSIGN.toString(), 16);
        this.admin.tenants().createTenant("public", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet(), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace("public/txn", 10);
        this.admin.topics().createNonPartitionedTopic(PENDING_ACK_REPLAY_TOPIC);
        this.pulsarClient = PulsarClient.builder().serviceUrl(this.getPulsarServiceList().get(0).getBrokerServiceUrl()).statsInterval(0L, TimeUnit.SECONDS).enableTransaction(true).build();
        Thread.sleep(3000L);
    }

    @AfterMethod(alwaysRun=true)
    protected void cleanup() {
        super.internalCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void individualPendingAckReplayTest() throws Exception {
        int messageCount = 1000;
        String subName = "individual-test";
        Producer producer = this.pulsarClient.newProducer().topic(PENDING_ACK_REPLAY_TOPIC).enableBatching(true).batchingMaxMessages(200).create();
        try {
            Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{PENDING_ACK_REPLAY_TOPIC}).subscriptionName(subName).subscriptionType(SubscriptionType.Shared).enableBatchIndexAcknowledgment(true).subscribe();
            try {
                int i;
                Transaction abortTxn = (Transaction)this.pulsarClient.newTransaction().withTransactionTimeout(30L, TimeUnit.SECONDS).build().get();
                ArrayList<MessageId> pendingAckMessageIds = new ArrayList<MessageId>();
                ArrayList<MessageId> normalAckMessageIds = new ArrayList<MessageId>();
                for (int i2 = 0; i2 < messageCount; ++i2) {
                    producer.send((Object)"Hello Pulsar!".getBytes());
                    Message message = consumer.receive();
                    if (i2 % 2 == 0) {
                        consumer.acknowledgeAsync(message.getMessageId(), abortTxn).get();
                        pendingAckMessageIds.add(message.getMessageId());
                        continue;
                    }
                    normalAckMessageIds.add(message.getMessageId());
                }
                this.admin.topics().unload(PENDING_ACK_REPLAY_TOPIC);
                Awaitility.await().until(() -> ((Consumer)consumer).isConnected());
                Transaction commitTxn = (Transaction)this.pulsarClient.newTransaction().withTransactionTimeout(30L, TimeUnit.SECONDS).build().get();
                Transaction txn = (Transaction)this.pulsarClient.newTransaction().withTransactionTimeout(30L, TimeUnit.SECONDS).build().get();
                for (i = 0; i < pendingAckMessageIds.size(); ++i) {
                    try {
                        consumer.acknowledgeAsync((MessageId)pendingAckMessageIds.get(i), txn).get();
                        Assert.fail();
                        continue;
                    }
                    catch (ExecutionException e) {
                        Assert.assertTrue((boolean)(e.getCause() instanceof PulsarClientException.TransactionConflictException));
                    }
                }
                for (i = 0; i < normalAckMessageIds.size(); ++i) {
                    consumer.acknowledgeAsync((MessageId)normalAckMessageIds.get(i), commitTxn).get();
                }
                txn.abort().get();
                commitTxn.commit().get();
                abortTxn.abort().get();
                this.admin.topics().unload(PENDING_ACK_REPLAY_TOPIC);
                Awaitility.await().until(() -> ((Consumer)consumer).isConnected());
                abortTxn = (Transaction)this.pulsarClient.newTransaction().withTransactionTimeout(30L, TimeUnit.SECONDS).build().get();
                commitTxn = (Transaction)this.pulsarClient.newTransaction().withTransactionTimeout(30L, TimeUnit.SECONDS).build().get();
                for (i = 0; i < normalAckMessageIds.size(); ++i) {
                    try {
                        consumer.acknowledgeAsync((MessageId)normalAckMessageIds.get(i), abortTxn).get();
                        Assert.fail();
                        continue;
                    }
                    catch (ExecutionException e) {
                        Assert.assertTrue((boolean)(e.getCause() instanceof PulsarClientException.TransactionConflictException));
                    }
                }
                for (i = 0; i < pendingAckMessageIds.size(); ++i) {
                    consumer.acknowledgeAsync((MessageId)pendingAckMessageIds.get(i), commitTxn).get();
                }
                abortTxn.abort().get();
                commitTxn.commit().get();
                PersistentTopic topic = (PersistentTopic)((Optional)this.getPulsarServiceList().get(0).getBrokerService().getTopic(TopicName.get((String)PENDING_ACK_REPLAY_TOPIC).toString(), false).get()).get();
                Field field = PersistentSubscription.class.getDeclaredField("pendingAckHandle");
                field.setAccessible(true);
                PendingAckHandleImpl pendingAckHandle = (PendingAckHandleImpl)field.get(topic.getSubscription(subName));
                field = PendingAckHandleImpl.class.getDeclaredField("pendingAckStoreFuture");
                field.setAccessible(true);
                CompletableFuture pendingAckStoreCompletableFuture = (CompletableFuture)field.get(pendingAckHandle);
                pendingAckStoreCompletableFuture.get();
                field = MLPendingAckStore.class.getDeclaredField("cursor");
                field.setAccessible(true);
                ManagedCursor managedCursor = (ManagedCursor)field.get(pendingAckStoreCompletableFuture.get());
                Awaitility.await().until(() -> ((PositionImpl)managedCursor.getMarkDeletedPosition()).compareTo((PositionImpl)managedCursor.getManagedLedger().getLastConfirmedEntry()) == -1);
            }
            finally {
                if (Collections.singletonList(consumer).get(0) != null) {
                    consumer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(producer).get(0) != null) {
                producer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cumulativePendingAckReplayTest() throws Exception {
        int messageCount = 1000;
        String subName = "cumulative-test";
        Producer producer = this.pulsarClient.newProducer().topic(PENDING_ACK_REPLAY_TOPIC).enableBatching(true).batchingMaxMessages(200).create();
        try {
            Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{PENDING_ACK_REPLAY_TOPIC}).subscriptionName(subName).subscriptionType(SubscriptionType.Failover).enableBatchIndexAcknowledgment(true).subscribe();
            try {
                int i;
                int i2;
                Transaction abortTxn = (Transaction)this.pulsarClient.newTransaction().withTransactionTimeout(30L, TimeUnit.SECONDS).build().get();
                ArrayList<MessageId> pendingAckMessageIds = new ArrayList<MessageId>();
                for (i2 = 0; i2 < messageCount; ++i2) {
                    producer.send((Object)"Hello Pulsar!".getBytes());
                }
                for (i2 = 0; i2 < messageCount; ++i2) {
                    Message message = consumer.receive();
                    pendingAckMessageIds.add(message.getMessageId());
                    consumer.acknowledgeCumulativeAsync(message.getMessageId(), abortTxn).get();
                }
                this.admin.topics().unload(PENDING_ACK_REPLAY_TOPIC);
                Transaction txn = (Transaction)this.pulsarClient.newTransaction().withTransactionTimeout(30L, TimeUnit.SECONDS).build().get();
                Awaitility.await().until(() -> ((Consumer)consumer).isConnected());
                for (int i3 = 0; i3 < pendingAckMessageIds.size(); ++i3) {
                    try {
                        consumer.acknowledgeCumulativeAsync((MessageId)pendingAckMessageIds.get(i3), txn).get();
                        Assert.fail();
                        continue;
                    }
                    catch (ExecutionException e) {
                        Assert.assertTrue((boolean)(e.getCause() instanceof PulsarClientException.TransactionConflictException));
                    }
                }
                Transaction commitTxn = (Transaction)this.pulsarClient.newTransaction().withTransactionTimeout(30L, TimeUnit.SECONDS).build().get();
                abortTxn.abort().get();
                for (i = 0; i < pendingAckMessageIds.size(); ++i) {
                    consumer.acknowledgeCumulativeAsync((MessageId)pendingAckMessageIds.get(i), commitTxn).get();
                }
                commitTxn.commit().get();
                this.admin.topics().unload(PENDING_ACK_REPLAY_TOPIC);
                Awaitility.await().until(() -> ((Consumer)consumer).isConnected());
                for (i = 0; i < pendingAckMessageIds.size(); ++i) {
                    try {
                        consumer.acknowledgeCumulativeAsync((MessageId)pendingAckMessageIds.get(i), txn).get();
                        Assert.fail();
                        continue;
                    }
                    catch (ExecutionException e) {
                        Assert.assertTrue((boolean)(e.getCause() instanceof PulsarClientException.TransactionConflictException));
                    }
                }
                PersistentTopic topic = (PersistentTopic)((Optional)this.getPulsarServiceList().get(0).getBrokerService().getTopic(TopicName.get((String)PENDING_ACK_REPLAY_TOPIC).toString(), false).get()).get();
                Field field = PersistentSubscription.class.getDeclaredField("pendingAckHandle");
                field.setAccessible(true);
                PendingAckHandleImpl pendingAckHandle = (PendingAckHandleImpl)field.get(topic.getSubscription(subName));
                field = PendingAckHandleImpl.class.getDeclaredField("pendingAckStoreFuture");
                field.setAccessible(true);
                CompletableFuture pendingAckStoreCompletableFuture = (CompletableFuture)field.get(pendingAckHandle);
                pendingAckStoreCompletableFuture.get();
                field = MLPendingAckStore.class.getDeclaredField("cursor");
                field.setAccessible(true);
                ManagedCursor managedCursor = (ManagedCursor)field.get(pendingAckStoreCompletableFuture.get());
                Awaitility.await().until(() -> ((PositionImpl)managedCursor.getMarkDeletedPosition()).compareTo((PositionImpl)managedCursor.getManagedLedger().getLastConfirmedEntry()) == -1);
            }
            finally {
                if (Collections.singletonList(consumer).get(0) != null) {
                    consumer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(producer).get(0) != null) {
                producer.close();
            }
        }
    }
}

