/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.zookeeper;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.pulsar.PulsarClusterMetadataSetup;
import org.apache.pulsar.PulsarInitialNamespaceSetup;
import org.apache.pulsar.broker.resources.TenantResources;
import org.apache.pulsar.broker.web.PulsarWebResource;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.zookeeper.LocalBookkeeperEnsemble;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class ClusterMetadataSetupTest {
    private static final Logger log = LoggerFactory.getLogger(ClusterMetadataSetupTest.class);
    private ZookeeperServerTest localZkS;

    @Test
    public void testReSetupClusterMetadata() throws Exception {
        String[] args = new String[]{"--cluster", "testReSetupClusterMetadata-cluster", "--zookeeper", "127.0.0.1:" + this.localZkS.getZookeeperPort(), "--configuration-store", "127.0.0.1:" + this.localZkS.getZookeeperPort(), "--web-service-url", "http://127.0.0.1:8080", "--web-service-url-tls", "https://127.0.0.1:8443", "--broker-service-url", "pulsar://127.0.0.1:6650", "--broker-service-url-tls", "pulsar+ssl://127.0.0.1:6651"};
        PulsarClusterMetadataSetup.main((String[])args);
        SortedMap<String, String> data1 = this.localZkS.dumpData();
        PulsarClusterMetadataSetup.main((String[])args);
        SortedMap<String, String> data2 = this.localZkS.dumpData();
        Assert.assertEquals(data1, data2);
        PulsarClusterMetadataSetup.main((String[])args);
        SortedMap<String, String> data3 = this.localZkS.dumpData();
        Assert.assertEquals(data1, data3);
    }

    @Test
    public void testSetupClusterInChrootMode() throws Exception {
        HashSet<String> firstLevelNodes = new HashSet<String>(Arrays.asList("admin", "bookies", "ledgers", "managed-ledgers", "namespace", "pulsar", "stream"));
        String rootPath = "/test-prefix";
        String[] args = new String[]{"--cluster", "testReSetupClusterMetadata-cluster", "--zookeeper", "127.0.0.1:" + this.localZkS.getZookeeperPort() + rootPath, "--configuration-store", "127.0.0.1:" + this.localZkS.getZookeeperPort() + rootPath, "--web-service-url", "http://127.0.0.1:8080", "--web-service-url-tls", "https://127.0.0.1:8443", "--broker-service-url", "pulsar://127.0.0.1:6650", "--broker-service-url-tls", "pulsar+ssl://127.0.0.1:6651"};
        PulsarClusterMetadataSetup.main((String[])args);
        try (ZooKeeperClient zk = ZooKeeperClient.newBuilder().connectString("127.0.0.1:" + this.localZkS.getZookeeperPort()).build();){
            Assert.assertNotNull((Object)zk.exists(rootPath, false));
            Assert.assertEquals(new HashSet(zk.getChildren(rootPath, false)), firstLevelNodes);
        }
    }

    @Test
    public void testSetupWithBkMetadataServiceUri() throws Exception {
        String zkConnection = "127.0.0.1:" + this.localZkS.getZookeeperPort();
        String[] args = new String[]{"--cluster", "testReSetupClusterMetadata-cluster", "--zookeeper", zkConnection, "--configuration-store", zkConnection, "--existing-bk-metadata-service-uri", "zk+null://" + zkConnection + "/chroot/ledgers", "--web-service-url", "http://127.0.0.1:8080", "--web-service-url-tls", "https://127.0.0.1:8443", "--broker-service-url", "pulsar://127.0.0.1:6650", "--broker-service-url-tls", "pulsar+ssl://127.0.0.1:6651"};
        PulsarClusterMetadataSetup.main((String[])args);
        try (MetadataStoreExtended localStore = PulsarClusterMetadataSetup.initMetadataStore((String)zkConnection, (int)30000);){
            Assert.assertFalse((boolean)((Boolean)localStore.exists("/ledgers").get()));
            String[] bookkeeperMetadataServiceUriArgs = new String[]{"--cluster", "testReSetupClusterMetadata-cluster", "--zookeeper", zkConnection, "--configuration-store", zkConnection, "--bookkeeper-metadata-service-uri", "zk+null://" + zkConnection + "/chroot/ledgers", "--web-service-url", "http://127.0.0.1:8080", "--web-service-url-tls", "https://127.0.0.1:8443", "--broker-service-url", "pulsar://127.0.0.1:6650", "--broker-service-url-tls", "pulsar+ssl://127.0.0.1:6651"};
            PulsarClusterMetadataSetup.main((String[])bookkeeperMetadataServiceUriArgs);
            try (MetadataStoreExtended bookkeeperMetadataServiceUriStore = PulsarClusterMetadataSetup.initMetadataStore((String)zkConnection, (int)30000);){
                Assert.assertFalse((boolean)((Boolean)bookkeeperMetadataServiceUriStore.exists("/ledgers").get()));
            }
            String[] args1 = new String[]{"--cluster", "testReSetupClusterMetadata-cluster", "--zookeeper", zkConnection, "--configuration-store", zkConnection, "--web-service-url", "http://127.0.0.1:8080", "--web-service-url-tls", "https://127.0.0.1:8443", "--broker-service-url", "pulsar://127.0.0.1:6650", "--broker-service-url-tls", "pulsar+ssl://127.0.0.1:6651"};
            PulsarClusterMetadataSetup.main((String[])args1);
            Assert.assertTrue((boolean)((Boolean)localStore.exists("/ledgers").get()));
        }
    }

    @Test
    public void testInitialNamespaceSetup() throws Exception {
        Assert.assertEquals((int)PulsarInitialNamespaceSetup.doMain((String[])new String[0]), (int)1);
        Assert.assertEquals((int)PulsarInitialNamespaceSetup.doMain((String[])new String[]{"--cluster", "testInitialNamespaceSetup-cluster", "--configuration-store", "127.0.0.1:" + this.localZkS.getZookeeperPort(), "a/b/c/d"}), (int)1);
        String[] args = new String[]{"--cluster", "testInitialNamespaceSetup-cluster", "--configuration-store", "127.0.0.1:" + this.localZkS.getZookeeperPort(), "test/a", "test/b", "test/c"};
        Assert.assertEquals((int)PulsarInitialNamespaceSetup.doMain((String[])args), (int)0);
        try (MetadataStoreExtended store = MetadataStoreExtended.create((String)("127.0.0.1:" + this.localZkS.getZookeeperPort()), (MetadataStoreConfig)MetadataStoreConfig.builder().build());){
            TenantResources tenantResources = new TenantResources((MetadataStore)store, 30);
            List namespaces = tenantResources.getChildren(PulsarWebResource.path((String[])new String[]{"policies", "test"}));
            Assert.assertEquals(new HashSet(namespaces), new HashSet<String>(Arrays.asList("a", "b", "c")));
        }
    }

    @BeforeMethod
    void setup() throws Exception {
        this.localZkS = new ZookeeperServerTest(0);
        this.localZkS.start();
    }

    @AfterMethod(alwaysRun=true)
    void teardown() throws Exception {
        this.localZkS.close();
    }

    static class ZookeeperServerTest
    implements Closeable {
        private final File zkTmpDir;
        private ZooKeeperServer zks;
        private NIOServerCnxnFactory serverFactory;
        private final int zkPort;
        private final String hostPort;

        public ZookeeperServerTest(int zkPort) throws IOException {
            this.zkPort = zkPort;
            this.hostPort = "127.0.0.1:" + zkPort;
            this.zkTmpDir = File.createTempFile("zookeeper", "test");
            log.info("**** Start GZK on {} ****", (Object)this.zkTmpDir);
            if (!this.zkTmpDir.delete() || !this.zkTmpDir.mkdir()) {
                throw new IOException("Couldn't create zk directory " + this.zkTmpDir);
            }
        }

        public void start() throws IOException {
            try {
                this.zks = new ZooKeeperServer(this.zkTmpDir, this.zkTmpDir, 3000);
                this.zks.setMaxSessionTimeout(20000);
                this.serverFactory = new NIOServerCnxnFactory();
                this.serverFactory.configure(new InetSocketAddress(this.zkPort), 1000);
                this.serverFactory.startup(this.zks);
            }
            catch (Exception e) {
                log.error("Exception while instantiating ZooKeeper", (Throwable)e);
            }
            LocalBookkeeperEnsemble.waitForServerUp((String)this.hostPort, (long)30000L);
            log.info("ZooKeeper started at {}", (Object)this.hostPort);
        }

        public void stop() throws IOException {
            this.zks.shutdown();
            this.serverFactory.shutdown();
            log.info("Stoppend ZK server at {}", (Object)this.hostPort);
        }

        @Override
        public void close() throws IOException {
            this.zks.shutdown();
            this.serverFactory.shutdown();
            this.zkTmpDir.delete();
        }

        public int getZookeeperPort() {
            return this.serverFactory.getLocalPort();
        }

        public SortedMap<String, String> dumpData() throws IOException, InterruptedException, KeeperException {
            TreeMap<String, String> data = new TreeMap<String, String>();
            try (ZooKeeperClient zk = ZooKeeperClient.newBuilder().connectString("127.0.0.1:" + this.getZookeeperPort()).sessionTimeoutMs(20000).build();){
                for (String child : zk.getChildren("/", false)) {
                    if ("zookeeper".equals(child)) continue;
                    this.dumpPath((ZooKeeper)zk, "/" + child, data);
                }
            }
            return data;
        }

        private void dumpPath(ZooKeeper zk, String path, SortedMap<String, String> dataMap) throws InterruptedException, KeeperException {
            dataMap.put(path, new String(zk.getData(path, false, null), Charset.defaultCharset()));
            for (String child : zk.getChildren(path, false)) {
                this.dumpPath(zk, path + "/" + child, dataMap);
            }
        }
    }
}

