/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.authentication.AuthenticationProviderTls;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.impl.auth.AuthenticationKeyStoreTls;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker-impl"})
public class KeyStoreTlsProducerConsumerTestWithAuthTest
extends ProducerConsumerBase {
    private static final Logger log = LoggerFactory.getLogger(KeyStoreTlsProducerConsumerTestWithAuthTest.class);
    protected final String BROKER_KEYSTORE_FILE_PATH = "./src/test/resources/authentication/keystoretls/broker.keystore.jks";
    protected final String BROKER_TRUSTSTORE_FILE_PATH = "./src/test/resources/authentication/keystoretls/broker.truststore.jks";
    protected final String BROKER_KEYSTORE_PW = "111111";
    protected final String BROKER_TRUSTSTORE_PW = "111111";
    protected final String CLIENT_KEYSTORE_FILE_PATH = "./src/test/resources/authentication/keystoretls/client.keystore.jks";
    protected final String CLIENT_TRUSTSTORE_FILE_PATH = "./src/test/resources/authentication/keystoretls/client.truststore.jks";
    protected final String CLIENT_KEYSTORE_PW = "111111";
    protected final String CLIENT_TRUSTSTORE_PW = "111111";
    protected final String CLIENT_KEYSTORE_CN = "clientuser";
    protected final String KEYSTORE_TYPE = "JKS";
    private final String clusterName = "use";

    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        this.internalSetUpForBroker();
        super.init();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    protected void internalSetUpForBroker() {
        this.conf.setBrokerServicePortTls(Optional.of(0));
        this.conf.setWebServicePortTls(Optional.of(0));
        this.conf.setTlsEnabledWithKeyStore(true);
        this.conf.setTlsKeyStoreType("JKS");
        this.conf.setTlsKeyStore("./src/test/resources/authentication/keystoretls/broker.keystore.jks");
        this.conf.setTlsKeyStorePassword("111111");
        this.conf.setTlsTrustStoreType("JKS");
        this.conf.setTlsTrustStore("./src/test/resources/authentication/keystoretls/client.truststore.jks");
        this.conf.setTlsTrustStorePassword("111111");
        this.conf.setClusterName("use");
        this.conf.setTlsRequireTrustedClientCertOnConnect(true);
        this.conf.setSuperUserRoles((Set)Sets.newHashSet((Object[])new String[]{"clientuser"}));
        this.conf.setAuthenticationEnabled(true);
        this.conf.setAuthorizationEnabled(true);
        HashSet<String> providers = new HashSet<String>();
        providers.add(AuthenticationProviderTls.class.getName());
        this.conf.setAuthenticationProviders(providers);
        this.conf.setNumExecutorThreadPoolSize(5);
    }

    protected void internalSetUpForClient(boolean addCertificates, String lookupUrl) throws Exception {
        if (this.pulsarClient != null) {
            this.pulsarClient.close();
        }
        Set tlsProtocols = Sets.newConcurrentHashSet();
        tlsProtocols.add("TLSv1.3");
        tlsProtocols.add("TLSv1.2");
        ClientBuilder clientBuilder = PulsarClient.builder().serviceUrl(lookupUrl).enableTls(true).useKeyStoreTls(true).tlsTrustStorePath("./src/test/resources/authentication/keystoretls/broker.truststore.jks").tlsTrustStorePassword("111111").allowTlsInsecureConnection(false).tlsProtocols(tlsProtocols).operationTimeout(1000, TimeUnit.MILLISECONDS);
        if (addCertificates) {
            HashMap<String, String> authParams = new HashMap<String, String>();
            authParams.put("keyStoreType", "JKS");
            authParams.put("keyStorePath", "./src/test/resources/authentication/keystoretls/client.keystore.jks");
            authParams.put("keyStorePassword", "111111");
            clientBuilder.authentication(AuthenticationKeyStoreTls.class.getName(), authParams);
        }
        this.replacePulsarClient(clientBuilder);
    }

    protected void internalSetUpForNamespace() throws Exception {
        HashMap<String, String> authParams = new HashMap<String, String>();
        authParams.put("keyStorePath", "./src/test/resources/authentication/keystoretls/client.keystore.jks");
        authParams.put("keyStorePassword", "111111");
        if (this.admin != null) {
            this.admin.close();
        }
        this.admin = (PulsarAdmin)Mockito.spy((Object)PulsarAdmin.builder().serviceHttpUrl(this.brokerUrlTls.toString()).useKeyStoreTls(true).tlsTrustStorePath("./src/test/resources/authentication/keystoretls/broker.truststore.jks").tlsTrustStorePassword("111111").allowTlsInsecureConnection(false).authentication(AuthenticationKeyStoreTls.class.getName(), authParams).build());
        this.admin.clusters().createCluster("use", ClusterData.builder().serviceUrl(this.brokerUrl.toString()).serviceUrlTls(this.brokerUrlTls.toString()).brokerServiceUrl(this.pulsar.getBrokerServiceUrl()).brokerServiceUrlTls(this.pulsar.getBrokerServiceUrlTls()).build());
        this.admin.tenants().createTenant("my-property", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1", "appid2"}), (Set)Sets.newHashSet((Object[])new String[]{"use"})));
        this.admin.namespaces().createNamespace("my-property/my-ns");
    }

    @Test(timeOut=30000L)
    public void testTlsLargeSizeMessage() throws Exception {
        log.info("-- Starting {} test --", (Object)this.methodName);
        int MESSAGE_SIZE = 16385;
        log.info("-- message size -- {}", (Object)16385);
        String topicName = "persistent://my-property/use/my-ns/testTlsLargeSizeMessage" + System.currentTimeMillis();
        this.internalSetUpForClient(true, this.pulsar.getBrokerServiceUrlTls());
        this.internalSetUpForNamespace();
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName("my-subscriber-name").subscribe();
        Producer producer = this.pulsarClient.newProducer().topic(topicName).create();
        for (int i = 0; i < 10; ++i) {
            byte[] message = new byte[16385];
            Arrays.fill(message, (byte)i);
            producer.send((Object)message);
        }
        Message msg = null;
        for (int i = 0; i < 10; ++i) {
            msg = consumer.receive(5, TimeUnit.SECONDS);
            byte[] expected = new byte[16385];
            Arrays.fill(expected, (byte)i);
            Assert.assertEquals((byte[])expected, (byte[])msg.getData());
        }
        consumer.acknowledgeCumulative(msg);
        consumer.close();
        log.info("-- Exiting {} test --", (Object)this.methodName);
    }

    @Test
    public void testTlsClientAuthOverBinaryProtocol() throws Exception {
        log.info("-- Starting {} test --", (Object)this.methodName);
        int MESSAGE_SIZE = 16385;
        log.info("-- message size -- {}", (Object)16385);
        String topicName = "persistent://my-property/use/my-ns/testTlsClientAuthOverBinaryProtocol" + System.currentTimeMillis();
        this.internalSetUpForNamespace();
        this.internalSetUpForClient(false, this.pulsar.getBrokerServiceUrlTls());
        try {
            this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName("my-subscriber-name").subscriptionType(SubscriptionType.Exclusive).subscribe();
            Assert.fail((String)"Server should have failed the TLS handshake since client didn't .");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.internalSetUpForClient(true, this.pulsar.getBrokerServiceUrlTls());
        this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName("my-subscriber-name").subscriptionType(SubscriptionType.Exclusive).subscribe();
    }

    @Test
    public void testTlsClientAuthOverHTTPProtocol() throws Exception {
        log.info("-- Starting {} test --", (Object)this.methodName);
        int MESSAGE_SIZE = 16385;
        log.info("-- message size -- {}", (Object)16385);
        String topicName = "persistent://my-property/use/my-ns/testTlsClientAuthOverHTTPProtocol" + System.currentTimeMillis();
        this.internalSetUpForNamespace();
        this.internalSetUpForClient(false, this.pulsar.getWebServiceAddressTls());
        try {
            this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName("my-subscriber-name").subscriptionType(SubscriptionType.Exclusive).subscribe();
            Assert.fail((String)"Server should have failed the TLS handshake since client didn't .");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.internalSetUpForClient(true, this.pulsar.getWebServiceAddressTls());
        this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName("my-subscriber-name").subscriptionType(SubscriptionType.Exclusive).subscribe();
    }
}

