/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.ServerSocket;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker-impl"})
public class PulsarMultiHostClientTest
extends ProducerConsumerBase {
    private static final Logger log = LoggerFactory.getLogger(PulsarMultiHostClientTest.class);

    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        super.internalSetup();
        super.producerBaseSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetPartitionedTopicMetaData() {
        log.info("-- Starting {} test --", (Object)this.methodName);
        String topicName = "persistent://my-property/my-ns/my-topic1";
        String subscriptionName = "my-subscriber-name";
        try {
            String url = this.pulsar.getWebServiceAddress();
            if (this.isTcpLookup) {
                url = this.pulsar.getBrokerServiceUrl();
            }
            PulsarClient client = this.newPulsarClient(url, 0);
            try {
                Consumer consumer = client.newConsumer().topic(new String[]{"persistent://my-property/my-ns/my-topic1"}).subscriptionName("my-subscriber-name").acknowledgmentGroupTime(0L, TimeUnit.SECONDS).subscribe();
                Producer producer = client.newProducer().topic("persistent://my-property/my-ns/my-topic1").create();
                consumer.close();
                producer.close();
            }
            finally {
                if (Collections.singletonList(client).get(0) != null) {
                    client.close();
                }
            }
        }
        catch (PulsarClientException pce) {
            log.error("create producer or consumer error: ", (Throwable)pce);
            Assert.fail();
        }
        log.info("-- Exiting {} test --", (Object)this.methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=15000L)
    public void testGetPartitionedTopicDataTimeout() {
        log.info("-- Starting {} test --", (Object)this.methodName);
        String topicName = "persistent://my-property/my-ns/my-topic1";
        String url = "http://localhost:" + PulsarMultiHostClientTest.getFreePort() + ",localhost:" + PulsarMultiHostClientTest.getFreePort();
        try {
            PulsarClient client = PulsarClient.builder().serviceUrl(url).statsInterval(0L, TimeUnit.SECONDS).operationTimeout(3, TimeUnit.SECONDS).build();
            try {
                Producer producer = client.newProducer().topic("persistent://my-property/my-ns/my-topic1").create();
                Assert.fail();
            }
            finally {
                if (Collections.singletonList(client).get(0) != null) {
                    client.close();
                }
            }
        }
        catch (PulsarClientException pce) {
            log.error("create producer error: ", (Throwable)pce);
        }
        log.info("-- Exiting {} test --", (Object)this.methodName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getFreePort() {
        try (ServerSocket serverSocket = new ServerSocket(0);){
            int n = serverSocket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiHostUrlRetrySuccess() throws Exception {
        log.info("-- Starting {} test --", (Object)this.methodName);
        String topicName = "persistent://my-property/my-ns/my-topic1";
        String subscriptionName = "my-subscriber-name";
        String urlsWithUnreached = "http://localhost:51000,localhost:" + new URI(this.pulsar.getWebServiceAddress()).getPort();
        if (this.isTcpLookup) {
            urlsWithUnreached = "pulsar://localhost:51000,localhost" + new URI(this.pulsar.getBrokerServiceUrl()).getPort();
        }
        PulsarClient client = this.newPulsarClient(urlsWithUnreached, 0);
        try {
            Consumer consumer = client.newConsumer().topic(new String[]{"persistent://my-property/my-ns/my-topic1"}).subscriptionName("my-subscriber-name").acknowledgmentGroupTime(0L, TimeUnit.SECONDS).subscribe();
            Producer producer = client.newProducer().topic("persistent://my-property/my-ns/my-topic1").create();
            for (int i = 0; i < 5; ++i) {
                String message = "my-message-" + i;
                producer.send((Object)message.getBytes());
                log.info("Produced message: [{}]", (Object)message);
            }
            Message msg = null;
            HashSet messageSet = new HashSet();
            for (int i = 0; i < 5; ++i) {
                msg = consumer.receive(5, TimeUnit.SECONDS);
                String receivedMessage = new String(msg.getData());
                log.info("Received message: [{}]", (Object)receivedMessage);
                String expectedMessage = "my-message-" + i;
                this.testMessageOrderAndDuplicates(messageSet, receivedMessage, expectedMessage);
            }
            consumer.acknowledgeCumulative(msg);
            consumer.close();
            producer.close();
            log.info("-- Exiting {} test --", (Object)this.methodName);
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }
}

