/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.testng.Assert;

public class PulsarFunctionTestTemporaryDirectory {
    private final File tempDirectory;
    private final File narExtractionDirectory;
    private final File downloadDirectory;
    private final File connectorsDirectory;

    private PulsarFunctionTestTemporaryDirectory(String tempDirectoryNamePrefix) throws IOException {
        this.tempDirectory = Files.createTempDirectory(tempDirectoryNamePrefix, new FileAttribute[0]).toFile();
        this.narExtractionDirectory = new File(this.tempDirectory, "narExtractionDirectory");
        this.narExtractionDirectory.mkdir();
        this.downloadDirectory = new File(this.tempDirectory, "downloadDirectory");
        this.downloadDirectory.mkdir();
        this.connectorsDirectory = new File(this.tempDirectory, "connectorsDirectory");
        this.connectorsDirectory.mkdir();
    }

    public static PulsarFunctionTestTemporaryDirectory create(String tempDirectoryNamePrefix) {
        try {
            return new PulsarFunctionTestTemporaryDirectory(tempDirectoryNamePrefix);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot create temporary directory", e);
        }
    }

    public void useTemporaryDirectoriesForWorkerConfig(WorkerConfig workerConfig) {
        workerConfig.setNarExtractionDirectory(this.narExtractionDirectory.getAbsolutePath());
        workerConfig.setDownloadDirectory(this.downloadDirectory.getAbsolutePath());
        workerConfig.setConnectorsDirectory(this.connectorsDirectory.getAbsolutePath());
    }

    public void delete() {
        try {
            FileUtils.deleteDirectory((File)this.tempDirectory);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot delete temporary directory", e);
        }
    }

    public void assertThatFunctionDownloadTempFilesHaveBeenDeleted() {
        File[] foundFiles = this.downloadDirectory.listFiles((dir1, name) -> name.startsWith("function"));
        Assert.assertEquals((int)foundFiles.length, (int)0, (String)("Temporary files left over: " + Arrays.asList(foundFiles)));
    }
}

