/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.socks5.handler;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.socksx.v5.DefaultSocks5CommandRequest;
import io.netty.handler.codec.socksx.v5.DefaultSocks5CommandResponse;
import io.netty.handler.codec.socksx.v5.Socks5AddressType;
import io.netty.handler.codec.socksx.v5.Socks5CommandStatus;
import io.netty.handler.codec.socksx.v5.Socks5CommandType;
import io.netty.util.concurrent.GenericFutureListener;
import org.apache.pulsar.socks5.Socks5Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandRequestHandler
extends SimpleChannelInboundHandler<DefaultSocks5CommandRequest> {
    private static final Logger log = LoggerFactory.getLogger(CommandRequestHandler.class);
    private final Socks5Server socks5Server;

    public CommandRequestHandler(Socks5Server socks5Server) {
        this.socks5Server = socks5Server;
    }

    protected void channelRead0(final ChannelHandlerContext clientChannelContext, final DefaultSocks5CommandRequest msg) throws Exception {
        if (Socks5CommandType.CONNECT.equals((Object)msg.type())) {
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.socks5Server.getBoss())).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new ClientHandler(clientChannelContext)});
                }
            });
            ChannelFuture future = bootstrap.connect(msg.dstAddr(), msg.dstPort());
            future.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        if (log.isDebugEnabled()) {
                            log.debug("connected : {} {}", (Object)msg.dstAddr(), (Object)msg.dstPort());
                        }
                        clientChannelContext.pipeline().addLast(new ChannelHandler[]{new TargetHandler(future)});
                        clientChannelContext.writeAndFlush((Object)new DefaultSocks5CommandResponse(Socks5CommandStatus.SUCCESS, Socks5AddressType.IPv4));
                    } else {
                        clientChannelContext.writeAndFlush((Object)new DefaultSocks5CommandResponse(Socks5CommandStatus.FAILURE, Socks5AddressType.IPv4));
                    }
                }
            });
        } else {
            clientChannelContext.fireChannelRead((Object)msg);
        }
    }

    private static class TargetHandler
    extends ChannelInboundHandlerAdapter {
        private ChannelFuture targetChannel;

        public TargetHandler(ChannelFuture targetChannel) {
            this.targetChannel = targetChannel;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            this.targetChannel.channel().writeAndFlush(msg);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.targetChannel.channel().close();
        }
    }

    private static class ClientHandler
    extends ChannelInboundHandlerAdapter {
        private ChannelHandlerContext clientChannelContext;

        public ClientHandler(ChannelHandlerContext clientChannelContext) {
            this.clientChannelContext = clientChannelContext;
        }

        public void channelRead(ChannelHandlerContext ctx2, Object destMsg) throws Exception {
            this.clientChannelContext.writeAndFlush(destMsg);
        }

        public void channelInactive(ChannelHandlerContext ctx2) throws Exception {
            this.clientChannelContext.channel().close();
        }
    }
}

