/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.stream.storage.impl.cluster.ZkClusterInitializer;
import org.apache.pulsar.broker.admin.ZkAdminPaths;
import org.apache.pulsar.common.conf.InternalConfigurationData;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PoliciesUtil;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.common.util.CmdGenerateDocs;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.functions.worker.WorkerUtils;
import org.apache.pulsar.metadata.api.GetResult;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.MetadataStoreLifecycle;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarClusterMetadataSetup {
    private static final Logger log = LoggerFactory.getLogger(PulsarClusterMetadataSetup.class);

    private static void createMetadataNode(MetadataStore store, String path, byte[] data) throws InterruptedException, ExecutionException {
        block2: {
            try {
                store.put(path, data, Optional.of(-1L)).get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof MetadataStoreException.BadVersionException) break block2;
                throw e;
            }
        }
    }

    private static void initialDlogNamespaceMetadata(String configurationStore, String bkMetadataServiceUri) throws IOException {
        InternalConfigurationData internalConf = new InternalConfigurationData(configurationStore, configurationStore, null, bkMetadataServiceUri, null);
        WorkerUtils.initializeDlogNamespace((InternalConfigurationData)internalConf);
    }

    public static void main(String[] args) throws Exception {
        Arguments arguments = new Arguments();
        JCommander jcommander = new JCommander();
        try {
            jcommander.addObject((Object)arguments);
            jcommander.parse(args);
            if (arguments.help) {
                jcommander.usage();
                return;
            }
            if (arguments.generateDocs) {
                CmdGenerateDocs cmd = new CmdGenerateDocs("pulsar");
                cmd.addCommand("initialize-cluster-metadata", (Object)arguments);
                cmd.run(null);
                return;
            }
        }
        catch (Exception e) {
            jcommander.usage();
            throw e;
        }
        if (arguments.configurationStore == null && arguments.globalZookeeper == null) {
            System.err.println("Configuration store address argument is required (--configuration-store)");
            jcommander.usage();
            System.exit(1);
        }
        if (arguments.configurationStore != null && arguments.globalZookeeper != null) {
            System.err.println("Configuration store argument (--configuration-store) supersedes the deprecated (--global-zookeeper) argument");
            jcommander.usage();
            System.exit(1);
        }
        if (arguments.configurationStore == null) {
            arguments.configurationStore = arguments.globalZookeeper;
        }
        if (arguments.numTransactionCoordinators <= 0) {
            System.err.println("Number of transaction coordinators must greater than 0");
            System.exit(1);
        }
        log.info("Setting up cluster {} with zk={} configuration-store={}", new Object[]{arguments.cluster, arguments.zookeeper, arguments.configurationStore});
        MetadataStoreExtended localStore = PulsarClusterMetadataSetup.initMetadataStore(arguments.zookeeper, arguments.zkSessionTimeoutMillis);
        MetadataStoreExtended configStore = PulsarClusterMetadataSetup.initMetadataStore(arguments.configurationStore, arguments.zkSessionTimeoutMillis);
        ServerConfiguration bkConf = new ServerConfiguration();
        if (arguments.existingBkMetadataServiceUri == null && arguments.bookieMetadataServiceUri == null) {
            bkConf.setZkServers(arguments.zookeeper);
            bkConf.setZkTimeout(arguments.zkSessionTimeoutMillis);
            if (!((Boolean)localStore.exists("/ledgers").get()).booleanValue() && !BookKeeperAdmin.format((ServerConfiguration)bkConf, (boolean)false, (boolean)false)) {
                throw new IOException("Failed to initialize BookKeeper metadata");
            }
        }
        String uriStr = bkConf.getMetadataServiceUri();
        if (arguments.existingBkMetadataServiceUri != null) {
            uriStr = arguments.existingBkMetadataServiceUri;
        } else if (arguments.bookieMetadataServiceUri != null) {
            uriStr = arguments.bookieMetadataServiceUri;
        }
        ServiceURI bkMetadataServiceUri = ServiceURI.create((String)uriStr);
        PulsarClusterMetadataSetup.initialDlogNamespaceMetadata(arguments.configurationStore, uriStr);
        if (arguments.numStreamStorageContainers > 0) {
            ZkClusterInitializer initializer = new ZkClusterInitializer(arguments.zookeeper);
            initializer.initializeCluster(bkMetadataServiceUri.getUri(), arguments.numStreamStorageContainers);
        }
        if (!((Boolean)localStore.exists("/bookies").get()).booleanValue()) {
            PulsarClusterMetadataSetup.createMetadataNode((MetadataStore)localStore, "/bookies", "{}".getBytes());
        }
        PulsarClusterMetadataSetup.createMetadataNode((MetadataStore)localStore, "/managed-ledgers", new byte[0]);
        PulsarClusterMetadataSetup.createMetadataNode((MetadataStore)localStore, "/namespace", new byte[0]);
        PulsarClusterMetadataSetup.createMetadataNode((MetadataStore)configStore, "/admin/policies", new byte[0]);
        PulsarClusterMetadataSetup.createMetadataNode((MetadataStore)configStore, "/admin/clusters", new byte[0]);
        ClusterData clusterData = ClusterData.builder().serviceUrl(arguments.clusterWebServiceUrl).serviceUrlTls(arguments.clusterWebServiceUrlTls).brokerServiceUrl(arguments.clusterBrokerServiceUrl).brokerServiceUrlTls(arguments.clusterBrokerServiceUrlTls).build();
        byte[] clusterDataJson = ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)clusterData);
        PulsarClusterMetadataSetup.createMetadataNode((MetadataStore)configStore, "/admin/clusters/" + arguments.cluster, clusterDataJson);
        ClusterData globalClusterData = ClusterData.builder().build();
        byte[] globalClusterDataJson = ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)globalClusterData);
        PulsarClusterMetadataSetup.createMetadataNode((MetadataStore)configStore, "/admin/clusters/global", globalClusterDataJson);
        PulsarClusterMetadataSetup.createTenantIfAbsent((MetadataStore)configStore, "public", arguments.cluster);
        PulsarClusterMetadataSetup.createTenantIfAbsent((MetadataStore)configStore, NamespaceName.SYSTEM_NAMESPACE.getTenant(), arguments.cluster);
        PulsarClusterMetadataSetup.createNamespaceIfAbsent((MetadataStore)configStore, NamespaceName.get((String)"public", (String)"default"), arguments.cluster);
        PulsarClusterMetadataSetup.createNamespaceIfAbsent((MetadataStore)configStore, NamespaceName.SYSTEM_NAMESPACE, arguments.cluster);
        PulsarClusterMetadataSetup.createPartitionedTopic((MetadataStore)configStore, TopicName.TRANSACTION_COORDINATOR_ASSIGN, arguments.numTransactionCoordinators);
        localStore.close();
        configStore.close();
        log.info("Cluster metadata for '{}' setup correctly", (Object)arguments.cluster);
    }

    static void createTenantIfAbsent(MetadataStore configStore, String tenant, String cluster) throws IOException, InterruptedException, ExecutionException {
        String tenantPath = "/admin/policies/" + tenant;
        Optional getResult = (Optional)configStore.get(tenantPath).get();
        if (!getResult.isPresent()) {
            TenantInfoImpl publicTenant = new TenantInfoImpl(Collections.emptySet(), Collections.singleton(cluster));
            PulsarClusterMetadataSetup.createMetadataNode(configStore, tenantPath, ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)publicTenant));
        } else {
            byte[] content = ((GetResult)getResult.get()).getValue();
            TenantInfoImpl publicTenant = (TenantInfoImpl)ObjectMapperFactory.getThreadLocal().readValue(content, TenantInfoImpl.class);
            if (!publicTenant.getAllowedClusters().contains(cluster)) {
                publicTenant.getAllowedClusters().add(cluster);
                configStore.put(tenantPath, ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)publicTenant), Optional.of(((GetResult)getResult.get()).getStat().getVersion()));
            }
        }
    }

    static void createNamespaceIfAbsent(MetadataStore configStore, NamespaceName namespaceName, String cluster) throws InterruptedException, IOException, ExecutionException {
        String namespacePath = "/admin/policies/" + namespaceName.toString();
        Optional getResult = (Optional)configStore.get(namespacePath).get();
        if (!getResult.isPresent()) {
            Policies policies = new Policies();
            policies.bundles = PoliciesUtil.getBundles((int)16);
            policies.replication_clusters = Collections.singleton(cluster);
            PulsarClusterMetadataSetup.createMetadataNode(configStore, namespacePath, ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)policies));
        } else {
            byte[] content = ((GetResult)getResult.get()).getValue();
            Policies policies = (Policies)ObjectMapperFactory.getThreadLocal().readValue(content, Policies.class);
            if (!policies.replication_clusters.contains(cluster)) {
                policies.replication_clusters.add(cluster);
                configStore.put(namespacePath, ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)policies), Optional.of(((GetResult)getResult.get()).getStat().getVersion()));
            }
        }
    }

    static void createPartitionedTopic(MetadataStore configStore, TopicName topicName, int numPartitions) throws InterruptedException, IOException, ExecutionException {
        String partitionedTopicPath = ZkAdminPaths.partitionedTopicPath(topicName);
        Optional getResult = (Optional)configStore.get(partitionedTopicPath).get();
        PartitionedTopicMetadata metadata = new PartitionedTopicMetadata(numPartitions);
        if (!getResult.isPresent()) {
            PulsarClusterMetadataSetup.createMetadataNode(configStore, partitionedTopicPath, ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)metadata));
        } else {
            byte[] content = ((GetResult)getResult.get()).getValue();
            PartitionedTopicMetadata existsMeta = (PartitionedTopicMetadata)ObjectMapperFactory.getThreadLocal().readValue(content, PartitionedTopicMetadata.class);
            if (existsMeta.partitions < numPartitions) {
                configStore.put(partitionedTopicPath, ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)metadata), Optional.of(((GetResult)getResult.get()).getStat().getVersion()));
            }
        }
    }

    public static MetadataStoreExtended initMetadataStore(String connection, int sessionTimeout) throws Exception {
        MetadataStoreExtended store = MetadataStoreExtended.create((String)connection, (MetadataStoreConfig)MetadataStoreConfig.builder().sessionTimeoutMillis(sessionTimeout).build());
        if (store instanceof MetadataStoreLifecycle) {
            ((MetadataStoreLifecycle)store).initializeCluster().get();
        }
        return store;
    }

    private static class Arguments {
        @Parameter(names={"-c", "--cluster"}, description="Cluster name", required=true)
        private String cluster;
        @Parameter(names={"-uw", "--web-service-url"}, description="Web-service URL for new cluster", required=true)
        private String clusterWebServiceUrl;
        @Parameter(names={"-tw", "--web-service-url-tls"}, description="Web-service URL for new cluster with TLS encryption", required=false)
        private String clusterWebServiceUrlTls;
        @Parameter(names={"-ub", "--broker-service-url"}, description="Broker-service URL for new cluster", required=false)
        private String clusterBrokerServiceUrl;
        @Parameter(names={"-tb", "--broker-service-url-tls"}, description="Broker-service URL for new cluster with TLS encryption", required=false)
        private String clusterBrokerServiceUrlTls;
        @Parameter(names={"-zk", "--zookeeper"}, description="Local ZooKeeper quorum connection string", required=true)
        private String zookeeper;
        @Parameter(names={"--zookeeper-session-timeout-ms"}, description="Local zookeeper session timeout ms")
        private int zkSessionTimeoutMillis = 30000;
        @Parameter(names={"-gzk", "--global-zookeeper"}, description="Global ZooKeeper quorum connection string", required=false, hidden=true)
        private String globalZookeeper;
        @Parameter(names={"-cs", "--configuration-store"}, description="Configuration Store connection string", required=true)
        private String configurationStore;
        @Parameter(names={"--initial-num-stream-storage-containers"}, description="Num storage containers of BookKeeper stream storage")
        private int numStreamStorageContainers = 16;
        @Parameter(names={"--initial-num-transaction-coordinators"}, description="Num transaction coordinators will assigned in cluster")
        private int numTransactionCoordinators = 16;
        @Parameter(names={"--existing-bk-metadata-service-uri"}, description="The metadata service URI of the existing BookKeeper cluster that you want to use")
        private String existingBkMetadataServiceUri;
        @Deprecated
        @Parameter(names={"--bookkeeper-metadata-service-uri"}, description="The metadata service URI of the existing BookKeeper cluster that you want to use", hidden=true)
        private String bookieMetadataServiceUri;
        @Parameter(names={"-h", "--help"}, description="Show this help message")
        private boolean help = false;
        @Parameter(names={"-g", "--generate-docs"}, description="Generate docs")
        private boolean generateDocs = false;

        private Arguments() {
        }
    }
}

