/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import com.beust.jcommander.Parameter;
import com.google.common.collect.Sets;
import java.io.File;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Set;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.pulsar.PulsarStandaloneBuilder;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.service.WorkerServiceLoader;
import org.apache.pulsar.zookeeper.LocalBookkeeperEnsemble;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarStandalone
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(PulsarStandalone.class);
    PulsarService broker;
    PulsarAdmin admin;
    LocalBookkeeperEnsemble bkEnsemble;
    ServiceConfiguration config;
    WorkerService fnWorkerService;
    WorkerConfig workerConfig;
    @Parameter(names={"-c", "--config"}, description="Configuration file path", required=true)
    private String configFile;
    @Parameter(names={"--wipe-data"}, description="Clean up previous ZK/BK data")
    private boolean wipeData = false;
    @Parameter(names={"--num-bookies"}, description="Number of local Bookies")
    private int numOfBk = 1;
    @Parameter(names={"--zookeeper-port"}, description="Local zookeeper's port")
    private int zkPort = 2181;
    @Parameter(names={"--bookkeeper-port"}, description="Local bookies base port")
    private int bkPort = 3181;
    @Parameter(names={"--zookeeper-dir"}, description="Local zooKeeper's data directory")
    private String zkDir = "data/standalone/zookeeper";
    @Parameter(names={"--bookkeeper-dir"}, description="Local bookies base data directory")
    private String bkDir = "data/standalone/bookkeeper";
    @Parameter(names={"--no-broker"}, description="Only start ZK and BK services, no broker")
    private boolean noBroker = false;
    @Parameter(names={"--only-broker"}, description="Only start Pulsar broker service (no ZK, BK)")
    private boolean onlyBroker = false;
    @Parameter(names={"-nfw", "--no-functions-worker"}, description="Run functions worker with Broker")
    private boolean noFunctionsWorker = false;
    @Parameter(names={"-fwc", "--functions-worker-conf"}, description="Configuration file for Functions Worker")
    private String fnWorkerConfigFile = Paths.get("", new String[0]).toAbsolutePath().normalize().toString() + "/conf/functions_worker.yml";
    @Parameter(names={"-nss", "--no-stream-storage"}, description="Disable stream storage")
    private boolean noStreamStorage = false;
    @Parameter(names={"--stream-storage-port"}, description="Local bookies stream storage port")
    private int streamStoragePort = 4181;
    @Parameter(names={"-a", "--advertised-address"}, description="Standalone broker advertised address")
    private String advertisedAddress = null;
    @Parameter(names={"-h", "--help"}, description="Show this help message")
    private boolean help = false;

    public void setBroker(PulsarService broker) {
        this.broker = broker;
    }

    public void setAdmin(PulsarAdmin admin) {
        this.admin = admin;
    }

    public void setBkEnsemble(LocalBookkeeperEnsemble bkEnsemble) {
        this.bkEnsemble = bkEnsemble;
    }

    public void setBkPort(int bkPort) {
        this.bkPort = bkPort;
    }

    public void setBkDir(String bkDir) {
        this.bkDir = bkDir;
    }

    public void setAdvertisedAddress(String advertisedAddress) {
        this.advertisedAddress = advertisedAddress;
    }

    public void setConfig(ServiceConfiguration config) {
        this.config = config;
    }

    public void setFnWorkerService(WorkerService fnWorkerService) {
        this.fnWorkerService = fnWorkerService;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setWipeData(boolean wipeData) {
        this.wipeData = wipeData;
    }

    public void setNumOfBk(int numOfBk) {
        this.numOfBk = numOfBk;
    }

    public void setZkPort(int zkPort) {
        this.zkPort = zkPort;
    }

    public void setZkDir(String zkDir) {
        this.zkDir = zkDir;
    }

    public void setNoBroker(boolean noBroker) {
        this.noBroker = noBroker;
    }

    public void setOnlyBroker(boolean onlyBroker) {
        this.onlyBroker = onlyBroker;
    }

    public void setNoFunctionsWorker(boolean noFunctionsWorker) {
        this.noFunctionsWorker = noFunctionsWorker;
    }

    public void setFnWorkerConfigFile(String fnWorkerConfigFile) {
        this.fnWorkerConfigFile = fnWorkerConfigFile;
    }

    public void setNoStreamStorage(boolean noStreamStorage) {
        this.noStreamStorage = noStreamStorage;
    }

    public void setStreamStoragePort(int streamStoragePort) {
        this.streamStoragePort = streamStoragePort;
    }

    public void setHelp(boolean help) {
        this.help = help;
    }

    public ServiceConfiguration getConfig() {
        return this.config;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public boolean isWipeData() {
        return this.wipeData;
    }

    public int getNumOfBk() {
        return this.numOfBk;
    }

    public int getZkPort() {
        return this.zkPort;
    }

    public int getBkPort() {
        return this.bkPort;
    }

    public String getZkDir() {
        return this.zkDir;
    }

    public String getBkDir() {
        return this.bkDir;
    }

    public boolean isNoBroker() {
        return this.noBroker;
    }

    public boolean isOnlyBroker() {
        return this.onlyBroker;
    }

    public boolean isNoFunctionsWorker() {
        return this.noFunctionsWorker;
    }

    public String getFnWorkerConfigFile() {
        return this.fnWorkerConfigFile;
    }

    public boolean isNoStreamStorage() {
        return this.noStreamStorage;
    }

    public int getStreamStoragePort() {
        return this.streamStoragePort;
    }

    public String getAdvertisedAddress() {
        return this.advertisedAddress;
    }

    public boolean isHelp() {
        return this.help;
    }

    public void start() throws Exception {
        if (this.config == null) {
            System.exit(1);
        }
        log.debug("--- setup PulsarStandaloneStarter ---");
        if (!this.isOnlyBroker()) {
            ServerConfiguration bkServerConf = new ServerConfiguration();
            bkServerConf.loadConf(new File(this.configFile).toURI().toURL());
            this.bkEnsemble = new LocalBookkeeperEnsemble(this.getNumOfBk(), this.getZkPort(), this.getBkPort(), this.getStreamStoragePort(), this.getZkDir(), this.getBkDir(), this.isWipeData(), "127.0.0.1");
            this.bkEnsemble.startStandalone(bkServerConf, !this.isNoStreamStorage());
        }
        if (this.isNoBroker()) {
            return;
        }
        if (!this.isNoFunctionsWorker()) {
            this.workerConfig = PulsarService.initializeWorkerConfigFromBrokerConfig(this.config, this.getFnWorkerConfigFile());
            if (this.isNoStreamStorage()) {
                this.workerConfig.setStateStorageServiceUrl(null);
            } else if (this.workerConfig.getStateStorageServiceUrl() == null) {
                this.workerConfig.setStateStorageServiceUrl("bk://127.0.0.1:" + this.getStreamStoragePort());
            }
            this.fnWorkerService = WorkerServiceLoader.load((WorkerConfig)this.workerConfig);
        } else {
            this.workerConfig = new WorkerConfig();
        }
        this.broker = new PulsarService(this.config, this.workerConfig, Optional.ofNullable(this.fnWorkerService), exitCode -> {
            log.info("Halting standalone process with code {}", exitCode);
            LogManager.shutdown();
            Runtime.getRuntime().halt((int)exitCode);
        });
        this.broker.start();
        String cluster = this.config.getClusterName();
        if (!this.config.isTlsEnabled()) {
            URL webServiceUrl = new URL(String.format("http://%s:%d", this.config.getAdvertisedAddress(), this.config.getWebServicePort().get()));
            String brokerServiceUrl = String.format("pulsar://%s:%d", this.config.getAdvertisedAddress(), this.config.getBrokerServicePort().get());
            this.admin = PulsarAdmin.builder().serviceHttpUrl(webServiceUrl.toString()).authentication(this.config.getBrokerClientAuthenticationPlugin(), this.config.getBrokerClientAuthenticationParameters()).build();
            ClusterData clusterData = ClusterData.builder().serviceUrl(webServiceUrl.toString()).brokerServiceUrl(brokerServiceUrl).build();
            this.createSampleNameSpace(clusterData, cluster);
        } else {
            URL webServiceUrlTls = new URL(String.format("https://%s:%d", this.config.getAdvertisedAddress(), this.config.getWebServicePortTls().get()));
            String brokerServiceUrlTls = String.format("pulsar+ssl://%s:%d", this.config.getAdvertisedAddress(), this.config.getBrokerServicePortTls().get());
            PulsarAdminBuilder builder = PulsarAdmin.builder().serviceHttpUrl(webServiceUrlTls.toString()).authentication(this.config.getBrokerClientAuthenticationPlugin(), this.config.getBrokerClientAuthenticationParameters());
            if (this.config.isBrokerClientTlsEnabled()) {
                if (this.config.isBrokerClientTlsEnabledWithKeyStore()) {
                    builder.useKeyStoreTls(true).tlsTrustStoreType(this.config.getBrokerClientTlsTrustStoreType()).tlsTrustStorePath(this.config.getBrokerClientTlsTrustStore()).tlsTrustStorePassword(this.config.getBrokerClientTlsTrustStorePassword());
                } else {
                    builder.tlsTrustCertsFilePath(this.config.getBrokerClientTrustCertsFilePath());
                }
                builder.allowTlsInsecureConnection(this.config.isTlsAllowInsecureConnection());
            }
            this.admin = builder.build();
            ClusterData clusterData = ClusterData.builder().serviceUrlTls(webServiceUrlTls.toString()).brokerServiceUrlTls(brokerServiceUrlTls).build();
            this.createSampleNameSpace(clusterData, cluster);
        }
        this.createNameSpace(cluster, "public", "public/default");
        this.createNameSpace(cluster, NamespaceName.SYSTEM_NAMESPACE.getTenant(), NamespaceName.SYSTEM_NAMESPACE.toString());
        if (this.config.isTransactionCoordinatorEnabled() && !this.admin.namespaces().getTopics(NamespaceName.SYSTEM_NAMESPACE.toString()).contains(TopicName.TRANSACTION_COORDINATOR_ASSIGN.getPartition(0).toString())) {
            this.admin.topics().createPartitionedTopic(TopicName.TRANSACTION_COORDINATOR_ASSIGN.toString(), 1);
        }
        log.debug("--- setup completed ---");
    }

    private void createNameSpace(String cluster, String publicTenant, String defaultNamespace) {
        try {
            if (!this.admin.tenants().getTenants().contains(publicTenant)) {
                this.admin.tenants().createTenant(publicTenant, TenantInfo.builder().adminRoles((Set)Sets.newHashSet((Iterable)this.config.getSuperUserRoles())).allowedClusters((Set)Sets.newHashSet((Object[])new String[]{cluster})).build());
            }
            if (!this.admin.namespaces().getNamespaces(publicTenant).contains(defaultNamespace)) {
                this.admin.namespaces().createNamespace(defaultNamespace);
                this.admin.namespaces().setNamespaceReplicationClusters(defaultNamespace, (Set)Sets.newHashSet((Object[])new String[]{this.config.getClusterName()}));
            }
        }
        catch (PulsarAdminException e) {
            log.info(e.getMessage(), (Throwable)e);
        }
    }

    private void createSampleNameSpace(ClusterData clusterData, String cluster) {
        String tenant = "sample";
        String globalCluster = "global";
        String namespace = "sample/ns1";
        try {
            if (!this.admin.clusters().getClusters().contains(cluster)) {
                this.admin.clusters().createCluster(cluster, clusterData);
            } else {
                this.admin.clusters().updateCluster(cluster, clusterData);
            }
            try {
                this.admin.clusters().getCluster("global");
            }
            catch (PulsarAdminException.NotFoundException ex) {
                this.admin.clusters().createCluster("global", ClusterData.builder().build());
            }
            if (!this.admin.tenants().getTenants().contains("sample")) {
                this.admin.tenants().createTenant("sample", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Iterable)this.config.getSuperUserRoles()), (Set)Sets.newHashSet((Object[])new String[]{cluster})));
            }
            if (!this.admin.namespaces().getNamespaces("sample").contains("sample/ns1")) {
                this.admin.namespaces().createNamespace("sample/ns1");
            }
        }
        catch (PulsarAdminException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public static PulsarStandaloneBuilder builder() {
        return PulsarStandaloneBuilder.instance();
    }

    @Override
    public void close() {
        try {
            if (this.fnWorkerService != null) {
                this.fnWorkerService.stop();
            }
            if (this.broker != null) {
                this.broker.close();
            }
            if (this.bkEnsemble != null) {
                this.bkEnsemble.stop();
            }
        }
        catch (Exception e) {
            log.error("Shutdown failed: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

