/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.service.schema.SchemaRegistry;
import org.apache.pulsar.broker.service.schema.exceptions.IncompatibleSchemaException;
import org.apache.pulsar.broker.service.schema.exceptions.InvalidSchemaDataException;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.client.internal.DefaultImplementation;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.SchemaAutoUpdateCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.protocol.schema.DeleteSchemaResponse;
import org.apache.pulsar.common.protocol.schema.GetAllVersionsSchemaResponse;
import org.apache.pulsar.common.protocol.schema.GetSchemaResponse;
import org.apache.pulsar.common.protocol.schema.IsCompatibilityResponse;
import org.apache.pulsar.common.protocol.schema.LongSchemaVersionResponse;
import org.apache.pulsar.common.protocol.schema.PostSchemaPayload;
import org.apache.pulsar.common.protocol.schema.PostSchemaResponse;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.protocol.schema.SchemaVersion;
import org.apache.pulsar.common.schema.LongSchemaVersion;
import org.apache.pulsar.common.schema.SchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemasResourceBase
extends AdminResource {
    private final Clock clock;
    private static final Logger log = LoggerFactory.getLogger(SchemasResourceBase.class);

    public SchemasResourceBase() {
        this(Clock.systemUTC());
    }

    @VisibleForTesting
    public SchemasResourceBase(Clock clock) {
        this.clock = clock;
    }

    private static long getLongSchemaVersion(SchemaVersion schemaVersion) {
        if (schemaVersion instanceof LongSchemaVersion) {
            return ((LongSchemaVersion)schemaVersion).getVersion();
        }
        return -1L;
    }

    private String getSchemaId() {
        if (this.topicName.isPartitioned()) {
            return TopicName.get((String)this.topicName.getPartitionedTopicName()).getSchemaName();
        }
        return this.topicName.getSchemaName();
    }

    public void getSchema(boolean authoritative, AsyncResponse response) {
        this.validateDestinationAndAdminOperation(authoritative);
        String schemaId = this.getSchemaId();
        this.pulsar().getSchemaRegistryService().getSchema(schemaId).handle((schema, error) -> {
            SchemasResourceBase.handleGetSchemaResponse(response, schema, error);
            return null;
        });
    }

    public void getSchema(boolean authoritative, String version, AsyncResponse response) {
        this.validateDestinationAndAdminOperation(authoritative);
        String schemaId = this.getSchemaId();
        ByteBuffer bbVersion = ByteBuffer.allocate(8);
        bbVersion.putLong(Long.parseLong(version));
        SchemaVersion v = this.pulsar().getSchemaRegistryService().versionFromBytes(bbVersion.array());
        this.pulsar().getSchemaRegistryService().getSchema(schemaId, v).handle((schema, error) -> {
            SchemasResourceBase.handleGetSchemaResponse(response, schema, error);
            return null;
        });
    }

    public void getAllSchemas(boolean authoritative, AsyncResponse response) {
        this.validateDestinationAndAdminOperation(authoritative);
        String schemaId = this.getSchemaId();
        this.pulsar().getSchemaRegistryService().trimDeletedSchemaAndGetList(schemaId).handle((schema, error) -> {
            SchemasResourceBase.handleGetAllSchemasResponse(response, schema, error);
            return null;
        });
    }

    public void deleteSchema(boolean authoritative, AsyncResponse response) {
        this.validateDestinationAndAdminOperation(authoritative);
        String schemaId = this.getSchemaId();
        this.pulsar().getSchemaRegistryService().deleteSchema(schemaId, StringUtils.defaultIfEmpty((String)this.clientAppId(), (String)"")).handle((version, error) -> {
            if (Objects.isNull(error)) {
                response.resume((Object)Response.ok().entity((Object)DeleteSchemaResponse.builder().version(SchemasResourceBase.getLongSchemaVersion(version)).build()).build());
            } else {
                log.error("[{}] Failed to delete schema for topic {}", new Object[]{this.clientAppId(), this.topicName, error});
                response.resume(error);
            }
            return null;
        });
    }

    public void postSchema(PostSchemaPayload payload, boolean authoritative, AsyncResponse response) {
        this.validateDestinationAndAdminOperation(authoritative);
        ((CompletableFuture)this.getNamespacePoliciesAsync(this.namespaceName).thenAccept(policies -> {
            byte[] data;
            SchemaCompatibilityStrategy schemaCompatibilityStrategy = policies.schema_compatibility_strategy;
            if (schemaCompatibilityStrategy == SchemaCompatibilityStrategy.UNDEFINED) {
                schemaCompatibilityStrategy = SchemaCompatibilityStrategy.fromAutoUpdatePolicy((SchemaAutoUpdateCompatibilityStrategy)policies.schema_auto_update_compatibility_strategy);
            }
            if (SchemaType.KEY_VALUE.name().equals(payload.getType())) {
                try {
                    data = DefaultImplementation.getDefaultImplementation().convertKeyValueDataStringToSchemaInfoSchema(payload.getSchema().getBytes(Charsets.UTF_8));
                }
                catch (IOException conversionError) {
                    log.error("[{}] Failed to post schema for topic {}", new Object[]{this.clientAppId(), this.topicName, conversionError});
                    response.resume((Object)Response.serverError().build());
                    return;
                }
            } else {
                data = payload.getSchema().getBytes(Charsets.UTF_8);
            }
            ((CompletableFuture)this.pulsar().getSchemaRegistryService().putSchemaIfAbsent(this.getSchemaId(), SchemaData.builder().data(data).isDeleted(false).timestamp(this.clock.millis()).type(SchemaType.valueOf((String)payload.getType())).user(StringUtils.defaultIfEmpty((String)this.clientAppId(), (String)"")).props(payload.getProperties()).build(), schemaCompatibilityStrategy).thenAccept(version -> response.resume((Object)Response.accepted().entity((Object)PostSchemaResponse.builder().version(version).build()).build()))).exceptionally(error -> {
                if (error.getCause() instanceof IncompatibleSchemaException) {
                    response.resume((Object)Response.status((int)Response.Status.CONFLICT.getStatusCode(), (String)error.getCause().getMessage()).build());
                } else if (error instanceof InvalidSchemaDataException) {
                    response.resume((Object)Response.status((int)422, (String)error.getMessage()).build());
                } else {
                    log.error("[{}] Failed to post schema for topic {}", new Object[]{this.clientAppId(), this.topicName, error});
                    response.resume((Object)Response.serverError().build());
                }
                return null;
            });
        })).exceptionally(error -> {
            if (error.getCause() instanceof RestException) {
                response.resume((Object)Response.status((int)((RestException)((Object)((Object)error.getCause()))).getResponse().getStatus(), (String)error.getMessage()).build());
            } else {
                log.error("[{}] Failed to post schema for topic {}", new Object[]{this.clientAppId(), this.topicName, error});
                response.resume((Object)Response.serverError().build());
            }
            return null;
        });
    }

    public void testCompatibility(PostSchemaPayload payload, boolean authoritative, AsyncResponse response) {
        this.validateDestinationAndAdminOperation(authoritative);
        String schemaId = this.getSchemaId();
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        SchemaCompatibilityStrategy schemaCompatibilityStrategy = policies.schema_compatibility_strategy == SchemaCompatibilityStrategy.UNDEFINED ? SchemaCompatibilityStrategy.fromAutoUpdatePolicy((SchemaAutoUpdateCompatibilityStrategy)policies.schema_auto_update_compatibility_strategy) : policies.schema_compatibility_strategy;
        ((CompletableFuture)this.pulsar().getSchemaRegistryService().isCompatible(schemaId, SchemaData.builder().data(payload.getSchema().getBytes(Charsets.UTF_8)).isDeleted(false).timestamp(this.clock.millis()).type(SchemaType.valueOf((String)payload.getType())).user(StringUtils.defaultIfEmpty((String)this.clientAppId(), (String)"")).props(payload.getProperties()).build(), schemaCompatibilityStrategy).thenAccept(isCompatible -> response.resume((Object)Response.accepted().entity((Object)IsCompatibilityResponse.builder().isCompatibility(isCompatible.booleanValue()).schemaCompatibilityStrategy(schemaCompatibilityStrategy.name()).build()).build()))).exceptionally(error -> {
            response.resume((Object)Response.serverError().build());
            return null;
        });
    }

    public void getVersionBySchema(PostSchemaPayload payload, boolean authoritative, AsyncResponse response) {
        this.validateDestinationAndAdminOperation(authoritative);
        String schemaId = this.getSchemaId();
        ((CompletableFuture)this.pulsar().getSchemaRegistryService().findSchemaVersion(schemaId, SchemaData.builder().data(payload.getSchema().getBytes(Charsets.UTF_8)).isDeleted(false).timestamp(this.clock.millis()).type(SchemaType.valueOf((String)payload.getType())).user(StringUtils.defaultIfEmpty((String)this.clientAppId(), (String)"")).props(payload.getProperties()).build()).thenAccept(version -> response.resume((Object)Response.accepted().entity((Object)LongSchemaVersionResponse.builder().version(version).build()).build()))).exceptionally(error -> {
            log.error("[{}] Failed to get version by schema for topic {}", new Object[]{this.clientAppId(), this.topicName, error});
            response.resume((Object)Response.serverError().build());
            return null;
        });
    }

    @Override
    protected String domain() {
        return "persistent";
    }

    private static GetSchemaResponse convertSchemaAndMetadataToGetSchemaResponse(SchemaRegistry.SchemaAndMetadata schemaAndMetadata) {
        try {
            String schemaData = schemaAndMetadata.schema.getType() == SchemaType.KEY_VALUE ? DefaultImplementation.getDefaultImplementation().convertKeyValueSchemaInfoDataToString(DefaultImplementation.getDefaultImplementation().decodeKeyValueSchemaInfo(schemaAndMetadata.schema.toSchemaInfo())) : new String(schemaAndMetadata.schema.getData(), StandardCharsets.UTF_8);
            return GetSchemaResponse.builder().version(SchemasResourceBase.getLongSchemaVersion(schemaAndMetadata.version)).type(schemaAndMetadata.schema.getType()).timestamp(schemaAndMetadata.schema.getTimestamp()).data(schemaData).properties(schemaAndMetadata.schema.getProps()).build();
        }
        catch (IOException conversionError) {
            throw new RuntimeException(conversionError);
        }
    }

    private static void handleGetSchemaResponse(AsyncResponse response, SchemaRegistry.SchemaAndMetadata schema, Throwable error) {
        if (Objects.isNull(error)) {
            if (Objects.isNull(schema)) {
                response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
            } else if (schema.schema.isDeleted()) {
                response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
            } else {
                response.resume((Object)Response.ok().encoding("application/json").entity((Object)SchemasResourceBase.convertSchemaAndMetadataToGetSchemaResponse(schema)).build());
            }
        } else {
            log.error("Failed to get schema", error);
            response.resume(error);
        }
    }

    private static void handleGetAllSchemasResponse(AsyncResponse response, List<SchemaRegistry.SchemaAndMetadata> schemas, Throwable error) {
        if (Objects.isNull(error)) {
            if (Objects.isNull(schemas)) {
                response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
            } else {
                response.resume((Object)Response.ok().encoding("application/json").entity((Object)GetAllVersionsSchemaResponse.builder().getSchemaResponses(schemas.stream().map(SchemasResourceBase::convertSchemaAndMetadataToGetSchemaResponse).collect(Collectors.toList())).build()).build());
            }
        } else {
            log.error("Failed to get all schemas", error);
            response.resume(error);
        }
    }

    private void validateDestinationAndAdminOperation(boolean authoritative) {
        try {
            this.validateAdminAccessForTenant(this.topicName.getTenant());
            this.validateTopicOwnership(this.topicName, authoritative);
        }
        catch (RestException e) {
            if (e.getResponse().getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                throw new RestException(Response.Status.NOT_FOUND, "Not Found");
            }
            throw e;
        }
    }
}

