/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.cache;

import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.policies.data.ResourceQuota;
import org.apache.pulsar.metadata.api.MetadataCache;
import org.apache.pulsar.metadata.api.MetadataStore;

public class BundlesQuotas {
    private static final String RESOURCE_QUOTA_ROOT = "/loadbalance/resource-quota";
    private static final String DEFAULT_RESOURCE_QUOTA_PATH = "/loadbalance/resource-quota/default";
    private final MetadataCache<ResourceQuota> resourceQuotaCache;
    static final ResourceQuota INITIAL_QUOTA = new ResourceQuota();

    public BundlesQuotas(MetadataStore localStore) {
        this.resourceQuotaCache = localStore.getMetadataCache(ResourceQuota.class);
    }

    public CompletableFuture<Void> setDefaultResourceQuota(ResourceQuota quota) {
        return this.resourceQuotaCache.readModifyUpdateOrCreate(DEFAULT_RESOURCE_QUOTA_PATH, __ -> quota).thenApply(__ -> null);
    }

    public CompletableFuture<ResourceQuota> getDefaultResourceQuota() {
        return this.resourceQuotaCache.get(DEFAULT_RESOURCE_QUOTA_PATH).thenApply(optResourceQuota -> optResourceQuota.orElse(INITIAL_QUOTA));
    }

    public CompletableFuture<Void> setResourceQuota(String bundle, ResourceQuota quota) {
        return this.resourceQuotaCache.readModifyUpdateOrCreate("/loadbalance/resource-quota/" + bundle, __ -> quota).thenApply(__ -> null);
    }

    public CompletableFuture<Void> setResourceQuota(NamespaceBundle bundle, ResourceQuota quota) {
        return this.setResourceQuota(bundle.toString(), quota);
    }

    public CompletableFuture<ResourceQuota> getResourceQuota(NamespaceBundle bundle) {
        return this.getResourceQuota(bundle.toString());
    }

    public CompletableFuture<ResourceQuota> getResourceQuota(String bundle) {
        return this.resourceQuotaCache.get("/loadbalance/resource-quota/" + bundle.toString()).thenCompose(optResourceQuota -> {
            if (optResourceQuota.isPresent()) {
                return CompletableFuture.completedFuture(optResourceQuota.get());
            }
            return this.getDefaultResourceQuota();
        });
    }

    public CompletableFuture<Void> resetResourceQuota(NamespaceBundle bundle) {
        return this.resourceQuotaCache.delete("/loadbalance/resource-quota/" + bundle.toString());
    }

    static {
        INITIAL_QUOTA.setMsgRateIn(40.0);
        INITIAL_QUOTA.setMsgRateOut(120.0);
        INITIAL_QUOTA.setBandwidthIn(100000.0);
        INITIAL_QUOTA.setBandwidthOut(300000.0);
        INITIAL_QUOTA.setMemory(80.0);
        INITIAL_QUOTA.setDynamic(true);
    }
}

