/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resourcegroup;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.resourcegroup.ResourceGroup;
import org.apache.pulsar.broker.service.PublishRateLimiter;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.ResourceGroup;
import org.apache.pulsar.common.util.RateLimitFunction;
import org.apache.pulsar.common.util.RateLimiter;

public class ResourceGroupPublishLimiter
implements PublishRateLimiter,
RateLimitFunction,
AutoCloseable {
    protected volatile long publishMaxMessageRate = 0L;
    protected volatile long publishMaxByteRate = 0L;
    protected volatile boolean publishThrottlingEnabled = false;
    private volatile RateLimiter publishRateLimiterOnMessage;
    private volatile RateLimiter publishRateLimiterOnByte;
    private final ScheduledExecutorService scheduledExecutorService;
    ConcurrentHashMap<String, RateLimitFunction> rateLimitFunctionMap = new ConcurrentHashMap();

    public ResourceGroupPublishLimiter(ResourceGroup resourceGroup, ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.update(resourceGroup);
    }

    @Override
    public void checkPublishRate() {
    }

    @Override
    public void incrementPublishCount(int numOfMessages, long msgSizeInBytes) {
    }

    @Override
    public boolean resetPublishCount() {
        return true;
    }

    @Override
    public boolean isPublishRateExceeded() {
        return false;
    }

    @Override
    public void update(Policies policies, String clusterName) {
    }

    @Override
    public void update(PublishRate maxPublishRate) {
    }

    public void update(ResourceGroup.BytesAndMessagesCount maxPublishRate) {
        this.update(maxPublishRate.messages, maxPublishRate.bytes);
    }

    public ResourceGroup.BytesAndMessagesCount getResourceGroupPublishValues() {
        ResourceGroup.BytesAndMessagesCount bmc = new ResourceGroup.BytesAndMessagesCount();
        bmc.bytes = this.publishMaxByteRate;
        bmc.messages = this.publishMaxMessageRate;
        return bmc;
    }

    public void update(ResourceGroup resourceGroup) {
        long publishRateInMsgs = 0L;
        long publishRateInBytes = 0L;
        if (resourceGroup != null) {
            publishRateInBytes = resourceGroup.getPublishRateInBytes();
            publishRateInMsgs = resourceGroup.getPublishRateInMsgs();
        }
        this.update(publishRateInMsgs, publishRateInBytes);
    }

    public void update(long publishRateInMsgs, long publishRateInBytes) {
        this.replaceLimiters(() -> {
            if (publishRateInMsgs > 0L || publishRateInBytes > 0L) {
                this.publishThrottlingEnabled = true;
                this.publishMaxMessageRate = Math.max(publishRateInMsgs, 0L);
                this.publishMaxByteRate = Math.max(publishRateInBytes, 0L);
                if (this.publishMaxMessageRate > 0L) {
                    this.publishRateLimiterOnMessage = RateLimiter.builder().scheduledExecutorService(this.scheduledExecutorService).permits(this.publishMaxMessageRate).rateTime(1L).timeUnit(TimeUnit.SECONDS).rateLimitFunction(this::apply).build();
                }
                if (this.publishMaxByteRate > 0L) {
                    this.publishRateLimiterOnByte = RateLimiter.builder().scheduledExecutorService(this.scheduledExecutorService).permits(this.publishMaxByteRate).rateTime(1L).timeUnit(TimeUnit.SECONDS).rateLimitFunction(this::apply).build();
                }
            } else {
                this.publishMaxMessageRate = 0L;
                this.publishMaxByteRate = 0L;
                this.publishThrottlingEnabled = false;
                this.publishRateLimiterOnMessage = null;
                this.publishRateLimiterOnByte = null;
            }
        });
    }

    @Override
    public boolean tryAcquire(int numbers, long bytes) {
        return !(this.publishRateLimiterOnMessage != null && !this.publishRateLimiterOnMessage.tryAcquire((long)numbers) || this.publishRateLimiterOnByte != null && !this.publishRateLimiterOnByte.tryAcquire(bytes));
    }

    public void registerRateLimitFunction(String name, RateLimitFunction func) {
        this.rateLimitFunctionMap.put(name, func);
    }

    public void unregisterRateLimitFunction(String name) {
        this.rateLimitFunctionMap.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceLimiters(Runnable updater) {
        RateLimiter previousPublishRateLimiterOnMessage = this.publishRateLimiterOnMessage;
        this.publishRateLimiterOnMessage = null;
        RateLimiter previousPublishRateLimiterOnByte = this.publishRateLimiterOnByte;
        this.publishRateLimiterOnByte = null;
        try {
            if (updater != null) {
                updater.run();
            }
        }
        finally {
            if (previousPublishRateLimiterOnMessage != null) {
                previousPublishRateLimiterOnMessage.close();
            }
            if (previousPublishRateLimiterOnByte != null) {
                previousPublishRateLimiterOnByte.close();
            }
        }
    }

    @Override
    public void close() {
        this.apply();
        this.replaceLimiters(null);
    }

    public void apply() {
        RateLimiter currentTopicPublishRateLimiterOnMessage = this.publishRateLimiterOnMessage;
        RateLimiter currentTopicPublishRateLimiterOnByte = this.publishRateLimiterOnByte;
        if (currentTopicPublishRateLimiterOnMessage != null && currentTopicPublishRateLimiterOnMessage.getAvailablePermits() <= 0L || currentTopicPublishRateLimiterOnByte != null && currentTopicPublishRateLimiterOnByte.getAvailablePermits() <= 0L) {
            return;
        }
        for (Map.Entry<String, RateLimitFunction> entry : this.rateLimitFunctionMap.entrySet()) {
            entry.getValue().apply();
        }
    }
}

