/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.pulsar.broker.service.schema.DefaultSchemaRegistryService;
import org.apache.pulsar.broker.service.schema.KeyValueSchemaCompatibilityCheck;
import org.apache.pulsar.broker.service.schema.SchemaCompatibilityCheck;
import org.apache.pulsar.broker.service.schema.SchemaRegistry;
import org.apache.pulsar.broker.service.schema.SchemaRegistryServiceImpl;
import org.apache.pulsar.broker.service.schema.validator.SchemaRegistryServiceWithSchemaDataValidator;
import org.apache.pulsar.common.protocol.schema.SchemaStorage;
import org.apache.pulsar.common.schema.SchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SchemaRegistryService
extends SchemaRegistry {
    public static final Logger LOG = LoggerFactory.getLogger(SchemaRegistryService.class);
    public static final long NO_SCHEMA_VERSION = -1L;

    public static Map<SchemaType, SchemaCompatibilityCheck> getCheckers(Set<String> checkerClasses) throws Exception {
        HashMap checkers = Maps.newHashMap();
        for (String className : checkerClasses) {
            Class<?> checkerClass = Class.forName(className);
            SchemaCompatibilityCheck instance = (SchemaCompatibilityCheck)checkerClass.newInstance();
            checkers.put(instance.getSchemaType(), instance);
        }
        return checkers;
    }

    public static SchemaRegistryService create(SchemaStorage schemaStorage, Set<String> schemaRegistryCompatibilityCheckers) {
        if (schemaStorage != null) {
            try {
                Map<SchemaType, SchemaCompatibilityCheck> checkers = SchemaRegistryService.getCheckers(schemaRegistryCompatibilityCheckers);
                checkers.put(SchemaType.KEY_VALUE, new KeyValueSchemaCompatibilityCheck(checkers));
                return SchemaRegistryServiceWithSchemaDataValidator.of(new SchemaRegistryServiceImpl(schemaStorage, checkers));
            }
            catch (Exception e) {
                LOG.warn("Unable to create schema registry storage, defaulting to empty storage", (Throwable)e);
            }
        }
        return new DefaultSchemaRegistryService();
    }

    @Override
    public void close() throws Exception;
}

