/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus;

import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.broker.stats.prometheus.AggregatedProducerStats;
import org.apache.pulsar.broker.stats.prometheus.AggregatedReplicationStats;
import org.apache.pulsar.broker.stats.prometheus.AggregatedSubscriptionStats;
import org.apache.pulsar.broker.stats.prometheus.ManagedLedgerStats;
import org.apache.pulsar.common.util.SimpleTextOutputStream;

class TopicStats {
    int subscriptionsCount;
    int producersCount;
    int consumersCount;
    double rateIn;
    double rateOut;
    double throughputIn;
    double throughputOut;
    long msgInCounter;
    long bytesInCounter;
    long msgOutCounter;
    long bytesOutCounter;
    double averageMsgSize;
    public long msgBacklog;
    long backlogQuotaLimit;
    long backlogQuotaLimitTime;
    ManagedLedgerStats managedLedgerStats = new ManagedLedgerStats();
    Map<String, AggregatedReplicationStats> replicationStats = new HashMap<String, AggregatedReplicationStats>();
    Map<String, AggregatedSubscriptionStats> subscriptionStats = new HashMap<String, AggregatedSubscriptionStats>();
    Map<String, AggregatedProducerStats> producerStats = new HashMap<String, AggregatedProducerStats>();
    static Map<String, String> metricWithTypeDefinition = new HashMap<String, String>();

    TopicStats() {
    }

    public void reset() {
        this.subscriptionsCount = 0;
        this.producersCount = 0;
        this.consumersCount = 0;
        this.rateIn = 0.0;
        this.rateOut = 0.0;
        this.throughputIn = 0.0;
        this.throughputOut = 0.0;
        this.bytesInCounter = 0L;
        this.msgInCounter = 0L;
        this.bytesOutCounter = 0L;
        this.msgOutCounter = 0L;
        this.managedLedgerStats.reset();
        this.msgBacklog = 0L;
        this.backlogQuotaLimit = 0L;
        this.backlogQuotaLimitTime = -1L;
        this.replicationStats.clear();
        this.subscriptionStats.clear();
        this.producerStats.clear();
    }

    static void resetTypes() {
        metricWithTypeDefinition.clear();
    }

    static void printTopicStats(SimpleTextOutputStream stream, String cluster, String namespace, String topic, TopicStats stats) {
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_subscriptions_count", stats.subscriptionsCount);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_producers_count", stats.producersCount);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_consumers_count", stats.consumersCount);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_rate_in", stats.rateIn);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_rate_out", stats.rateOut);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_throughput_in", stats.throughputIn);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_throughput_out", stats.throughputOut);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_average_msg_size", stats.averageMsgSize);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_size", stats.managedLedgerStats.storageSize);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_logical_size", stats.managedLedgerStats.storageLogicalSize);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_msg_backlog", stats.msgBacklog);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_backlog_size", stats.managedLedgerStats.backlogSize);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_offloaded_size", stats.managedLedgerStats.offloadedStorageUsed);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_backlog_quota_limit", stats.backlogQuotaLimit);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_backlog_quota_limit_time", stats.backlogQuotaLimitTime);
        long[] latencyBuckets = stats.managedLedgerStats.storageWriteLatencyBuckets.getBuckets();
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_le_0_5", latencyBuckets[0]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_le_1", latencyBuckets[1]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_le_5", latencyBuckets[2]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_le_10", latencyBuckets[3]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_le_20", latencyBuckets[4]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_le_50", latencyBuckets[5]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_le_100", latencyBuckets[6]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_le_200", latencyBuckets[7]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_le_1000", latencyBuckets[8]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_overflow", latencyBuckets[9]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_count", stats.managedLedgerStats.storageWriteLatencyBuckets.getCount());
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_sum", stats.managedLedgerStats.storageWriteLatencyBuckets.getSum());
        long[] ledgerWriteLatencyBuckets = stats.managedLedgerStats.storageLedgerWriteLatencyBuckets.getBuckets();
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_ledger_write_latency_le_0_5", ledgerWriteLatencyBuckets[0]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_ledger_write_latency_le_1", ledgerWriteLatencyBuckets[1]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_ledger_write_latency_le_5", ledgerWriteLatencyBuckets[2]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_ledger_write_latency_le_10", ledgerWriteLatencyBuckets[3]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_ledger_write_latency_le_20", ledgerWriteLatencyBuckets[4]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_ledger_write_latency_le_50", ledgerWriteLatencyBuckets[5]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_ledger_write_latency_le_100", ledgerWriteLatencyBuckets[6]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_ledger_write_latency_le_200", ledgerWriteLatencyBuckets[7]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_ledger_write_latency_le_1000", ledgerWriteLatencyBuckets[8]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_ledger_write_latency_overflow", ledgerWriteLatencyBuckets[9]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_ledger_write_latency_count", stats.managedLedgerStats.storageLedgerWriteLatencyBuckets.getCount());
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_ledger_write_latency_sum", stats.managedLedgerStats.storageLedgerWriteLatencyBuckets.getSum());
        long[] entrySizeBuckets = stats.managedLedgerStats.entrySizeBuckets.getBuckets();
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_le_128", entrySizeBuckets[0]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_le_512", entrySizeBuckets[1]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_le_1_kb", entrySizeBuckets[2]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_le_2_kb", entrySizeBuckets[3]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_le_4_kb", entrySizeBuckets[4]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_le_16_kb", entrySizeBuckets[5]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_le_100_kb", entrySizeBuckets[6]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_le_1_mb", entrySizeBuckets[7]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_le_overflow", entrySizeBuckets[8]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_count", stats.managedLedgerStats.entrySizeBuckets.getCount());
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_sum", stats.managedLedgerStats.entrySizeBuckets.getSum());
        stats.producerStats.forEach((p, producerStats) -> {
            TopicStats.metric(stream, cluster, namespace, topic, p, producerStats.producerId, "pulsar_producer_msg_rate_in", producerStats.msgRateIn);
            TopicStats.metric(stream, cluster, namespace, topic, p, producerStats.producerId, "pulsar_producer_msg_throughput_in", producerStats.msgThroughputIn);
            TopicStats.metric(stream, cluster, namespace, topic, p, producerStats.producerId, "pulsar_producer_msg_average_Size", producerStats.averageMsgSize);
        });
        stats.subscriptionStats.forEach((n, subsStats) -> {
            TopicStats.metric(stream, cluster, namespace, topic, n, "pulsar_subscription_back_log", subsStats.msgBacklog);
            TopicStats.metric(stream, cluster, namespace, topic, n, "pulsar_subscription_back_log_no_delayed", subsStats.msgBacklogNoDelayed);
            TopicStats.metric(stream, cluster, namespace, topic, n, "pulsar_subscription_delayed", subsStats.msgDelayed);
            TopicStats.metric(stream, cluster, namespace, topic, n, "pulsar_subscription_msg_rate_redeliver", subsStats.msgRateRedeliver);
            TopicStats.metric(stream, cluster, namespace, topic, n, "pulsar_subscription_unacked_messages", subsStats.unackedMessages);
            TopicStats.metric(stream, cluster, namespace, topic, n, "pulsar_subscription_blocked_on_unacked_messages", subsStats.blockedSubscriptionOnUnackedMsgs ? 1L : 0L);
            TopicStats.metric(stream, cluster, namespace, topic, n, "pulsar_subscription_msg_rate_out", subsStats.msgRateOut);
            TopicStats.metric(stream, cluster, namespace, topic, n, "pulsar_subscription_msg_throughput_out", subsStats.msgThroughputOut);
            TopicStats.metric(stream, cluster, namespace, topic, n, "pulsar_out_bytes_total", subsStats.bytesOutCounter);
            TopicStats.metric(stream, cluster, namespace, topic, n, "pulsar_out_messages_total", subsStats.msgOutCounter);
            TopicStats.metric(stream, cluster, namespace, topic, n, "pulsar_subscription_last_expire_timestamp", subsStats.lastExpireTimestamp);
            TopicStats.metric(stream, cluster, namespace, topic, n, "pulsar_subscription_last_acked_timestamp", subsStats.lastAckedTimestamp);
            TopicStats.metric(stream, cluster, namespace, topic, n, "pulsar_subscription_last_consumed_flow_timestamp", subsStats.lastConsumedFlowTimestamp);
            TopicStats.metric(stream, cluster, namespace, topic, n, "pulsar_subscription_last_consumed_timestamp", subsStats.lastConsumedTimestamp);
            TopicStats.metric(stream, cluster, namespace, topic, n, "pulsar_subscription_last_mark_delete_advanced_timestamp", subsStats.lastMarkDeleteAdvancedTimestamp);
            TopicStats.metric(stream, cluster, namespace, topic, n, "pulsar_subscription_msg_rate_expired", subsStats.msgRateExpired);
            TopicStats.metric(stream, cluster, namespace, topic, n, "pulsar_subscription_total_msg_expired", subsStats.totalMsgExpired);
            subsStats.consumerStat.forEach((c, consumerStats) -> {
                TopicStats.metric(stream, cluster, namespace, topic, n, c.consumerName(), c.consumerId(), "pulsar_consumer_msg_rate_redeliver", consumerStats.msgRateRedeliver);
                TopicStats.metric(stream, cluster, namespace, topic, n, c.consumerName(), c.consumerId(), "pulsar_consumer_unacked_messages", consumerStats.unackedMessages);
                TopicStats.metric(stream, cluster, namespace, topic, n, c.consumerName(), c.consumerId(), "pulsar_consumer_blocked_on_unacked_messages", consumerStats.blockedSubscriptionOnUnackedMsgs ? 1L : 0L);
                TopicStats.metric(stream, cluster, namespace, topic, n, c.consumerName(), c.consumerId(), "pulsar_consumer_msg_rate_out", consumerStats.msgRateOut);
                TopicStats.metric(stream, cluster, namespace, topic, n, c.consumerName(), c.consumerId(), "pulsar_consumer_msg_throughput_out", consumerStats.msgThroughputOut);
                TopicStats.metric(stream, cluster, namespace, topic, n, c.consumerName(), c.consumerId(), "pulsar_consumer_available_permits", consumerStats.availablePermits);
                TopicStats.metric(stream, cluster, namespace, topic, n, c.consumerName(), c.consumerId(), "pulsar_out_bytes_total", consumerStats.bytesOutCounter);
                TopicStats.metric(stream, cluster, namespace, topic, n, c.consumerName(), c.consumerId(), "pulsar_out_messages_total", consumerStats.msgOutCounter);
            });
        });
        if (!stats.replicationStats.isEmpty()) {
            stats.replicationStats.forEach((remoteCluster, replStats) -> {
                TopicStats.metricWithRemoteCluster(stream, cluster, namespace, topic, "pulsar_replication_rate_in", remoteCluster, replStats.msgRateIn);
                TopicStats.metricWithRemoteCluster(stream, cluster, namespace, topic, "pulsar_replication_rate_out", remoteCluster, replStats.msgRateOut);
                TopicStats.metricWithRemoteCluster(stream, cluster, namespace, topic, "pulsar_replication_throughput_in", remoteCluster, replStats.msgThroughputIn);
                TopicStats.metricWithRemoteCluster(stream, cluster, namespace, topic, "pulsar_replication_throughput_out", remoteCluster, replStats.msgThroughputOut);
                TopicStats.metricWithRemoteCluster(stream, cluster, namespace, topic, "pulsar_replication_backlog", remoteCluster, replStats.replicationBacklog);
                TopicStats.metricWithRemoteCluster(stream, cluster, namespace, topic, "pulsar_replication_connected_count", remoteCluster, replStats.connectedCount);
                TopicStats.metricWithRemoteCluster(stream, cluster, namespace, topic, "pulsar_replication_rate_expired", remoteCluster, replStats.msgRateExpired);
                TopicStats.metricWithRemoteCluster(stream, cluster, namespace, topic, "pulsar_replication_delay_in_seconds", remoteCluster, replStats.replicationDelayInSeconds);
            });
        }
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_in_bytes_total", stats.bytesInCounter);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_in_messages_total", stats.msgInCounter);
    }

    static void metricType(SimpleTextOutputStream stream, String name) {
        if (!metricWithTypeDefinition.containsKey(name)) {
            metricWithTypeDefinition.put(name, "gauge");
            stream.write("# TYPE ").write(name).write(" gauge\n");
        }
    }

    private static void metric(SimpleTextOutputStream stream, String cluster, String namespace, String topic, String name, double value) {
        TopicStats.metricType(stream, name);
        stream.write(name).write("{cluster=\"").write(cluster).write("\",namespace=\"").write(namespace).write("\",topic=\"").write(topic).write("\"} ");
        stream.write(value).write(' ').write(System.currentTimeMillis()).write('\n');
    }

    private static void metric(SimpleTextOutputStream stream, String cluster, String namespace, String topic, String subscription, String name, long value) {
        TopicStats.metricType(stream, name);
        stream.write(name).write("{cluster=\"").write(cluster).write("\",namespace=\"").write(namespace).write("\",topic=\"").write(topic).write("\",subscription=\"").write(subscription).write("\"} ");
        stream.write(value).write(' ').write(System.currentTimeMillis()).write('\n');
    }

    private static void metric(SimpleTextOutputStream stream, String cluster, String namespace, String topic, String producerName, long produceId, String name, double value) {
        TopicStats.metricType(stream, name);
        stream.write(name).write("{cluster=\"").write(cluster).write("\",namespace=\"").write(namespace).write("\",topic=\"").write(topic).write("\",producer_name=\"").write(producerName).write("\",producer_id=\"").write(produceId).write("\"} ");
        stream.write(value).write(' ').write(System.currentTimeMillis()).write('\n');
    }

    private static void metric(SimpleTextOutputStream stream, String cluster, String namespace, String topic, String subscription, String name, double value) {
        TopicStats.metricType(stream, name);
        stream.write(name).write("{cluster=\"").write(cluster).write("\",namespace=\"").write(namespace).write("\",topic=\"").write(topic).write("\",subscription=\"").write(subscription).write("\"} ");
        stream.write(value).write(' ').write(System.currentTimeMillis()).write('\n');
    }

    private static void metric(SimpleTextOutputStream stream, String cluster, String namespace, String topic, String subscription, String consumerName, long consumerId, String name, long value) {
        TopicStats.metricType(stream, name);
        stream.write(name).write("{cluster=\"").write(cluster).write("\", namespace=\"").write(namespace).write("\",topic=\"").write(topic).write("\",subscription=\"").write(subscription).write("\",consumer_name=\"").write(consumerName).write("\",consumer_id=\"").write(consumerId).write("\"} ");
        stream.write(value).write(' ').write(System.currentTimeMillis()).write('\n');
    }

    private static void metric(SimpleTextOutputStream stream, String cluster, String namespace, String topic, String subscription, String consumerName, long consumerId, String name, double value) {
        TopicStats.metricType(stream, name);
        stream.write(name).write("{cluster=\"").write(cluster).write("\",namespace=\"").write(namespace).write("\",topic=\"").write(topic).write("\",subscription=\"").write(subscription).write("\",consumer_name=\"").write(consumerName).write("\",consumer_id=\"").write(consumerId).write("\"} ");
        stream.write(value).write(' ').write(System.currentTimeMillis()).write('\n');
    }

    private static void metricWithRemoteCluster(SimpleTextOutputStream stream, String cluster, String namespace, String topic, String name, String remoteCluster, double value) {
        TopicStats.metricType(stream, name);
        stream.write(name).write("{cluster=\"").write(cluster).write("\",namespace=\"").write(namespace);
        stream.write("\",topic=\"").write(topic).write("\",remote_cluster=\"").write(remoteCluster).write("\"} ");
        stream.write(value).write(' ').write(System.currentTimeMillis()).write('\n');
    }
}

