/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import com.google.common.collect.Lists;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.jetty.JettyStatisticsCollector;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.web.AuthenticationFilter;
import org.apache.pulsar.broker.web.DisableDebugHttpMethodFilter;
import org.apache.pulsar.broker.web.ExceptionHandler;
import org.apache.pulsar.broker.web.JettyRequestLogFactory;
import org.apache.pulsar.broker.web.JsonMapperProvider;
import org.apache.pulsar.broker.web.MaxRequestSizeFilter;
import org.apache.pulsar.broker.web.PreInterceptFilter;
import org.apache.pulsar.broker.web.ProcessHandlerFilter;
import org.apache.pulsar.broker.web.PulsarServerConnector;
import org.apache.pulsar.broker.web.RateLimitingFilter;
import org.apache.pulsar.broker.web.ResponseHandlerFilter;
import org.apache.pulsar.broker.web.WebExecutorThreadPool;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.common.util.keystoretls.KeyStoreSSLContext;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebService
implements AutoCloseable {
    private static final String MATCH_ALL = "/*";
    public static final String ATTRIBUTE_PULSAR_NAME = "pulsar";
    public static final String HANDLER_CACHE_CONTROL = "max-age=3600";
    private final PulsarService pulsar;
    private final Server server;
    private final List<Handler> handlers = Lists.newArrayList();
    private final WebExecutorThreadPool webServiceExecutor;
    public final int maxConcurrentRequests;
    private final ServerConnector httpConnector;
    private final ServerConnector httpsConnector;
    private JettyStatisticsCollector jettyStatisticsCollector;
    private static final Logger log = LoggerFactory.getLogger(WebService.class);

    public WebService(PulsarService pulsar) throws PulsarServerException {
        this.pulsar = pulsar;
        this.webServiceExecutor = new WebExecutorThreadPool(pulsar.getConfiguration().getNumHttpServerThreads(), "pulsar-web");
        this.server = new Server((ThreadPool)this.webServiceExecutor);
        this.maxConcurrentRequests = pulsar.getConfiguration().getMaxConcurrentHttpRequests();
        ArrayList<ServerConnector> connectors = new ArrayList<ServerConnector>();
        Optional port = pulsar.getConfiguration().getWebServicePort();
        if (port.isPresent()) {
            this.httpConnector = new PulsarServerConnector(this.server, 1, 1);
            this.httpConnector.setPort(((Integer)port.get()).intValue());
            this.httpConnector.setHost(pulsar.getBindAddress());
            connectors.add(this.httpConnector);
        } else {
            this.httpConnector = null;
        }
        Optional tlsPort = pulsar.getConfiguration().getWebServicePortTls();
        if (tlsPort.isPresent()) {
            try {
                ServiceConfiguration config = pulsar.getConfiguration();
                SslContextFactory sslCtxFactory = config.isTlsEnabledWithKeyStore() ? KeyStoreSSLContext.createSslContextFactory((String)config.getTlsProvider(), (String)config.getTlsKeyStoreType(), (String)config.getTlsKeyStore(), (String)config.getTlsKeyStorePassword(), (boolean)config.isTlsAllowInsecureConnection(), (String)config.getTlsTrustStoreType(), (String)config.getTlsTrustStore(), (String)config.getTlsTrustStorePassword(), (boolean)config.isTlsRequireTrustedClientCertOnConnect(), (long)config.getTlsCertRefreshCheckDurationSec()) : SecurityUtility.createSslContextFactory((boolean)config.isTlsAllowInsecureConnection(), (String)config.getTlsTrustCertsFilePath(), (String)config.getTlsCertificateFilePath(), (String)config.getTlsKeyFilePath(), (boolean)config.isTlsRequireTrustedClientCertOnConnect(), (boolean)true, (long)config.getTlsCertRefreshCheckDurationSec());
                this.httpsConnector = new PulsarServerConnector(this.server, 1, 1, sslCtxFactory);
                this.httpsConnector.setPort(((Integer)tlsPort.get()).intValue());
                this.httpsConnector.setHost(pulsar.getBindAddress());
                connectors.add(this.httpsConnector);
            }
            catch (Exception e) {
                throw new PulsarServerException((Throwable)e);
            }
        } else {
            this.httpsConnector = null;
        }
        connectors.forEach(c -> c.setAcceptQueueSize(this.maxConcurrentRequests / connectors.size()));
        this.server.setConnectors((Connector[])connectors.toArray(new ServerConnector[connectors.size()]));
    }

    public void addRestResources(String basePath, String javaPackages, boolean requiresAuthentication, Map<String, Object> attributeMap) {
        ResourceConfig config = new ResourceConfig();
        config.packages(new String[]{"jersey.config.server.provider.packages", javaPackages});
        config.register(JsonMapperProvider.class);
        config.register(MultiPartFeature.class);
        ServletHolder servletHolder = new ServletHolder((Servlet)new ServletContainer(config));
        servletHolder.setAsyncSupported(true);
        this.addServlet(basePath, servletHolder, requiresAuthentication, attributeMap);
    }

    public void addServlet(String path, ServletHolder servletHolder, boolean requiresAuthentication, Map<String, Object> attributeMap) {
        FilterHolder filter;
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath(path);
        context.addServlet(servletHolder, MATCH_ALL);
        if (attributeMap != null) {
            attributeMap.forEach((key, value) -> context.setAttribute(key, value));
        }
        if (!this.pulsar.getConfig().getBrokerInterceptors().isEmpty() || !this.pulsar.getConfig().isDisableBrokerInterceptors()) {
            ExceptionHandler handler = new ExceptionHandler();
            context.addFilter(new FilterHolder((Filter)new PreInterceptFilter(this.pulsar.getBrokerInterceptor(), handler)), MATCH_ALL, EnumSet.allOf(DispatcherType.class));
            context.addFilter(new FilterHolder((Filter)new ProcessHandlerFilter(this.pulsar)), MATCH_ALL, EnumSet.allOf(DispatcherType.class));
        }
        if (requiresAuthentication && this.pulsar.getConfiguration().isAuthenticationEnabled()) {
            filter = new FilterHolder((Filter)new AuthenticationFilter(this.pulsar.getBrokerService().getAuthenticationService()));
            context.addFilter(filter, MATCH_ALL, EnumSet.allOf(DispatcherType.class));
        }
        if (this.pulsar.getConfig().isDisableHttpDebugMethods()) {
            filter = new FilterHolder((Filter)new DisableDebugHttpMethodFilter(this.pulsar.getConfig()));
            context.addFilter(filter, MATCH_ALL, EnumSet.allOf(DispatcherType.class));
        }
        if (this.pulsar.getConfiguration().isHttpRequestsLimitEnabled()) {
            context.addFilter(new FilterHolder((Filter)new RateLimitingFilter(this.pulsar.getConfiguration().getHttpRequestsMaxPerSecond())), MATCH_ALL, EnumSet.allOf(DispatcherType.class));
        }
        if (this.pulsar.getConfig().getHttpMaxRequestSize() > 0L) {
            context.addFilter(new FilterHolder((Filter)new MaxRequestSizeFilter(this.pulsar.getConfig().getHttpMaxRequestSize())), MATCH_ALL, EnumSet.allOf(DispatcherType.class));
        }
        FilterHolder responseFilter = new FilterHolder((Filter)new ResponseHandlerFilter(this.pulsar));
        context.addFilter(responseFilter, MATCH_ALL, EnumSet.allOf(DispatcherType.class));
        this.handlers.add((Handler)context);
    }

    public void addStaticResources(String basePath, String resourcePath) {
        ContextHandler capHandler = new ContextHandler();
        capHandler.setContextPath(basePath);
        ResourceHandler resHandler = new ResourceHandler();
        resHandler.setBaseResource(Resource.newClassPathResource((String)resourcePath));
        resHandler.setEtags(true);
        resHandler.setCacheControl(HANDLER_CACHE_CONTROL);
        capHandler.setHandler((Handler)resHandler);
        this.handlers.add((Handler)capHandler);
    }

    public void start() throws PulsarServerException {
        try {
            RequestLogHandler requestLogHandler = new RequestLogHandler();
            requestLogHandler.setRequestLog((RequestLog)JettyRequestLogFactory.createRequestLogger());
            this.handlers.add(0, (Handler)new ContextHandlerCollection());
            this.handlers.add((Handler)requestLogHandler);
            ContextHandlerCollection contexts = new ContextHandlerCollection();
            contexts.setHandlers(this.handlers.toArray(new Handler[this.handlers.size()]));
            HandlerCollection handlerCollection = new HandlerCollection();
            handlerCollection.setHandlers(new Handler[]{contexts, new DefaultHandler(), requestLogHandler});
            StatisticsHandler stats = new StatisticsHandler();
            stats.setHandler((Handler)handlerCollection);
            try {
                this.jettyStatisticsCollector = new JettyStatisticsCollector(stats);
                this.jettyStatisticsCollector.register();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.handlers.add((Handler)stats);
            this.server.setHandler((Handler)stats);
            this.server.start();
            if (this.httpConnector != null) {
                log.info("HTTP Service started at http://{}:{}", (Object)this.httpConnector.getHost(), (Object)this.httpConnector.getLocalPort());
                this.pulsar.getConfiguration().setWebServicePort(Optional.of(this.httpConnector.getLocalPort()));
            } else {
                log.info("HTTP Service disabled");
            }
            if (this.httpsConnector != null) {
                log.info("HTTPS Service started at https://{}:{}", (Object)this.httpsConnector.getHost(), (Object)this.httpsConnector.getLocalPort());
                this.pulsar.getConfiguration().setWebServicePortTls(Optional.of(this.httpsConnector.getLocalPort()));
            } else {
                log.info("HTTPS Service disabled");
            }
        }
        catch (Exception e) {
            throw new PulsarServerException((Throwable)e);
        }
    }

    @Override
    public void close() throws PulsarServerException {
        try {
            this.server.stop();
            if (this.jettyStatisticsCollector != null) {
                try {
                    CollectorRegistry.defaultRegistry.unregister((Collector)this.jettyStatisticsCollector);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.jettyStatisticsCollector = null;
            }
            this.webServiceExecutor.join();
            log.info("Web service closed");
        }
        catch (Exception e) {
            throw new PulsarServerException((Throwable)e);
        }
    }

    public Optional<Integer> getListenPortHTTP() {
        if (this.httpConnector != null) {
            return Optional.of(this.httpConnector.getLocalPort());
        }
        return Optional.empty();
    }

    public Optional<Integer> getListenPortHTTPS() {
        if (this.httpsConnector != null) {
            return Optional.of(this.httpsConnector.getLocalPort());
        }
        return Optional.empty();
    }
}

