/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.compaction;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import org.apache.pulsar.compaction.CompactorMXBean;

public class CompactorMXBeanImpl
implements CompactorMXBean {
    private final ConcurrentHashMap<String, CompactRecord> compactRecordOps = new ConcurrentHashMap();

    public void addCompactionRemovedEvent(String topic) {
        this.compactRecordOps.computeIfAbsent(topic, k -> new CompactRecord()).addCompactionRemovedEvent();
    }

    public void addCompactionStartOp(String topic) {
        this.compactRecordOps.computeIfAbsent(topic, k -> new CompactRecord()).reset();
    }

    public void addCompactionEndOp(String topic, boolean succeed) {
        CompactRecord compactRecord = this.compactRecordOps.computeIfAbsent(topic, k -> new CompactRecord());
        compactRecord.lastCompactionDurationTimeInMills = System.currentTimeMillis() - compactRecord.lastCompactionStartTimeOp;
        compactRecord.lastCompactionRemovedEventCount = compactRecord.lastCompactionRemovedEventCountOp.longValue();
        if (succeed) {
            compactRecord.lastCompactionSucceedTimestamp = System.currentTimeMillis();
        } else {
            compactRecord.lastCompactionFailedTimestamp = System.currentTimeMillis();
        }
    }

    @Override
    public long getLastCompactionRemovedEventCount(String topic) {
        return this.compactRecordOps.getOrDefault(topic, new CompactRecord()).lastCompactionRemovedEventCount;
    }

    @Override
    public long getLastCompactionSucceedTimestamp(String topic) {
        return this.compactRecordOps.getOrDefault(topic, new CompactRecord()).lastCompactionSucceedTimestamp;
    }

    @Override
    public long getLastCompactionFailedTimestamp(String topic) {
        return this.compactRecordOps.getOrDefault(topic, new CompactRecord()).lastCompactionFailedTimestamp;
    }

    @Override
    public long getLastCompactionDurationTimeInMills(String topic) {
        return this.compactRecordOps.getOrDefault(topic, new CompactRecord()).lastCompactionDurationTimeInMills;
    }

    @Override
    public void removeTopic(String topic) {
        this.compactRecordOps.remove(topic);
    }

    static class CompactRecord {
        private long lastCompactionRemovedEventCount = 0L;
        private long lastCompactionSucceedTimestamp = 0L;
        private long lastCompactionFailedTimestamp = 0L;
        private long lastCompactionDurationTimeInMills = 0L;
        private LongAdder lastCompactionRemovedEventCountOp = new LongAdder();
        private long lastCompactionStartTimeOp;

        CompactRecord() {
        }

        public void addCompactionRemovedEvent() {
            this.lastCompactionRemovedEventCountOp.increment();
        }

        public void reset() {
            this.lastCompactionRemovedEventCountOp.reset();
            this.lastCompactionStartTimeOp = System.currentTimeMillis();
        }
    }
}

