/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.protocol;

import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import org.apache.pulsar.broker.ClassLoaderSwitcher;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.protocol.ProtocolHandler;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProtocolHandlerWithClassLoader
implements ProtocolHandler {
    private static final Logger log = LoggerFactory.getLogger(ProtocolHandlerWithClassLoader.class);
    private final ProtocolHandler handler;
    private final NarClassLoader classLoader;

    @Override
    public String protocolName() {
        try (ClassLoaderSwitcher ignored = new ClassLoaderSwitcher((ClassLoader)this.classLoader);){
            String string = this.handler.protocolName();
            return string;
        }
    }

    @Override
    public boolean accept(String protocol) {
        try (ClassLoaderSwitcher ignored = new ClassLoaderSwitcher((ClassLoader)this.classLoader);){
            boolean bl = this.handler.accept(protocol);
            return bl;
        }
    }

    @Override
    public void initialize(ServiceConfiguration conf) throws Exception {
        try (ClassLoaderSwitcher ignored = new ClassLoaderSwitcher((ClassLoader)this.classLoader);){
            this.handler.initialize(conf);
        }
    }

    @Override
    public String getProtocolDataToAdvertise() {
        try (ClassLoaderSwitcher ignored = new ClassLoaderSwitcher((ClassLoader)this.classLoader);){
            String string = this.handler.getProtocolDataToAdvertise();
            return string;
        }
    }

    @Override
    public void start(BrokerService service) {
        try (ClassLoaderSwitcher ignored = new ClassLoaderSwitcher((ClassLoader)this.classLoader);){
            this.handler.start(service);
        }
    }

    @Override
    public Map<InetSocketAddress, ChannelInitializer<SocketChannel>> newChannelInitializers() {
        try (ClassLoaderSwitcher ignored = new ClassLoaderSwitcher((ClassLoader)this.classLoader);){
            Map<InetSocketAddress, ChannelInitializer<SocketChannel>> map = this.handler.newChannelInitializers();
            return map;
        }
    }

    @Override
    public void close() {
        try (ClassLoaderSwitcher ignored = new ClassLoaderSwitcher((ClassLoader)this.classLoader);){
            this.handler.close();
        }
        try {
            this.classLoader.close();
        }
        catch (IOException e) {
            log.warn("Failed to close the protocol handler class loader", (Throwable)e);
        }
    }

    public ProtocolHandler getHandler() {
        return this.handler;
    }

    public NarClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProtocolHandlerWithClassLoader)) {
            return false;
        }
        ProtocolHandlerWithClassLoader other = (ProtocolHandlerWithClassLoader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ProtocolHandler this$handler = this.getHandler();
        ProtocolHandler other$handler = other.getHandler();
        if (this$handler == null ? other$handler != null : !this$handler.equals(other$handler)) {
            return false;
        }
        NarClassLoader this$classLoader = this.getClassLoader();
        NarClassLoader other$classLoader = other.getClassLoader();
        return !(this$classLoader == null ? other$classLoader != null : !this$classLoader.equals(other$classLoader));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProtocolHandlerWithClassLoader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProtocolHandler $handler = this.getHandler();
        result = result * 59 + ($handler == null ? 43 : $handler.hashCode());
        NarClassLoader $classLoader = this.getClassLoader();
        result = result * 59 + ($classLoader == null ? 43 : $classLoader.hashCode());
        return result;
    }

    public String toString() {
        return "ProtocolHandlerWithClassLoader(handler=" + this.getHandler() + ", classLoader=" + this.getClassLoader() + ")";
    }

    public ProtocolHandlerWithClassLoader(ProtocolHandler handler, NarClassLoader classLoader) {
        this.handler = handler;
        this.classLoader = classLoader;
    }
}

