package org.apache.pulsar.broker.delayed.proto;
public final class SnapshotSegment {
	private java.util.List<DelayedIndex> indexes = null;
	private int _indexesCount = 0;
	private static final int _INDEXES_FIELD_NUMBER = 1;
	private static final int _INDEXES_TAG = (_INDEXES_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_LENGTH_DELIMITED;
	private static final int _INDEXES_TAG_SIZE = LightProtoCodec.computeVarIntSize(_INDEXES_TAG);
	public int getIndexesCount() {
		return _indexesCount;
	}
	public DelayedIndex getIndexeAt(int idx) {
		if (idx < 0 || idx >= _indexesCount) {
			throw new IndexOutOfBoundsException(
					"Index " + idx + " is out of the list size (" + _indexesCount + ") for field 'indexes'");
		}
		return indexes.get(idx);
	}
	public java.util.List<DelayedIndex> getIndexesList() {
		if (_indexesCount == 0) {
			return java.util.Collections.emptyList();
		} else {
			return indexes.subList(0, _indexesCount);
		}
	}
	public DelayedIndex addIndexe() {
		if (indexes == null) {
			indexes = new java.util.ArrayList<DelayedIndex>();
		}
		if (indexes.size() == _indexesCount) {
			indexes.add(new DelayedIndex());
		}
		_cachedSize = -1;
		return indexes.get(_indexesCount++);
	}
	public SnapshotSegment addAllIndexes(Iterable<DelayedIndex> indexes) {
		for (DelayedIndex _o : indexes) {
			addIndexe().copyFrom(_o);
		}
		return this;
	}
	public SnapshotSegment clearIndexes() {
		for (int i = 0; i < _indexesCount; i++) {
			indexes.get(i).clear();
		}
		_indexesCount = 0;
		return this;
	}

	private int _bitField0;
	private static final int _REQUIRED_FIELDS_MASK0 = 0;
	public int writeTo(io.netty.buffer.ByteBuf _b) {
		int _writeIdx = _b.writerIndex();
		for (int i = 0; i < _indexesCount; i++) {
			DelayedIndex _item = indexes.get(i);
			LightProtoCodec.writeVarInt(_b, _INDEXES_TAG);
			LightProtoCodec.writeVarInt(_b, _item.getSerializedSize());
			_item.writeTo(_b);
		}
		return (_b.writerIndex() - _writeIdx);
	}
	public int getSerializedSize() {
		if (_cachedSize > -1) {
			return _cachedSize;
		}

		int _size = 0;
		for (int i = 0; i < _indexesCount; i++) {
			DelayedIndex _item = indexes.get(i);
			_size += _INDEXES_TAG_SIZE;
			int MsgsizeIndexes = _item.getSerializedSize();
			_size += LightProtoCodec.computeVarIntSize(MsgsizeIndexes) + MsgsizeIndexes;
		}
		_cachedSize = _size;
		return _size;
	}
	public void parseFrom(io.netty.buffer.ByteBuf _buffer, int _size) {
		clear();
		int _endIdx = _buffer.readerIndex() + _size;
		while (_buffer.readerIndex() < _endIdx) {
			int _tag = LightProtoCodec.readVarInt(_buffer);
			switch (_tag) {
				case _INDEXES_TAG :
					int _indexesSize = LightProtoCodec.readVarInt(_buffer);
					addIndexe().parseFrom(_buffer, _indexesSize);
					break;
				default :
					LightProtoCodec.skipUnknownField(_tag, _buffer);
			}
		}
		_parsedBuffer = _buffer;
	}
	public SnapshotSegment clear() {
		for (int i = 0; i < _indexesCount; i++) {
			indexes.get(i).clear();
		}
		_indexesCount = 0;
		_parsedBuffer = null;
		_cachedSize = -1;
		_bitField0 = 0;
		return this;
	}
	public SnapshotSegment copyFrom(SnapshotSegment _other) {
		_cachedSize = -1;
		for (int i = 0; i < _other.getIndexesCount(); i++) {
			addIndexe().copyFrom(_other.getIndexeAt(i));
		}
		return this;
	}
	public byte[] toByteArray() {
		byte[] a = new byte[getSerializedSize()];
		io.netty.buffer.ByteBuf b = io.netty.buffer.Unpooled.wrappedBuffer(a).writerIndex(0);
		this.writeTo(b);
		return a;
	}
	public void parseFrom(byte[] a) {
		io.netty.buffer.ByteBuf b = io.netty.buffer.Unpooled.wrappedBuffer(a);
		this.parseFrom(b, b.readableBytes());
	}
	private int _cachedSize;

	private io.netty.buffer.ByteBuf _parsedBuffer;

}
