/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.CommaParameterSplitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Supplier;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.policies.data.TenantInfo;

@Parameters(commandDescription="Operations about tenants")
public class CmdTenants
extends CmdBase {
    public CmdTenants(Supplier<PulsarAdmin> admin) {
        super("tenants", admin);
        this.jcommander.addCommand("list", (Object)new List());
        this.jcommander.addCommand("get", (Object)new Get());
        this.jcommander.addCommand("create", (Object)new Create());
        this.jcommander.addCommand("update", (Object)new Update());
        this.jcommander.addCommand("delete", (Object)new Delete());
    }

    @Parameters(hidden=true)
    static class CmdProperties
    extends CmdTenants {
        public CmdProperties(Supplier<PulsarAdmin> admin) {
            super(admin);
        }

        @Override
        public boolean run(String[] args) {
            System.err.println("WARN: The properties subcommand is deprecated. Please use tenants instead");
            return super.run(args);
        }
    }

    @Parameters(commandDescription="Deletes an existing tenant")
    private class Delete
    extends CliCommand {
        @Parameter(description="tenant-name", required=true)
        private java.util.List<String> params;
        @Parameter(names={"-f", "--force"}, description="Delete a tenant forcefully by deleting all namespaces under it.")
        private boolean force = false;

        private Delete() {
        }

        @Override
        void run() throws PulsarAdminException {
            String tenant = Delete.getOneArgument(this.params);
            CmdTenants.this.getAdmin().tenants().deleteTenant(tenant, this.force);
        }
    }

    @Parameters(commandDescription="Updates the configuration for a tenant")
    private class Update
    extends CliCommand {
        @Parameter(description="tenant-name", required=true)
        private java.util.List<String> params;
        @Parameter(names={"--admin-roles", "-r"}, description="Comma separated list of auth principal allowed to administrate the tenant. If empty the current set of roles won't be modified", required=false, splitter=CommaParameterSplitter.class)
        private java.util.List<String> adminRoles;
        @Parameter(names={"--allowed-clusters", "-c"}, description="Comma separated allowed clusters. If omitted, the current set of clusters will be preserved", required=false, splitter=CommaParameterSplitter.class)
        private java.util.List<String> allowedClusters;

        private Update() {
        }

        @Override
        void run() throws PulsarAdminException {
            String tenant = Update.getOneArgument(this.params);
            if (this.adminRoles == null) {
                this.adminRoles = new ArrayList<String>(CmdTenants.this.getAdmin().tenants().getTenantInfo(tenant).getAdminRoles());
            }
            if (this.allowedClusters == null) {
                this.allowedClusters = new ArrayList<String>(CmdTenants.this.getAdmin().tenants().getTenantInfo(tenant).getAllowedClusters());
            }
            TenantInfo tenantInfo = new TenantInfo(new HashSet<String>(this.adminRoles), new HashSet<String>(this.allowedClusters));
            CmdTenants.this.getAdmin().tenants().updateTenant(tenant, tenantInfo);
        }
    }

    @Parameters(commandDescription="Creates a new tenant")
    private class Create
    extends CliCommand {
        @Parameter(description="tenant-name", required=true)
        private java.util.List<String> params;
        @Parameter(names={"--admin-roles", "-r"}, description="Comma separated list of auth principal allowed to administrate the tenant", required=false, splitter=CommaParameterSplitter.class)
        private java.util.List<String> adminRoles;
        @Parameter(names={"--allowed-clusters", "-c"}, description="Comma separated allowed clusters. If empty, the tenant will have access to all clusters", required=false, splitter=CommaParameterSplitter.class)
        private java.util.List<String> allowedClusters;

        private Create() {
        }

        @Override
        void run() throws PulsarAdminException {
            String tenant = Create.getOneArgument(this.params);
            if (this.adminRoles == null) {
                this.adminRoles = Collections.emptyList();
            }
            if (this.allowedClusters == null || this.allowedClusters.isEmpty()) {
                this.allowedClusters = CmdTenants.this.getAdmin().clusters().getClusters();
            }
            TenantInfo tenantInfo = new TenantInfo(new HashSet<String>(this.adminRoles), new HashSet<String>(this.allowedClusters));
            CmdTenants.this.getAdmin().tenants().createTenant(tenant, tenantInfo);
        }
    }

    @Parameters(commandDescription="Gets the configuration of a tenant")
    private class Get
    extends CliCommand {
        @Parameter(description="tenant-name", required=true)
        private java.util.List<String> params;

        private Get() {
        }

        @Override
        void run() throws PulsarAdminException {
            String tenant = Get.getOneArgument(this.params);
            this.print(CmdTenants.this.getAdmin().tenants().getTenantInfo(tenant));
        }
    }

    @Parameters(commandDescription="List the existing tenants")
    private class List
    extends CliCommand {
        private List() {
        }

        @Override
        void run() throws PulsarAdminException {
            this.print(CmdTenants.this.getAdmin().tenants().getTenants());
        }
    }
}

