/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.policies.data.AutoFailoverPolicyData;
import org.apache.pulsar.common.policies.data.AutoFailoverPolicyType;
import org.apache.pulsar.common.policies.data.BrokerNamespaceIsolationDataImpl;
import org.apache.pulsar.common.policies.data.NamespaceIsolationData;
import org.apache.pulsar.common.policies.data.NamespaceIsolationDataImpl;
import org.apache.pulsar.common.policies.data.NamespaceIsolationPolicyUnloadScope;
import picocli.CommandLine;

@CommandLine.Command(description={"Operations about namespace isolation policy"})
public class CmdNamespaceIsolationPolicy
extends CmdBase {
    private List<String> validateList(List<String> list) {
        return list.stream().filter(StringUtils::isNotEmpty).collect(Collectors.toList());
    }

    private NamespaceIsolationData createNamespaceIsolationData(List<String> namespaces, List<String> primary, List<String> secondary, String autoFailoverPolicyTypeName, Map<String, String> autoFailoverPolicyParams, NamespaceIsolationPolicyUnloadScope unload) {
        if ((namespaces = this.validateList(namespaces)).isEmpty()) {
            throw new CmdBase.ParameterException("unable to parse namespaces parameter list: " + namespaces);
        }
        if ((primary = this.validateList(primary)).isEmpty()) {
            throw new CmdBase.ParameterException("unable to parse primary parameter list: " + namespaces);
        }
        secondary = this.validateList(secondary);
        NamespaceIsolationData.Builder nsIsolationDataBuilder = NamespaceIsolationData.builder();
        if (namespaces != null) {
            nsIsolationDataBuilder.namespaces(namespaces);
        }
        if (primary != null) {
            nsIsolationDataBuilder.primary(primary);
        }
        if (secondary != null) {
            nsIsolationDataBuilder.secondary(secondary);
        }
        AutoFailoverPolicyType policyType = AutoFailoverPolicyType.fromString((String)autoFailoverPolicyTypeName);
        nsIsolationDataBuilder.autoFailoverPolicy(AutoFailoverPolicyData.builder().policyType(policyType).parameters(autoFailoverPolicyParams).build());
        if (policyType == AutoFailoverPolicyType.min_available) {
            boolean error = true;
            String[] expectParamKeys = new String[]{"min_limit", "usage_threshold"};
            if (autoFailoverPolicyParams.size() == expectParamKeys.length) {
                for (String paramKey : expectParamKeys) {
                    if (!autoFailoverPolicyParams.containsKey(paramKey)) break;
                }
                error = false;
            }
            if (error) {
                throw new CmdBase.ParameterException("Unknown auto failover policy params specified : " + autoFailoverPolicyParams);
            }
        } else {
            throw new CmdBase.ParameterException("Unknown auto failover policy type specified : " + autoFailoverPolicyTypeName);
        }
        nsIsolationDataBuilder.unloadScope(unload);
        return nsIsolationDataBuilder.build();
    }

    public CmdNamespaceIsolationPolicy(Supplier<PulsarAdmin> admin) {
        super("ns-isolation-policy", admin);
        this.addCommand("set", new SetPolicy());
        this.addCommand("get", new GetPolicy());
        this.addCommand("list", new GetAllPolicies());
        this.addCommand("delete", new DeletePolicy());
        this.addCommand("brokers", new GetAllBrokersWithPolicies());
        this.addCommand("broker", new GetBrokerWithPolicies());
    }

    @CommandLine.Command(description={"Create/Update a namespace isolation policy for a cluster. This operation requires Pulsar super-user privileges"})
    private class SetPolicy
    extends CliCommand {
        @CommandLine.Parameters(description={"cluster-name"}, index="0", arity="1")
        private String clusterName;
        @CommandLine.Parameters(description={"policy-name"}, index="1", arity="1")
        private String policyName;
        @CommandLine.Option(names={"--namespaces"}, description={"comma separated namespaces-regex list"}, required=true, split=",")
        private List<String> namespaces;
        @CommandLine.Option(names={"--primary"}, description={"comma separated  primary-broker-regex list. In Pulsar, when namespaces (more specifically, namespace bundles) are assigned dynamically to brokers, the namespace isolation policy limits the set of brokers that can be used for assignment. Before topics are assigned to brokers, you can set the namespace isolation policy with a primary or a secondary regex to select desired brokers. If no broker matches the specified regex, you cannot create a topic. If there are not enough primary brokers, topics are assigned to secondary brokers. If there are not enough secondary brokers, topics are assigned to other brokers which do not have any isolation policies."}, required=true, split=",")
        private List<String> primary;
        @CommandLine.Option(names={"--secondary"}, description={"comma separated secondary-broker-regex list"}, required=false, split=",")
        private List<String> secondary = new ArrayList<String>();
        @CommandLine.Option(names={"--auto-failover-policy-type"}, description={"auto failover policy type name ['min_available']"}, required=true)
        private String autoFailoverPolicyTypeName;
        @CommandLine.Option(names={"--auto-failover-policy-params"}, description={"comma separated name=value auto failover policy parameters"}, required=true, split=",")
        private Map<String, String> autoFailoverPolicyParams;
        @CommandLine.Option(names={"--unload-scope"}, description={"configure the type of unload to do - ['all_matching', 'none', 'changed'] namespaces. By default, only namespaces whose placement will actually change would be unloaded and placed again. You can choose to not unload any namespace while setting this new policy by choosing `none` or choose to unload all namespaces matching old (if any) and new namespace regex. If you chose 'none', you will need to manually unload the namespaces for them to be placed correctly, or wait till some namespaces get load balanced automatically based on load shedding configurations."})
        private NamespaceIsolationPolicyUnloadScope unloadScope;

        private SetPolicy() {
        }

        @Override
        void run() throws PulsarAdminException {
            NamespaceIsolationData namespaceIsolationData = CmdNamespaceIsolationPolicy.this.createNamespaceIsolationData(this.namespaces, this.primary, this.secondary, this.autoFailoverPolicyTypeName, this.autoFailoverPolicyParams, this.unloadScope);
            CmdNamespaceIsolationPolicy.this.getAdmin().clusters().createNamespaceIsolationPolicy(this.clusterName, this.policyName, namespaceIsolationData);
        }
    }

    @CommandLine.Command(description={"Get namespace isolation policy of a cluster. This operation requires Pulsar super-user privileges"})
    private class GetPolicy
    extends CliCommand {
        @CommandLine.Parameters(description={"cluster-name"}, index="0", arity="1")
        private String clusterName;
        @CommandLine.Parameters(description={"policy-name"}, index="1", arity="1")
        private String policyName;

        private GetPolicy() {
        }

        @Override
        void run() throws PulsarAdminException {
            NamespaceIsolationDataImpl nsIsolationData = (NamespaceIsolationDataImpl)CmdNamespaceIsolationPolicy.this.getAdmin().clusters().getNamespaceIsolationPolicy(this.clusterName, this.policyName);
            this.print(nsIsolationData);
        }
    }

    @CommandLine.Command(description={"List all namespace isolation policies of a cluster. This operation requires Pulsar super-user privileges"})
    private class GetAllPolicies
    extends CliCommand {
        @CommandLine.Parameters(description={"cluster-name"}, arity="1")
        private String clusterName;

        private GetAllPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            Map policyMap = CmdNamespaceIsolationPolicy.this.getAdmin().clusters().getNamespaceIsolationPolicies(this.clusterName);
            this.print(policyMap);
        }
    }

    @CommandLine.Command(description={"Delete namespace isolation policy of a cluster. This operation requires Pulsar super-user privileges"})
    private class DeletePolicy
    extends CliCommand {
        @CommandLine.Parameters(description={"cluster-name"}, index="0", arity="1")
        private String clusterName;
        @CommandLine.Parameters(description={"policy-name"}, index="1", arity="1")
        private String policyName;

        private DeletePolicy() {
        }

        @Override
        void run() throws PulsarAdminException {
            CmdNamespaceIsolationPolicy.this.getAdmin().clusters().deleteNamespaceIsolationPolicy(this.clusterName, this.policyName);
        }
    }

    @CommandLine.Command(description={"List all brokers with namespace-isolation policies attached to it. This operation requires Pulsar super-user privileges"})
    private class GetAllBrokersWithPolicies
    extends CliCommand {
        @CommandLine.Parameters(description={"cluster-name"}, arity="1")
        private String clusterName;

        private GetAllBrokersWithPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            List brokers = CmdNamespaceIsolationPolicy.this.getAdmin().clusters().getBrokersWithNamespaceIsolationPolicy(this.clusterName);
            ArrayList data = new ArrayList();
            brokers.forEach(v -> data.add((BrokerNamespaceIsolationDataImpl)v));
            this.print(data);
        }
    }

    @CommandLine.Command(description={"Get broker with namespace-isolation policies attached to it. This operation requires Pulsar super-user privileges"})
    private class GetBrokerWithPolicies
    extends CliCommand {
        @CommandLine.Parameters(description={"cluster-name"}, arity="1")
        private String clusterName;
        @CommandLine.Option(names={"--broker"}, description={"Broker-name to get namespace-isolation policies attached to it"}, required=true)
        private String broker;

        private GetBrokerWithPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            BrokerNamespaceIsolationDataImpl brokerData = (BrokerNamespaceIsolationDataImpl)CmdNamespaceIsolationPolicy.this.getAdmin().clusters().getBrokerWithNamespaceIsolationPolicy(this.clusterName, this.broker);
            this.print(brokerData);
        }
    }
}

