/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.IOException;
import java.util.Objects;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.BatchMessageAcker;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.TopicMessageIdImpl;
import org.apache.pulsar.common.api.proto.MessageIdData;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.shade.com.google.common.collect.ComparisonChain;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.shade.io.netty.util.concurrent.FastThreadLocal;

public class MessageIdImpl
implements MessageId {
    protected final long ledgerId;
    protected final long entryId;
    protected final int partitionIndex;
    private static final FastThreadLocal<MessageIdData> LOCAL_MESSAGE_ID = new FastThreadLocal<MessageIdData>(){

        @Override
        protected MessageIdData initialValue() throws Exception {
            return new MessageIdData();
        }
    };

    private MessageIdImpl() {
        this(-1L, -1L, -1);
    }

    public MessageIdImpl(long ledgerId, long entryId, int partitionIndex) {
        this.ledgerId = ledgerId;
        this.entryId = entryId;
        this.partitionIndex = partitionIndex;
    }

    public long getLedgerId() {
        return this.ledgerId;
    }

    public long getEntryId() {
        return this.entryId;
    }

    public int getPartitionIndex() {
        return this.partitionIndex;
    }

    public int hashCode() {
        return MessageIdImpl.messageIdHashCode(this.ledgerId, this.entryId, this.partitionIndex, -1);
    }

    public boolean equals(Object o) {
        if (o instanceof MessageIdImpl) {
            MessageIdImpl other = (MessageIdImpl)o;
            int batchIndex = o instanceof BatchMessageIdImpl ? ((BatchMessageIdImpl)o).getBatchIndex() : -1;
            return MessageIdImpl.messageIdEquals(this.ledgerId, this.entryId, this.partitionIndex, -1, other.ledgerId, other.entryId, other.partitionIndex, batchIndex);
        }
        if (o instanceof TopicMessageIdImpl) {
            return this.equals(((TopicMessageIdImpl)o).getInnerMessageId());
        }
        return false;
    }

    public String toString() {
        return "" + this.ledgerId + ':' + this.entryId + ':' + this.partitionIndex;
    }

    public static MessageId fromByteArray(byte[] data) throws IOException {
        Objects.requireNonNull(data);
        MessageIdData idData = LOCAL_MESSAGE_ID.get();
        try {
            idData.parseFrom(Unpooled.wrappedBuffer(data, 0, data.length), data.length);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        MessageIdImpl messageId = idData.hasBatchIndex() ? (idData.hasBatchSize() ? new BatchMessageIdImpl(idData.getLedgerId(), idData.getEntryId(), idData.getPartition(), idData.getBatchIndex(), idData.getBatchSize(), BatchMessageAcker.newAcker(idData.getBatchSize())) : new BatchMessageIdImpl(idData.getLedgerId(), idData.getEntryId(), idData.getPartition(), idData.getBatchIndex())) : new MessageIdImpl(idData.getLedgerId(), idData.getEntryId(), idData.getPartition());
        return messageId;
    }

    public static MessageIdImpl convertToMessageIdImpl(MessageId messageId) {
        if (messageId instanceof BatchMessageIdImpl) {
            return (BatchMessageIdImpl)messageId;
        }
        if (messageId instanceof MessageIdImpl) {
            return (MessageIdImpl)messageId;
        }
        if (messageId instanceof TopicMessageIdImpl) {
            return MessageIdImpl.convertToMessageIdImpl(((TopicMessageIdImpl)messageId).getInnerMessageId());
        }
        return null;
    }

    public static MessageId fromByteArrayWithTopic(byte[] data, String topicName) throws IOException {
        return MessageIdImpl.fromByteArrayWithTopic(data, TopicName.get(topicName));
    }

    public static MessageId fromByteArrayWithTopic(byte[] data, TopicName topicName) throws IOException {
        Objects.requireNonNull(data);
        MessageIdData idData = LOCAL_MESSAGE_ID.get();
        try {
            idData.parseFrom(Unpooled.wrappedBuffer(data, 0, data.length), data.length);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        Object messageId = idData.hasBatchIndex() ? new BatchMessageIdImpl(idData.getLedgerId(), idData.getEntryId(), idData.getPartition(), idData.getBatchIndex(), idData.getBatchSize(), BatchMessageAcker.newAcker(idData.getBatchSize())) : new MessageIdImpl(idData.getLedgerId(), idData.getEntryId(), idData.getPartition());
        if (idData.getPartition() > -1 && topicName != null) {
            messageId = new TopicMessageIdImpl(topicName.getPartition(idData.getPartition()).toString(), topicName.toString(), (MessageId)messageId);
        }
        return messageId;
    }

    protected byte[] toByteArray(int batchIndex, int batchSize) {
        MessageIdData msgId = LOCAL_MESSAGE_ID.get().clear().setLedgerId(this.ledgerId).setEntryId(this.entryId);
        if (this.partitionIndex >= 0) {
            msgId.setPartition(this.partitionIndex);
        }
        if (batchIndex != -1) {
            msgId.setBatchIndex(batchIndex);
        }
        if (batchSize > -1) {
            msgId.setBatchSize(batchSize);
        }
        int size = msgId.getSerializedSize();
        ByteBuf serialized = Unpooled.buffer(size, size);
        msgId.writeTo(serialized);
        return serialized.array();
    }

    public byte[] toByteArray() {
        return this.toByteArray(-1, 0);
    }

    public int compareTo(MessageId o) {
        if (o == null) {
            throw new UnsupportedOperationException("MessageId is null");
        }
        if (o instanceof MessageIdImpl) {
            MessageIdImpl other = (MessageIdImpl)o;
            int batchIndex = o instanceof BatchMessageIdImpl ? ((BatchMessageIdImpl)o).getBatchIndex() : -1;
            return MessageIdImpl.messageIdCompare(this.ledgerId, this.entryId, this.partitionIndex, -1, other.ledgerId, other.entryId, other.partitionIndex, batchIndex);
        }
        if (o instanceof TopicMessageIdImpl) {
            return this.compareTo(((TopicMessageIdImpl)o).getInnerMessageId());
        }
        throw new UnsupportedOperationException("Unknown MessageId type: " + o.getClass().getName());
    }

    static int messageIdHashCode(long ledgerId, long entryId, int partitionIndex, int batchIndex) {
        return (int)(31L * (ledgerId + 31L * entryId) + 31L * (long)partitionIndex + (long)batchIndex);
    }

    static boolean messageIdEquals(long ledgerId1, long entryId1, int partitionIndex1, int batchIndex1, long ledgerId2, long entryId2, int partitionIndex2, int batchIndex2) {
        return ledgerId1 == ledgerId2 && entryId1 == entryId2 && partitionIndex1 == partitionIndex2 && batchIndex1 == batchIndex2;
    }

    static int messageIdCompare(long ledgerId1, long entryId1, int partitionIndex1, int batchIndex1, long ledgerId2, long entryId2, int partitionIndex2, int batchIndex2) {
        return ComparisonChain.start().compare(ledgerId1, ledgerId2).compare(entryId1, entryId2).compare(partitionIndex1, partitionIndex2).compare(batchIndex1, batchIndex2).result();
    }
}

