/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance.stats;

import com.google.common.collect.EvictingQueue;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.pulsar.functions.instance.stats.FunctionCollectorRegistry;
import org.apache.pulsar.functions.instance.stats.FunctionStatsManager;
import org.apache.pulsar.functions.instance.stats.PrometheusTextFormat;
import org.apache.pulsar.functions.instance.stats.SinkStatsManager;
import org.apache.pulsar.functions.instance.stats.SourceStatsManager;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.proto.InstanceCommunication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComponentStatsManager
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComponentStatsManager.class);
    protected String[] metricsLabels;
    protected ScheduledFuture<?> scheduledFuture;
    protected final FunctionCollectorRegistry collectorRegistry;
    protected final EvictingQueue emptyQueue = EvictingQueue.create((int)0);
    public static final String USER_METRIC_PREFIX = "user_metric_";
    public static final String[] METRICS_LABEL_NAMES = new String[]{"tenant", "namespace", "name", "instance_id", "cluster", "fqfn"};
    protected static final String[] EXCEPTION_METRICS_LABEL_NAMES = Arrays.copyOf(METRICS_LABEL_NAMES, METRICS_LABEL_NAMES.length + 1);

    public static ComponentStatsManager getStatsManager(FunctionCollectorRegistry collectorRegistry, String[] metricsLabels, ScheduledExecutorService scheduledExecutorService, Function.FunctionDetails.ComponentType componentType) {
        switch (componentType) {
            case FUNCTION: {
                return new FunctionStatsManager(collectorRegistry, metricsLabels, scheduledExecutorService);
            }
            case SOURCE: {
                return new SourceStatsManager(collectorRegistry, metricsLabels, scheduledExecutorService);
            }
            case SINK: {
                return new SinkStatsManager(collectorRegistry, metricsLabels, scheduledExecutorService);
            }
        }
        throw new RuntimeException("Unknown component type: " + componentType);
    }

    public ComponentStatsManager(FunctionCollectorRegistry collectorRegistry, String[] metricsLabels, ScheduledExecutorService scheduledExecutorService) {
        this.collectorRegistry = collectorRegistry;
        this.metricsLabels = metricsLabels;
        this.scheduledFuture = scheduledExecutorService.scheduleAtFixedRate(() -> {
            try {
                this.reset();
            }
            catch (Exception e) {
                log.error("Failed to reset metrics for 1min window", (Throwable)e);
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    public abstract void reset();

    public abstract void incrTotalReceived();

    public abstract void incrTotalProcessedSuccessfully();

    public abstract void incrSysExceptions(Throwable var1);

    public abstract void incrUserExceptions(Throwable var1);

    public abstract void incrSourceExceptions(Throwable var1);

    public abstract void incrSinkExceptions(Throwable var1);

    public abstract void setLastInvocation(long var1);

    public abstract void processTimeStart();

    public abstract void processTimeEnd();

    public abstract double getTotalProcessedSuccessfully();

    public abstract double getTotalRecordsReceived();

    public abstract double getTotalSysExceptions();

    public abstract double getTotalUserExceptions();

    public abstract double getLastInvocation();

    public abstract double getAvgProcessLatency();

    public abstract double getTotalProcessedSuccessfully1min();

    public abstract double getTotalRecordsReceived1min();

    public abstract double getTotalSysExceptions1min();

    public abstract double getTotalUserExceptions1min();

    public abstract double getAvgProcessLatency1min();

    public abstract EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> getLatestUserExceptions();

    public abstract EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> getLatestSystemExceptions();

    public abstract EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> getLatestSourceExceptions();

    public abstract EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> getLatestSinkExceptions();

    public String getStatsAsString() throws IOException {
        StringWriter outputWriter = new StringWriter();
        PrometheusTextFormat.write004(outputWriter, this.collectorRegistry.metricFamilySamples());
        return outputWriter.toString();
    }

    protected InstanceCommunication.FunctionStatus.ExceptionInformation getExceptionInfo(Throwable th, long ts) {
        InstanceCommunication.FunctionStatus.ExceptionInformation.Builder exceptionInfoBuilder = InstanceCommunication.FunctionStatus.ExceptionInformation.newBuilder().setMsSinceEpoch(ts);
        String msg = String.format("[%s]: %s", th.getClass().getName(), th.getMessage());
        if (msg != null) {
            exceptionInfoBuilder.setExceptionString(msg);
        }
        return exceptionInfoBuilder.build();
    }

    @Override
    public void close() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
            this.scheduledFuture = null;
        }
    }

    static {
        ComponentStatsManager.EXCEPTION_METRICS_LABEL_NAMES[ComponentStatsManager.METRICS_LABEL_NAMES.length] = "error";
    }
}

