/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authorization;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authorization.AuthorizationProvider;
import org.apache.pulsar.broker.resources.PulsarResources;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.NamespaceOperation;
import org.apache.pulsar.common.policies.data.PolicyName;
import org.apache.pulsar.common.policies.data.PolicyOperation;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantOperation;
import org.apache.pulsar.common.policies.data.TopicOperation;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.RestException;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.core.Response;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationService {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationService.class);
    private final AuthorizationProvider provider;
    private final ServiceConfiguration conf;

    public AuthorizationService(ServiceConfiguration conf, PulsarResources pulsarResources) throws PulsarServerException {
        this.conf = conf;
        try {
            String providerClassname = conf.getAuthorizationProvider();
            if (!StringUtils.isNotBlank(providerClassname)) {
                throw new PulsarServerException("No authorization providers are present.");
            }
            this.provider = (AuthorizationProvider)Class.forName(providerClassname).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.provider.initialize(conf, pulsarResources);
            log.info("{} has been loaded.", (Object)providerClassname);
        }
        catch (PulsarServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new PulsarServerException("Failed to load an authorization provider.", e);
        }
    }

    public CompletableFuture<Boolean> isSuperUser(String user, AuthenticationDataSource authenticationData) {
        return this.provider.isSuperUser(user, authenticationData, this.conf);
    }

    public CompletableFuture<Boolean> isTenantAdmin(String tenant, String role, TenantInfo tenantInfo, AuthenticationDataSource authenticationData) {
        return this.provider.isTenantAdmin(tenant, role, tenantInfo, authenticationData);
    }

    public CompletableFuture<Void> grantPermissionAsync(NamespaceName namespace, Set<AuthAction> actions, String role, String authDataJson) {
        return this.provider.grantPermissionAsync(namespace, actions, role, authDataJson);
    }

    public CompletableFuture<Void> grantSubscriptionPermissionAsync(NamespaceName namespace, String subscriptionName, Set<String> roles, String authDataJson) {
        return this.provider.grantSubscriptionPermissionAsync(namespace, subscriptionName, roles, authDataJson);
    }

    public CompletableFuture<Void> revokeSubscriptionPermissionAsync(NamespaceName namespace, String subscriptionName, String role, String authDataJson) {
        return this.provider.revokeSubscriptionPermissionAsync(namespace, subscriptionName, role, authDataJson);
    }

    public CompletableFuture<Void> grantPermissionAsync(TopicName topicname, Set<AuthAction> actions, String role, String authDataJson) {
        return this.provider.grantPermissionAsync(topicname, actions, role, authDataJson);
    }

    public CompletableFuture<Boolean> canProduceAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
        if (!this.conf.isAuthorizationEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        return this.provider.isSuperUser(role, authenticationData, this.conf).thenComposeAsync(isSuperUser -> {
            if (isSuperUser.booleanValue()) {
                return CompletableFuture.completedFuture(true);
            }
            return this.provider.canProduceAsync(topicName, role, authenticationData);
        });
    }

    public CompletableFuture<Boolean> canConsumeAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData, String subscription) {
        if (!this.conf.isAuthorizationEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        return this.provider.isSuperUser(role, authenticationData, this.conf).thenComposeAsync(isSuperUser -> {
            if (isSuperUser.booleanValue()) {
                return CompletableFuture.completedFuture(true);
            }
            return this.provider.canConsumeAsync(topicName, role, authenticationData, subscription);
        });
    }

    public boolean canProduce(TopicName topicName, String role, AuthenticationDataSource authenticationData) throws Exception {
        try {
            return this.canProduceAsync(topicName, role, authenticationData).get(this.conf.getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("Time-out {} sec while checking authorization on {} ", (Object)this.conf.getMetadataStoreOperationTimeoutSeconds(), (Object)topicName);
            throw e;
        }
        catch (Exception e) {
            log.warn("Producer-client  with Role - {} failed to get permissions for topic - {}. {}", new Object[]{role, topicName, e.getMessage()});
            throw e;
        }
    }

    public boolean canConsume(TopicName topicName, String role, AuthenticationDataSource authenticationData, String subscription) throws Exception {
        try {
            return this.canConsumeAsync(topicName, role, authenticationData, subscription).get(this.conf.getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("Time-out {} sec while checking authorization on {} ", (Object)this.conf.getMetadataStoreOperationTimeoutSeconds(), (Object)topicName);
            throw e;
        }
        catch (Exception e) {
            log.warn("Consumer-client  with Role - {} failed to get permissions for topic - {}. {}", new Object[]{role, topicName, e.getMessage()});
            throw e;
        }
    }

    public boolean canLookup(TopicName topicName, String role, AuthenticationDataSource authenticationData) throws Exception {
        try {
            return this.canLookupAsync(topicName, role, authenticationData).get(this.conf.getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("Time-out {} sec while checking authorization on {} ", (Object)this.conf.getMetadataStoreOperationTimeoutSeconds(), (Object)topicName);
            throw e;
        }
        catch (Exception e) {
            log.warn("Role - {} failed to get lookup permissions for topic - {}. {}", new Object[]{role, topicName, e.getMessage()});
            throw e;
        }
    }

    public CompletableFuture<Boolean> canLookupAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
        if (!this.conf.isAuthorizationEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        return this.provider.isSuperUser(role, authenticationData, this.conf).thenComposeAsync(isSuperUser -> {
            if (isSuperUser.booleanValue()) {
                return CompletableFuture.completedFuture(true);
            }
            return this.provider.canLookupAsync(topicName, role, authenticationData);
        });
    }

    public CompletableFuture<Boolean> allowFunctionOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        return this.provider.allowFunctionOpsAsync(namespaceName, role, authenticationData);
    }

    public CompletableFuture<Boolean> allowSourceOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        return this.provider.allowSourceOpsAsync(namespaceName, role, authenticationData);
    }

    public CompletableFuture<Boolean> allowSinkOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        return this.provider.allowSinkOpsAsync(namespaceName, role, authenticationData);
    }

    private static void validateOriginalPrincipal(Set<String> proxyRoles, String authenticatedPrincipal, String originalPrincipal) {
        if (proxyRoles.contains(authenticatedPrincipal)) {
            if (StringUtils.isBlank(originalPrincipal)) {
                log.warn("Original principal empty in request authenticated as {}", (Object)authenticatedPrincipal);
                throw new RestException(Response.Status.UNAUTHORIZED, "Original principal cannot be empty if the request is via proxy.");
            }
            if (proxyRoles.contains(originalPrincipal)) {
                log.warn("Original principal {} cannot be a proxy role ({})", (Object)originalPrincipal, proxyRoles);
                throw new RestException(Response.Status.UNAUTHORIZED, "Original principal cannot be a proxy role");
            }
        }
    }

    private boolean isProxyRole(String role) {
        return role != null && this.conf.getProxyRoles().contains(role);
    }

    public CompletableFuture<Boolean> allowTenantOperationAsync(String tenantName, TenantOperation operation, String role, AuthenticationDataSource authData) {
        if (!this.conf.isAuthorizationEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        return this.provider.allowTenantOperationAsync(tenantName, role, operation, authData);
    }

    public CompletableFuture<Boolean> allowTenantOperationAsync(String tenantName, TenantOperation operation, String originalRole, String role, AuthenticationDataSource authData) {
        AuthorizationService.validateOriginalPrincipal(this.conf.getProxyRoles(), role, originalRole);
        if (this.isProxyRole(role)) {
            CompletableFuture<Boolean> isRoleAuthorizedFuture = this.allowTenantOperationAsync(tenantName, operation, role, authData);
            CompletableFuture<Boolean> isOriginalAuthorizedFuture = this.allowTenantOperationAsync(tenantName, operation, originalRole, authData);
            return isRoleAuthorizedFuture.thenCombine(isOriginalAuthorizedFuture, (isRoleAuthorized, isOriginalAuthorized) -> isRoleAuthorized != false && isOriginalAuthorized != false);
        }
        return this.allowTenantOperationAsync(tenantName, operation, role, authData);
    }

    public boolean allowTenantOperation(String tenantName, TenantOperation operation, String originalRole, String role, AuthenticationDataSource authData) throws Exception {
        try {
            return this.allowTenantOperationAsync(tenantName, operation, originalRole, role, authData).get(this.conf.getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RestException(e);
        }
        catch (ExecutionException e) {
            throw new RestException(e.getCause());
        }
    }

    public CompletableFuture<Boolean> allowNamespaceOperationAsync(NamespaceName namespaceName, NamespaceOperation operation, String role, AuthenticationDataSource authData) {
        if (!this.conf.isAuthorizationEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        return this.provider.allowNamespaceOperationAsync(namespaceName, role, operation, authData);
    }

    public CompletableFuture<Boolean> allowNamespaceOperationAsync(NamespaceName namespaceName, NamespaceOperation operation, String originalRole, String role, AuthenticationDataSource authData) {
        AuthorizationService.validateOriginalPrincipal(this.conf.getProxyRoles(), role, originalRole);
        if (this.isProxyRole(role)) {
            CompletableFuture<Boolean> isRoleAuthorizedFuture = this.allowNamespaceOperationAsync(namespaceName, operation, role, authData);
            CompletableFuture<Boolean> isOriginalAuthorizedFuture = this.allowNamespaceOperationAsync(namespaceName, operation, originalRole, authData);
            return isRoleAuthorizedFuture.thenCombine(isOriginalAuthorizedFuture, (isRoleAuthorized, isOriginalAuthorized) -> isRoleAuthorized != false && isOriginalAuthorized != false);
        }
        return this.allowNamespaceOperationAsync(namespaceName, operation, role, authData);
    }

    public CompletableFuture<Boolean> allowNamespacePolicyOperationAsync(NamespaceName namespaceName, PolicyName policy, PolicyOperation operation, String role, AuthenticationDataSource authData) {
        if (!this.conf.isAuthorizationEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        return this.provider.allowNamespacePolicyOperationAsync(namespaceName, policy, operation, role, authData);
    }

    public CompletableFuture<Boolean> allowNamespacePolicyOperationAsync(NamespaceName namespaceName, PolicyName policy, PolicyOperation operation, String originalRole, String role, AuthenticationDataSource authData) {
        AuthorizationService.validateOriginalPrincipal(this.conf.getProxyRoles(), role, originalRole);
        if (this.isProxyRole(role)) {
            CompletableFuture<Boolean> isRoleAuthorizedFuture = this.allowNamespacePolicyOperationAsync(namespaceName, policy, operation, role, authData);
            CompletableFuture<Boolean> isOriginalAuthorizedFuture = this.allowNamespacePolicyOperationAsync(namespaceName, policy, operation, originalRole, authData);
            return isRoleAuthorizedFuture.thenCombine(isOriginalAuthorizedFuture, (isRoleAuthorized, isOriginalAuthorized) -> isRoleAuthorized != false && isOriginalAuthorized != false);
        }
        return this.allowNamespacePolicyOperationAsync(namespaceName, policy, operation, role, authData);
    }

    public boolean allowNamespacePolicyOperation(NamespaceName namespaceName, PolicyName policy, PolicyOperation operation, String originalRole, String role, AuthenticationDataSource authData) throws Exception {
        try {
            return this.allowNamespacePolicyOperationAsync(namespaceName, policy, operation, originalRole, role, authData).get(this.conf.getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RestException(e);
        }
        catch (ExecutionException e) {
            throw new RestException(e.getCause());
        }
    }

    public CompletableFuture<Boolean> allowTopicPolicyOperationAsync(TopicName topicName, PolicyName policy, PolicyOperation operation, String role, AuthenticationDataSource authData) {
        if (!this.conf.isAuthorizationEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        return this.provider.allowTopicPolicyOperationAsync(topicName, role, policy, operation, authData);
    }

    public CompletableFuture<Boolean> allowTopicPolicyOperationAsync(TopicName topicName, PolicyName policy, PolicyOperation operation, String originalRole, String role, AuthenticationDataSource authData) {
        try {
            AuthorizationService.validateOriginalPrincipal(this.conf.getProxyRoles(), role, originalRole);
        }
        catch (RestException e) {
            return FutureUtil.failedFuture(e);
        }
        if (this.isProxyRole(role)) {
            CompletableFuture<Boolean> isRoleAuthorizedFuture = this.allowTopicPolicyOperationAsync(topicName, policy, operation, role, authData);
            CompletableFuture<Boolean> isOriginalAuthorizedFuture = this.allowTopicPolicyOperationAsync(topicName, policy, operation, originalRole, authData);
            return isRoleAuthorizedFuture.thenCombine(isOriginalAuthorizedFuture, (isRoleAuthorized, isOriginalAuthorized) -> isRoleAuthorized != false && isOriginalAuthorized != false);
        }
        return this.allowTopicPolicyOperationAsync(topicName, policy, operation, role, authData);
    }

    public Boolean allowTopicPolicyOperation(TopicName topicName, PolicyName policy, PolicyOperation operation, String originalRole, String role, AuthenticationDataSource authData) throws Exception {
        try {
            return this.allowTopicPolicyOperationAsync(topicName, policy, operation, originalRole, role, authData).get(this.conf.getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RestException(e);
        }
        catch (ExecutionException e) {
            throw new RestException(e.getCause());
        }
    }

    public CompletableFuture<Boolean> allowTopicOperationAsync(TopicName topicName, TopicOperation operation, String role, AuthenticationDataSource authData) {
        if (log.isDebugEnabled()) {
            log.debug("Check if role {} is allowed to execute topic operation {} on topic {}", new Object[]{role, operation, topicName});
        }
        if (!this.conf.isAuthorizationEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        CompletableFuture<Boolean> allowFuture = this.provider.allowTopicOperationAsync(topicName, role, operation, authData);
        if (log.isDebugEnabled()) {
            return allowFuture.whenComplete((allowed, exception) -> {
                if (exception == null) {
                    if (allowed.booleanValue()) {
                        log.debug("Topic operation {} on topic {} is allowed: role = {}", new Object[]{operation, topicName, role});
                    } else {
                        log.debug("Topic operation {} on topic {} is NOT allowed: role = {}", new Object[]{operation, topicName, role});
                    }
                } else {
                    log.debug("Failed to check if topic operation {} on topic {} is allowed: role = {}", new Object[]{operation, topicName, role, exception});
                }
            });
        }
        return allowFuture;
    }

    public CompletableFuture<Boolean> allowTopicOperationAsync(TopicName topicName, TopicOperation operation, String originalRole, String role, AuthenticationDataSource authData) {
        AuthorizationService.validateOriginalPrincipal(this.conf.getProxyRoles(), role, originalRole);
        if (this.isProxyRole(role)) {
            CompletableFuture<Boolean> isRoleAuthorizedFuture = this.allowTopicOperationAsync(topicName, operation, role, authData);
            CompletableFuture<Boolean> isOriginalAuthorizedFuture = this.allowTopicOperationAsync(topicName, operation, originalRole, authData);
            return isRoleAuthorizedFuture.thenCombine(isOriginalAuthorizedFuture, (isRoleAuthorized, isOriginalAuthorized) -> isRoleAuthorized != false && isOriginalAuthorized != false);
        }
        return this.allowTopicOperationAsync(topicName, operation, role, authData);
    }

    public Boolean allowTopicOperation(TopicName topicName, TopicOperation operation, String originalRole, String role, AuthenticationDataSource authData) throws Exception {
        try {
            return this.allowTopicOperationAsync(topicName, operation, originalRole, role, authData).get(this.conf.getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RestException(e);
        }
        catch (ExecutionException e) {
            throw new RestException(e.getCause());
        }
    }
}

