/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web.plugin.servlet;

import java.io.IOException;
import java.util.Map;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServletDefinitions;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServletMetadata;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServletUtils;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServletWithClassLoader;
import org.apache.pulsar.common.configuration.PulsarConfiguration;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdditionalServlets
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(AdditionalServlets.class);
    private static final String ADDITIONAL_SERVLET_DIRECTORY = "additionalServletDirectory";
    private static final String ADDITIONAL_SERVLETS = "additionalServlets";
    private static final String NAR_EXTRACTION_DIRECTORY = "narExtractionDirectory";
    @Deprecated
    private static final String PROXY_ADDITIONAL_SERVLET_DIRECTORY = "proxyAdditionalServletDirectory";
    @Deprecated
    private static final String PROXY_ADDITIONAL_SERVLETS = "proxyAdditionalServlets";
    private final Map<String, AdditionalServletWithClassLoader> servlets;

    public AdditionalServlets(Map<String, AdditionalServletWithClassLoader> servlets) {
        this.servlets = servlets;
    }

    public static AdditionalServlets load(PulsarConfiguration conf) throws IOException {
        String[] additionalServletsList;
        String narExtractionDirectory;
        String additionalServlets;
        String additionalServletDirectory = conf.getProperties().getProperty(ADDITIONAL_SERVLET_DIRECTORY);
        if (additionalServletDirectory == null) {
            additionalServletDirectory = conf.getProperties().getProperty(PROXY_ADDITIONAL_SERVLET_DIRECTORY);
        }
        if ((additionalServlets = conf.getProperties().getProperty(ADDITIONAL_SERVLETS)) == null) {
            additionalServlets = conf.getProperties().getProperty(PROXY_ADDITIONAL_SERVLETS);
        }
        if ((narExtractionDirectory = conf.getProperties().getProperty(NAR_EXTRACTION_DIRECTORY)) == null) {
            narExtractionDirectory = NarClassLoader.DEFAULT_NAR_EXTRACTION_DIR;
        }
        if (additionalServletDirectory == null || additionalServlets == null) {
            return null;
        }
        AdditionalServletDefinitions definitions = AdditionalServletUtils.searchForServlets(additionalServletDirectory, narExtractionDirectory);
        ImmutableMap.Builder<String, AdditionalServletWithClassLoader> builder = ImmutableMap.builder();
        for (String servletName : additionalServletsList = additionalServlets.split(",")) {
            AdditionalServletMetadata definition = definitions.servlets().get(servletName);
            if (null == definition) {
                throw new RuntimeException("No additional servlet is found for name `" + servletName + "`. Available additional servlet are : " + definitions.servlets());
            }
            try {
                AdditionalServletWithClassLoader servletWithClassLoader = AdditionalServletUtils.load(definition, narExtractionDirectory);
                if (servletWithClassLoader != null) {
                    builder.put(servletName, servletWithClassLoader);
                }
                log.info("Successfully loaded additional servlet for name `{}`", (Object)servletName);
            }
            catch (IOException e) {
                log.error("Failed to load the additional servlet for name `" + servletName + "`", (Throwable)e);
                throw new RuntimeException("Failed to load the additional servlet for name `" + servletName + "`");
            }
        }
        ImmutableMap<String, AdditionalServletWithClassLoader> servlets = builder.build();
        if (servlets != null && !servlets.isEmpty()) {
            return new AdditionalServlets(servlets);
        }
        return null;
    }

    @Override
    public void close() {
        this.servlets.values().forEach(AdditionalServletWithClassLoader::close);
    }

    public Map<String, AdditionalServletWithClassLoader> getServlets() {
        return this.servlets;
    }
}

