/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import org.apache.pulsar.client.api.RedeliveryBackoff;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;

public class MultiplierRedeliveryBackoff
implements RedeliveryBackoff {
    private final long minDelayMs;
    private final long maxDelayMs;
    private final double multiplier;
    private final int maxMultiplierPow;

    private MultiplierRedeliveryBackoff(long minDelayMs, long maxDelayMs, double multiplier) {
        this.minDelayMs = minDelayMs;
        this.maxDelayMs = maxDelayMs;
        this.multiplier = multiplier;
        this.maxMultiplierPow = (int)(Math.log((double)maxDelayMs / (double)minDelayMs) / Math.log(multiplier)) + 1;
    }

    public static MultiplierRedeliveryBackoffBuilder builder() {
        return new MultiplierRedeliveryBackoffBuilder();
    }

    public long getMinDelayMs() {
        return this.minDelayMs;
    }

    public long getMaxDelayMs() {
        return this.maxDelayMs;
    }

    @Override
    public long next(int redeliveryCount) {
        if (redeliveryCount <= 0 || this.minDelayMs <= 0L) {
            return this.minDelayMs;
        }
        if (redeliveryCount > this.maxMultiplierPow) {
            return this.maxDelayMs;
        }
        return Math.min((long)((double)this.minDelayMs * Math.pow(this.multiplier, redeliveryCount)), this.maxDelayMs);
    }

    public static class MultiplierRedeliveryBackoffBuilder {
        private long minDelayMs = 10000L;
        private long maxDelayMs = 600000L;
        private double multiplier = 2.0;

        public MultiplierRedeliveryBackoffBuilder minDelayMs(long minDelayMs) {
            this.minDelayMs = minDelayMs;
            return this;
        }

        public MultiplierRedeliveryBackoffBuilder maxDelayMs(long maxDelayMs) {
            this.maxDelayMs = maxDelayMs;
            return this;
        }

        public MultiplierRedeliveryBackoffBuilder multiplier(double multiplier) {
            this.multiplier = multiplier;
            return this;
        }

        public MultiplierRedeliveryBackoff build() {
            Preconditions.checkArgument(this.minDelayMs >= 0L, "min delay time must be >= 0");
            Preconditions.checkArgument(this.maxDelayMs >= this.minDelayMs, "maxDelayMs must be >= minDelayMs");
            Preconditions.checkArgument(this.multiplier > 1.0, "multiplier must be > 1");
            return new MultiplierRedeliveryBackoff(this.minDelayMs, this.maxDelayMs, this.multiplier);
        }
    }
}

