/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.com.google.api.client.http;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.functions.runtime.shaded.com.google.api.client.http.AbstractHttpContent;
import org.apache.pulsar.functions.runtime.shaded.com.google.api.client.http.HttpContent;
import org.apache.pulsar.functions.runtime.shaded.com.google.api.client.http.HttpMediaType;
import org.apache.pulsar.functions.runtime.shaded.com.google.api.client.http.HttpRequest;
import org.apache.pulsar.functions.runtime.shaded.com.google.api.client.http.UrlEncodedParser;
import org.apache.pulsar.functions.runtime.shaded.com.google.api.client.util.Data;
import org.apache.pulsar.functions.runtime.shaded.com.google.api.client.util.FieldInfo;
import org.apache.pulsar.functions.runtime.shaded.com.google.api.client.util.Preconditions;
import org.apache.pulsar.functions.runtime.shaded.com.google.api.client.util.Types;
import org.apache.pulsar.functions.runtime.shaded.com.google.api.client.util.escape.CharEscapers;

public class UrlEncodedContent
extends AbstractHttpContent {
    private Object data;
    private boolean uriPathEncodingFlag;

    public UrlEncodedContent(Object data) {
        super(UrlEncodedParser.MEDIA_TYPE);
        this.setData(data);
        this.uriPathEncodingFlag = false;
    }

    public UrlEncodedContent(Object data, boolean useUriPathEncoding) {
        super(UrlEncodedParser.MEDIA_TYPE);
        this.setData(data);
        this.uriPathEncodingFlag = useUriPathEncoding;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, this.getCharset()));
        boolean first = true;
        for (Map.Entry<String, Object> nameValueEntry : Data.mapOf(this.data).entrySet()) {
            Object value = nameValueEntry.getValue();
            if (value == null) continue;
            String name = CharEscapers.escapeUri(nameValueEntry.getKey());
            Class<?> valueClass = value.getClass();
            if (value instanceof Iterable || valueClass.isArray()) {
                for (Object repeatedValue : Types.iterableOf(value)) {
                    first = UrlEncodedContent.appendParam(first, writer, name, repeatedValue, this.uriPathEncodingFlag);
                }
                continue;
            }
            first = UrlEncodedContent.appendParam(first, writer, name, value, this.uriPathEncodingFlag);
        }
        ((Writer)writer).flush();
    }

    @Override
    public UrlEncodedContent setMediaType(HttpMediaType mediaType) {
        super.setMediaType(mediaType);
        return this;
    }

    public final Object getData() {
        return this.data;
    }

    public UrlEncodedContent setData(Object data) {
        this.data = Preconditions.checkNotNull(data);
        return this;
    }

    public static UrlEncodedContent getContent(HttpRequest request) {
        HttpContent content = request.getContent();
        if (content != null) {
            return (UrlEncodedContent)content;
        }
        UrlEncodedContent result = new UrlEncodedContent(new HashMap());
        request.setContent(result);
        return result;
    }

    private static boolean appendParam(boolean first, Writer writer, String name, Object value, boolean uriPathEncodingFlag) throws IOException {
        if (value == null || Data.isNull(value)) {
            return first;
        }
        if (first) {
            first = false;
        } else {
            writer.write("&");
        }
        writer.write(name);
        String stringValue = value instanceof Enum ? FieldInfo.of((Enum)value).getName() : value.toString();
        stringValue = uriPathEncodingFlag ? CharEscapers.escapeUriPath(stringValue) : CharEscapers.escapeUri(stringValue);
        if (stringValue.length() != 0) {
            writer.write("=");
            writer.write(stringValue);
        }
        return first;
    }
}

