/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.BKException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.LedgerHandle;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookieClient;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util.SafeRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ForceLedgerOp
extends SafeRunnable
implements BookkeeperInternalCallbacks.ForceLedgerCallback {
    private static final Logger LOG = LoggerFactory.getLogger(ForceLedgerOp.class);
    final CompletableFuture<Void> cb;
    DistributionSchedule.AckSet ackSet;
    boolean completed = false;
    boolean errored = false;
    int lastSeenError = -12;
    final List<BookieId> currentEnsemble;
    long currentNonDurableLastAddConfirmed = -1L;
    final LedgerHandle lh;
    final BookieClient bookieClient;

    ForceLedgerOp(LedgerHandle lh, BookieClient bookieClient, List<BookieId> ensemble, CompletableFuture<Void> cb) {
        this.lh = lh;
        this.bookieClient = bookieClient;
        this.cb = cb;
        this.currentEnsemble = ensemble;
    }

    void sendForceLedgerRequest(int bookieIndex) {
        this.bookieClient.forceLedger(this.currentEnsemble.get(bookieIndex), this.lh.ledgerId, this, bookieIndex);
    }

    @Override
    public void safeRun() {
        this.initiate();
    }

    void initiate() {
        this.currentNonDurableLastAddConfirmed = this.lh.pendingAddsSequenceHead;
        if (LOG.isDebugEnabled()) {
            LOG.debug("force {} clientNonDurableLac {}", (Object)this.lh.ledgerId, (Object)this.currentNonDurableLastAddConfirmed);
        }
        this.ackSet = this.lh.distributionSchedule.getEnsembleAckSet();
        DistributionSchedule.WriteSet writeSet = this.lh.getDistributionSchedule().getEnsembleSet(this.currentNonDurableLastAddConfirmed);
        try {
            for (int i = 0; i < writeSet.size(); ++i) {
                this.sendForceLedgerRequest(writeSet.get(i));
            }
        }
        finally {
            writeSet.recycle();
        }
    }

    @Override
    public void forceLedgerComplete(int rc, long ledgerId, BookieId addr, Object ctx) {
        int bookieIndex = (Integer)ctx;
        Preconditions.checkState(!this.completed, "We are waiting for all the bookies, it is not expected an early exit");
        if (this.errored) {
            return;
        }
        if (0 != rc) {
            this.lastSeenError = rc;
        }
        if (rc == 0) {
            if (this.ackSet.completeBookieAndCheck(bookieIndex)) {
                this.completed = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("After force on ledger {} updating LastAddConfirmed to {} ", (Object)ledgerId, (Object)this.currentNonDurableLastAddConfirmed);
                }
                this.lh.updateLastConfirmed(this.currentNonDurableLastAddConfirmed, this.lh.getLength());
                FutureUtils.complete(this.cb, null);
            }
        } else {
            LOG.info("ForceLedger did not succeed: Ledger {} on {}", (Object)ledgerId, (Object)addr);
            this.errored = true;
            FutureUtils.completeExceptionally(this.cb, BKException.create(this.lastSeenError));
        }
    }
}

