/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.net;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.CharMatcher;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Splitter;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Strings;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ServiceURI {
    public static final String SERVICE_ZK = "zk";
    public static final String SERVICE_DLOG = "distributedlog";
    public static final String SERVICE_BK = "bk";
    public static final int SERVICE_BK_PORT = 4181;
    public static final ServiceURI DEFAULT_LOCAL_STREAM_STORAGE_SERVICE_URI = ServiceURI.create("bk://localhost:4181");
    private static final String SERVICE_SEP = "+";
    private static final String SERVICE_DLOG_SEP = "-";
    private final String serviceName;
    private final String[] serviceInfos;
    private final String serviceUser;
    private final String[] serviceHosts;
    private final String servicePath;
    private final URI uri;

    public static ServiceURI create(String uriStr) {
        Preconditions.checkNotNull(uriStr, "service uri string is null");
        URI uri = URI.create(uriStr);
        return ServiceURI.create(uri);
    }

    public static ServiceURI create(URI uri) {
        List<String> serviceHosts;
        String serviceUser;
        String serviceName;
        Preconditions.checkNotNull(uri, "service uri instance is null");
        String[] serviceInfos = new String[]{};
        String scheme = uri.getScheme();
        if (null != scheme) {
            String serviceSep = (scheme = scheme.toLowerCase()).startsWith(SERVICE_DLOG) ? SERVICE_DLOG_SEP : SERVICE_SEP;
            String[] schemeParts = StringUtils.split(scheme, serviceSep);
            serviceName = schemeParts[0];
            serviceInfos = new String[schemeParts.length - 1];
            System.arraycopy(schemeParts, 1, serviceInfos, 0, serviceInfos.length);
        } else {
            serviceName = null;
        }
        String userAndHostInformation = uri.getAuthority();
        Preconditions.checkArgument(!Strings.isNullOrEmpty(userAndHostInformation), "authority component is missing in service uri : " + uri);
        int atIndex = userAndHostInformation.indexOf(64);
        Splitter splitter = Splitter.on(CharMatcher.anyOf(",;"));
        if (atIndex > 0) {
            serviceUser = userAndHostInformation.substring(0, atIndex);
            serviceHosts = splitter.splitToList(userAndHostInformation.substring(atIndex + 1));
        } else {
            serviceUser = null;
            serviceHosts = splitter.splitToList(userAndHostInformation);
        }
        serviceHosts = serviceHosts.stream().map(host -> ServiceURI.validateHostName(serviceName, host)).collect(Collectors.toList());
        String servicePath = uri.getPath();
        Preconditions.checkArgument(null != servicePath, "service path component is missing in service uri : " + uri);
        return new ServiceURI(serviceName, serviceInfos, serviceUser, serviceHosts.toArray(new String[serviceHosts.size()]), servicePath, uri);
    }

    private static String validateHostName(String serviceName, String hostname) {
        String[] parts = hostname.split(":");
        if (parts.length >= 3) {
            throw new IllegalArgumentException("Invalid hostname : " + hostname);
        }
        if (parts.length == 2) {
            try {
                Integer.parseUnsignedInt(parts[1]);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Invalid hostname : " + hostname);
            }
            return hostname;
        }
        if (parts.length == 1 && serviceName.toLowerCase().equals(SERVICE_BK)) {
            return hostname + ":" + 4181;
        }
        return hostname;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public String[] getServiceInfos() {
        return this.serviceInfos;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public String[] getServiceHosts() {
        return this.serviceHosts;
    }

    private ServiceURI(String serviceName, String[] serviceInfos, String serviceUser, String[] serviceHosts, String servicePath, URI uri) {
        this.serviceName = serviceName;
        this.serviceInfos = serviceInfos;
        this.serviceUser = serviceUser;
        this.serviceHosts = serviceHosts;
        this.servicePath = servicePath;
        this.uri = uri;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceUser() {
        return this.serviceUser;
    }

    public String getServicePath() {
        return this.servicePath;
    }

    public URI getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceURI)) {
            return false;
        }
        ServiceURI other = (ServiceURI)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getServiceInfos(), other.getServiceInfos())) {
            return false;
        }
        String this$serviceUser = this.getServiceUser();
        String other$serviceUser = other.getServiceUser();
        if (this$serviceUser == null ? other$serviceUser != null : !this$serviceUser.equals(other$serviceUser)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getServiceHosts(), other.getServiceHosts())) {
            return false;
        }
        String this$servicePath = this.getServicePath();
        String other$servicePath = other.getServicePath();
        if (this$servicePath == null ? other$servicePath != null : !this$servicePath.equals(other$servicePath)) {
            return false;
        }
        URI this$uri = this.getUri();
        URI other$uri = other.getUri();
        return !(this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceURI;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getServiceInfos());
        String $serviceUser = this.getServiceUser();
        result = result * 59 + ($serviceUser == null ? 43 : $serviceUser.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getServiceHosts());
        String $servicePath = this.getServicePath();
        result = result * 59 + ($servicePath == null ? 43 : $servicePath.hashCode());
        URI $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
        return result;
    }
}

