/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.replication;

import java.util.function.Function;

public abstract class ReplicationException
extends Exception {
    public static final Function<Throwable, ReplicationException> EXCEPTION_HANDLER = cause -> {
        if (cause instanceof ReplicationException) {
            return (ReplicationException)cause;
        }
        return new UnavailableException(cause.getMessage(), (Throwable)cause);
    };

    protected ReplicationException(String message, Throwable cause) {
        super(message, cause);
    }

    protected ReplicationException(String message) {
        super(message);
    }

    public static class BKAuditException
    extends ReplicationException {
        private static final long serialVersionUID = 95551905L;

        BKAuditException(String message, Throwable cause) {
            super(message, cause);
        }

        BKAuditException(String message) {
            super(message);
        }
    }

    public static class CompatibilityException
    extends ReplicationException {
        private static final long serialVersionUID = 98551903L;

        public CompatibilityException(String message, Throwable cause) {
            super(message, cause);
        }

        public CompatibilityException(String message) {
            super(message);
        }
    }

    public static class UnavailableException
    extends ReplicationException {
        private static final long serialVersionUID = 31872209L;

        public UnavailableException(String message, Throwable cause) {
            super(message, cause);
        }

        public UnavailableException(String message) {
            super(message);
        }
    }
}

