/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.cli.commands.autorecovery;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ExecutionException;
import org.apache.pulsar.functions.runtime.shaded.com.beust.jcommander.Parameter;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.replication.ReplicationException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
public class ToggleCommand
extends BookieCommand<AutoRecoveryFlags> {
    static final Logger LOG = LoggerFactory.getLogger(ToggleCommand.class);
    private static final String NAME = "toggle";
    private static final String DESC = "Enable or disable auto recovery in the cluster. Default is disable.";

    public ToggleCommand() {
        this(new AutoRecoveryFlags());
    }

    private ToggleCommand(AutoRecoveryFlags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(flags).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, AutoRecoveryFlags cmdFlags) {
        try {
            return this.handler(conf, cmdFlags);
        }
        catch (ExecutionException | MetadataException e) {
            throw new UncheckedExecutionException(e.getMessage(), e);
        }
    }

    private boolean handler(ServerConfiguration conf, AutoRecoveryFlags flags) throws MetadataException, ExecutionException {
        MetadataDrivers.runFunctionWithLedgerManagerFactory(conf, mFactory -> {
            try (LedgerUnderreplicationManager underreplicationManager = mFactory.newLedgerUnderreplicationManager();){
                if (flags.status) {
                    LOG.info("Autorecovery is " + (underreplicationManager.isLedgerReplicationEnabled() ? "enabled." : "disabled."));
                    Object var4_6 = null;
                    return var4_6;
                }
                if (flags.enable) {
                    if (underreplicationManager.isLedgerReplicationEnabled()) {
                        LOG.warn("Autorecovery already enabled. Doing nothing");
                        return null;
                    }
                    LOG.info("Enabling autorecovery");
                    underreplicationManager.enableLedgerReplication();
                    return null;
                }
                if (!underreplicationManager.isLedgerReplicationEnabled()) {
                    LOG.warn("Autorecovery already disabled. Doing nothing");
                    return null;
                }
                LOG.info("Disabling autorecovery");
                underreplicationManager.disableLedgerReplication();
                return null;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new UncheckedExecutionException(e);
            }
            catch (ReplicationException | KeeperException e) {
                throw new UncheckedExecutionException(e);
            }
        });
        return true;
    }

    public static class AutoRecoveryFlags
    extends CliFlags {
        @Parameter(names={"-e", "--enable"}, description="Enable or disable auto recovery of under replicated ledgers.")
        private boolean enable;
        @Parameter(names={"-s", "--status"}, description="Check the auto recovery status.")
        private boolean status;

        public AutoRecoveryFlags enable(boolean enable) {
            this.enable = enable;
            return this;
        }

        public AutoRecoveryFlags status(boolean status) {
            this.status = status;
            return this;
        }
    }
}

