/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.cli;

import java.util.ArrayList;
import java.util.List;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.cli.CommandLine;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.cli.Option;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.cli.OptionGroup;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.cli.Options;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.cli.ParseException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.cli.PosixParser;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.AsyncCallback;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.CreateMode;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.StatsTrack;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.ZKUtil;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.ZooDefs;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.ZooKeeper;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.cli.CliCommand;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.cli.CliException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.cli.CliParseException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.cli.CliWrapperException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.cli.MalformedCommandException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.cli.MalformedPathException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetQuotaCommand
extends CliCommand {
    private static final Logger LOG = LoggerFactory.getLogger(SetQuotaCommand.class);
    private Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public SetQuotaCommand() {
        super("setquota", "-n|-b val path");
        OptionGroup og1 = new OptionGroup();
        og1.addOption(new Option("b", true, "bytes quota"));
        og1.addOption(new Option("n", true, "num quota"));
        og1.setRequired(true);
        this.options.addOptionGroup(og1);
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        PosixParser parser = new PosixParser();
        try {
            this.cl = parser.parse(this.options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        String path = this.args[1];
        if (path.startsWith("/zookeeper/quota")) {
            this.err.println("cannot set a quota under the path: /zookeeper/quota");
            return false;
        }
        if (this.cl.hasOption("b")) {
            long bytes = Long.parseLong(this.cl.getOptionValue("b"));
            try {
                SetQuotaCommand.createQuota(this.zk, path, bytes, -1);
            }
            catch (IllegalArgumentException | InterruptedException | KeeperException ex) {
                throw new CliWrapperException(ex);
            }
        } else if (this.cl.hasOption("n")) {
            int numNodes = Integer.parseInt(this.cl.getOptionValue("n"));
            try {
                SetQuotaCommand.createQuota(this.zk, path, -1L, numNodes);
            }
            catch (IllegalArgumentException | InterruptedException | KeeperException ex) {
                throw new CliWrapperException(ex);
            }
        } else {
            throw new MalformedCommandException(this.getUsageStr());
        }
        return false;
    }

    public static boolean createQuota(ZooKeeper zk, String path, long bytes, int numNodes) throws KeeperException, InterruptedException, IllegalArgumentException, MalformedPathException {
        Stat initStat;
        try {
            initStat = zk.exists(path, false);
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        if (initStat == null) {
            throw new IllegalArgumentException(path + " does not exist.");
        }
        String quotaPath = "/zookeeper/quota";
        SetQuotaCommand.checkIfChildQuota(zk, path);
        SetQuotaCommand.checkIfParentQuota(zk, path);
        if (zk.exists(quotaPath, false) == null) {
            try {
                zk.create("/zookeeper", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                zk.create("/zookeeper/quota", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
        }
        String[] splits = path.split("/");
        StringBuilder sb = new StringBuilder();
        sb.append(quotaPath);
        for (int i = 1; i < splits.length; ++i) {
            sb.append("/").append(splits[i]);
            quotaPath = sb.toString();
            try {
                zk.create(quotaPath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                continue;
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
        }
        String statPath = quotaPath + "/" + "zookeeper_stats";
        quotaPath = quotaPath + "/" + "zookeeper_limits";
        StatsTrack strack = new StatsTrack(null);
        strack.setBytes(bytes);
        strack.setCount(numNodes);
        try {
            zk.create(quotaPath, strack.toString().getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            StatsTrack stats = new StatsTrack(null);
            stats.setBytes(0L);
            stats.setCount(0);
            zk.create(statPath, stats.toString().getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException ne) {
            byte[] data = zk.getData(quotaPath, false, new Stat());
            StatsTrack strackC = new StatsTrack(new String(data));
            if (bytes != -1L) {
                strackC.setBytes(bytes);
            }
            if (numNodes != -1) {
                strackC.setCount(numNodes);
            }
            zk.setData(quotaPath, strackC.toString().getBytes(), -1);
        }
        return true;
    }

    private static void checkIfChildQuota(final ZooKeeper zk, final String path) throws KeeperException, InterruptedException {
        String realPath = "/zookeeper/quota" + path;
        try {
            ZKUtil.visitSubTreeDFS(zk, realPath, false, new AsyncCallback.StringCallback(){

                @Override
                public void processResult(int rc, String quotaPath, Object ctx, String name) {
                    List<Object> children = new ArrayList();
                    try {
                        children = zk.getChildren(quotaPath, false);
                    }
                    catch (KeeperException.NoNodeException ne) {
                        LOG.debug("child removed during quota check", (Throwable)ne);
                        return;
                    }
                    catch (InterruptedException | KeeperException e) {
                        e.printStackTrace();
                    }
                    if (children.size() == 0) {
                        return;
                    }
                    for (String string : children) {
                        if (quotaPath.equals("/zookeeper/quota" + path) || !"zookeeper_limits".equals(string)) continue;
                        throw new IllegalArgumentException(path + " has a child " + quotaPath.substring("/zookeeper/quota".length()) + " which has a quota");
                    }
                }
            });
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    private static void checkIfParentQuota(ZooKeeper zk, String path) throws InterruptedException, KeeperException {
        String[] splits = path.split("/");
        String quotaPath = "/zookeeper/quota";
        for (String str : splits) {
            if (str.length() == 0) continue;
            quotaPath = quotaPath + "/" + str;
            List<String> children = null;
            try {
                children = zk.getChildren(quotaPath, false);
            }
            catch (KeeperException.NoNodeException ne) {
                LOG.debug("child removed during quota check", (Throwable)ne);
                return;
            }
            if (children.size() == 0) {
                return;
            }
            for (String child : children) {
                if (quotaPath.equals("/zookeeper/quota" + path) || !"zookeeper_limits".equals(child)) continue;
                throw new IllegalArgumentException(path + " has a parent " + quotaPath.substring("/zookeeper/quota".length()) + " which has a quota");
            }
        }
    }
}

