/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resources;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.metadata.api.MetadataStore;

public class TopicResources {
    private static final String MANAGED_LEDGER_PATH = "/managed-ledgers";
    private final MetadataStore store;

    public TopicResources(MetadataStore store) {
        this.store = store;
    }

    public CompletableFuture<List<String>> listPersistentTopicsAsync(NamespaceName ns) {
        String path = "/managed-ledgers/" + ns + "/persistent";
        return this.store.getChildren(path).thenApply(children -> children.stream().map(c -> TopicName.get(TopicDomain.persistent.toString(), ns, Codec.decode(c)).toString()).collect(Collectors.toList()));
    }

    public CompletableFuture<List<String>> getExistingPartitions(TopicName topic) {
        return this.getExistingPartitions(topic.getNamespaceObject(), topic.getDomain());
    }

    public CompletableFuture<List<String>> getExistingPartitions(NamespaceName ns, TopicDomain domain) {
        String topicPartitionPath = "/managed-ledgers/" + ns + "/" + (Object)((Object)domain);
        return this.store.getChildren(topicPartitionPath).thenApply(topics -> topics.stream().map(s -> String.format("%s://%s/%s", domain.value(), ns, Codec.decode(s))).collect(Collectors.toList()));
    }

    public CompletableFuture<Void> deletePersistentTopicAsync(TopicName topic) {
        String path = "/managed-ledgers/" + topic.getPersistenceNamingEncoding();
        return this.store.delete(path, Optional.of(-1L));
    }

    public CompletableFuture<Void> createPersistentTopicAsync(TopicName topic) {
        String path = "/managed-ledgers/" + topic.getPersistenceNamingEncoding();
        return this.store.put(path, new byte[0], Optional.of(-1L)).thenApply(__ -> null);
    }

    public CompletableFuture<Boolean> persistentTopicExists(TopicName topic) {
        String path = "/managed-ledgers/" + topic.getPersistenceNamingEncoding();
        return this.store.exists(path);
    }

    public CompletableFuture<Void> clearNamespacePersistence(NamespaceName ns) {
        String path = "/managed-ledgers/" + ns;
        return this.store.exists(path).thenCompose(exists -> {
            if (exists.booleanValue()) {
                return this.store.delete(path, Optional.empty());
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    public CompletableFuture<Void> clearDomainPersistence(NamespaceName ns) {
        String path = "/managed-ledgers/" + ns + "/persistent";
        return this.store.exists(path).thenCompose(exists -> {
            if (exists.booleanValue()) {
                return this.store.delete(path, Optional.empty());
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    public CompletableFuture<Void> clearTenantPersistence(String tenant) {
        String path = "/managed-ledgers/" + tenant;
        return this.store.exists(path).thenCompose(exists -> {
            if (exists.booleanValue()) {
                return this.store.delete(path, Optional.empty());
            }
            return CompletableFuture.completedFuture(null);
        });
    }
}

