/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.functions.runtime.shaded.org.asynchttpclient.RequestBuilder;

public class ComponentResource
extends BaseResource {
    protected ComponentResource(Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
    }

    public RequestBuilder addAuthHeaders(WebTarget target, RequestBuilder requestBuilder) throws PulsarAdminException {
        try {
            Set<Map.Entry<String, String>> headers;
            if (this.auth != null && (headers = this.getAuthHeaders(target)) != null && !headers.isEmpty()) {
                headers.forEach(header -> requestBuilder.addHeader((CharSequence)header.getKey(), (String)header.getValue()));
            }
            return requestBuilder;
        }
        catch (Throwable t) {
            throw new PulsarAdminException.GettingAuthenticationDataException(t);
        }
    }

    private Set<Map.Entry<String, String>> getAuthHeaders(WebTarget target) throws Exception {
        AuthenticationDataProvider authData = this.auth.getAuthData(target.getUri().getHost());
        String targetUrl = target.getUri().toString();
        if (this.auth.getAuthMethodName().equalsIgnoreCase("sasl")) {
            CompletableFuture<Map<String, String>> authFuture = new CompletableFuture<Map<String, String>>();
            this.auth.authenticationStage(targetUrl, authData, null, authFuture);
            return this.auth.newRequestHeader(targetUrl, authData, authFuture.get());
        }
        if (authData.hasDataForHttp()) {
            return this.auth.newRequestHeader(targetUrl, authData, null);
        }
        return null;
    }
}

