/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.ResourceQuotas;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.admin.internal.WebTargets;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.policies.data.ResourceQuota;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.client.Entity;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.client.WebTarget;

public class ResourceQuotasImpl
extends BaseResource
implements ResourceQuotas {
    private final WebTarget adminQuotas;
    private final WebTarget adminV2Quotas;

    public ResourceQuotasImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminQuotas = web.path("/admin/resource-quotas");
        this.adminV2Quotas = web.path("/admin/v2/resource-quotas");
    }

    @Override
    public ResourceQuota getDefaultResourceQuota() throws PulsarAdminException {
        return (ResourceQuota)this.sync(() -> this.getDefaultResourceQuotaAsync());
    }

    @Override
    public CompletableFuture<ResourceQuota> getDefaultResourceQuotaAsync() {
        final CompletableFuture<ResourceQuota> future = new CompletableFuture<ResourceQuota>();
        this.asyncGetRequest(this.adminV2Quotas, new InvocationCallback<ResourceQuota>(){

            @Override
            public void completed(ResourceQuota resourceQuota) {
                future.complete(resourceQuota);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(ResourceQuotasImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setDefaultResourceQuota(ResourceQuota quota) throws PulsarAdminException {
        this.sync(() -> this.setDefaultResourceQuotaAsync(quota));
    }

    @Override
    public CompletableFuture<Void> setDefaultResourceQuotaAsync(ResourceQuota quota) {
        return this.asyncPostRequest(this.adminV2Quotas, Entity.entity(quota, "application/json"));
    }

    @Override
    public ResourceQuota getNamespaceBundleResourceQuota(String namespace, String bundle) throws PulsarAdminException {
        return (ResourceQuota)this.sync(() -> this.getNamespaceBundleResourceQuotaAsync(namespace, bundle));
    }

    @Override
    public CompletableFuture<ResourceQuota> getNamespaceBundleResourceQuotaAsync(String namespace, String bundle) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, bundle);
        final CompletableFuture<ResourceQuota> future = new CompletableFuture<ResourceQuota>();
        this.asyncGetRequest(path, new InvocationCallback<ResourceQuota>(){

            @Override
            public void completed(ResourceQuota resourceQuota) {
                future.complete(resourceQuota);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(ResourceQuotasImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setNamespaceBundleResourceQuota(String namespace, String bundle, ResourceQuota quota) throws PulsarAdminException {
        this.sync(() -> this.setNamespaceBundleResourceQuotaAsync(namespace, bundle, quota));
    }

    @Override
    public CompletableFuture<Void> setNamespaceBundleResourceQuotaAsync(String namespace, String bundle, ResourceQuota quota) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, bundle);
        return this.asyncPostRequest(path, Entity.entity(quota, "application/json"));
    }

    @Override
    public void resetNamespaceBundleResourceQuota(String namespace, String bundle) throws PulsarAdminException {
        this.sync(() -> this.resetNamespaceBundleResourceQuotaAsync(namespace, bundle));
    }

    @Override
    public CompletableFuture<Void> resetNamespaceBundleResourceQuotaAsync(String namespace, String bundle) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, bundle);
        return this.asyncDeleteRequest(path);
    }

    private WebTarget namespacePath(NamespaceName namespace, String ... parts) {
        WebTarget base = namespace.isV2() ? this.adminV2Quotas : this.adminQuotas;
        WebTarget namespacePath = base.path(namespace.toString());
        namespacePath = WebTargets.addParts(namespacePath, parts);
        return namespacePath;
    }
}

