/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.reader;

import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.client.impl.schema.SchemaUtils;
import org.apache.pulsar.client.impl.schema.reader.AbstractMultiVersionAvroBaseReader;
import org.apache.pulsar.client.impl.schema.reader.AvroReader;
import org.apache.pulsar.client.impl.schema.util.SchemaUtil;
import org.apache.pulsar.common.protocol.schema.BytesSchemaVersion;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.functions.runtime.shaded.org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiVersionAvroReader<T>
extends AbstractMultiVersionAvroBaseReader<T> {
    private final ClassLoader pojoClassLoader;
    protected static final Logger LOG = LoggerFactory.getLogger(MultiVersionAvroReader.class);

    public MultiVersionAvroReader(Schema readerSchema, ClassLoader pojoClassLoader, boolean jsr310ConversionEnabled) {
        super(new AvroReader(readerSchema, pojoClassLoader, jsr310ConversionEnabled), readerSchema);
        this.pojoClassLoader = pojoClassLoader;
    }

    @Override
    protected SchemaReader<T> loadReader(BytesSchemaVersion schemaVersion) {
        SchemaInfo schemaInfo = this.getSchemaInfoByVersion(schemaVersion.get());
        if (schemaInfo != null) {
            LOG.info("Load schema reader for version({}), schema is : {}, schemaInfo: {}", new Object[]{SchemaUtils.getStringSchemaVersion(schemaVersion.get()), schemaInfo.getSchemaDefinition(), schemaInfo.toString()});
            boolean jsr310ConversionEnabled = SchemaUtil.getJsr310ConversionEnabledFromSchemaInfo(schemaInfo);
            return new AvroReader(SchemaUtil.parseAvroSchema(schemaInfo.getSchemaDefinition()), this.readerSchema, this.pojoClassLoader, jsr310ConversionEnabled);
        }
        LOG.warn("No schema found for version({}), use latest schema : {}", (Object)SchemaUtils.getStringSchemaVersion(schemaVersion.get()), (Object)this.readerSchema);
        return this.providerSchemaReader;
    }
}

