/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data.stats;

import java.util.Map;
import org.apache.pulsar.client.api.ProducerAccessMode;
import org.apache.pulsar.common.policies.data.PublisherStats;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.annotation.JsonIgnore;

public class PublisherStatsImpl
implements PublisherStats {
    @JsonIgnore
    private int count;
    public ProducerAccessMode accessMode;
    public double msgRateIn;
    public double msgThroughputIn;
    public double averageMsgSize;
    public double chunkedMessageRate;
    public long producerId;
    public boolean supportsPartialProducer;
    @JsonIgnore
    private int producerNameOffset = -1;
    @JsonIgnore
    private int producerNameLength;
    @JsonIgnore
    private int addressOffset = -1;
    @JsonIgnore
    private int addressLength;
    @JsonIgnore
    private int connectedSinceOffset = -1;
    @JsonIgnore
    private int connectedSinceLength;
    @JsonIgnore
    private int clientVersionOffset = -1;
    @JsonIgnore
    private int clientVersionLength;
    @JsonIgnore
    private StringBuilder stringBuffer = new StringBuilder();
    public Map<String, String> metadata;

    public PublisherStatsImpl add(PublisherStatsImpl stats) {
        double newAverageMsgSize;
        if (stats == null) {
            throw new IllegalArgumentException("stats can't be null");
        }
        ++this.count;
        this.msgRateIn += stats.msgRateIn;
        this.msgThroughputIn += stats.msgThroughputIn;
        this.averageMsgSize = newAverageMsgSize = (this.averageMsgSize * (double)(this.count - 1) + stats.averageMsgSize) / (double)this.count;
        return this;
    }

    @Override
    public String getProducerName() {
        return this.producerNameOffset == -1 ? null : this.stringBuffer.substring(this.producerNameOffset, this.producerNameOffset + this.producerNameLength);
    }

    public void setProducerName(String producerName) {
        if (producerName == null) {
            this.producerNameOffset = -1;
            return;
        }
        this.producerNameOffset = this.stringBuffer.length();
        this.producerNameLength = producerName.length();
        this.stringBuffer.append(producerName);
    }

    @Override
    public String getAddress() {
        return this.addressOffset == -1 ? null : this.stringBuffer.substring(this.addressOffset, this.addressOffset + this.addressLength);
    }

    public void setAddress(String address) {
        if (address == null) {
            this.addressOffset = -1;
            return;
        }
        this.addressOffset = this.stringBuffer.length();
        this.addressLength = address.length();
        this.stringBuffer.append(address);
    }

    @Override
    public String getConnectedSince() {
        return this.connectedSinceOffset == -1 ? null : this.stringBuffer.substring(this.connectedSinceOffset, this.connectedSinceOffset + this.connectedSinceLength);
    }

    public void setConnectedSince(String connectedSince) {
        if (connectedSince == null) {
            this.connectedSinceOffset = -1;
            return;
        }
        this.connectedSinceOffset = this.stringBuffer.length();
        this.connectedSinceLength = connectedSince.length();
        this.stringBuffer.append(connectedSince);
    }

    @Override
    public String getClientVersion() {
        return this.clientVersionOffset == -1 ? null : this.stringBuffer.substring(this.clientVersionOffset, this.clientVersionOffset + this.clientVersionLength);
    }

    public void setClientVersion(String clientVersion) {
        if (clientVersion == null) {
            this.clientVersionOffset = -1;
            return;
        }
        this.clientVersionOffset = this.stringBuffer.length();
        this.clientVersionLength = clientVersion.length();
        this.stringBuffer.append(clientVersion);
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public ProducerAccessMode getAccessMode() {
        return this.accessMode;
    }

    @Override
    public double getMsgRateIn() {
        return this.msgRateIn;
    }

    @Override
    public double getMsgThroughputIn() {
        return this.msgThroughputIn;
    }

    @Override
    public double getAverageMsgSize() {
        return this.averageMsgSize;
    }

    @Override
    public double getChunkedMessageRate() {
        return this.chunkedMessageRate;
    }

    @Override
    public long getProducerId() {
        return this.producerId;
    }

    @Override
    public boolean isSupportsPartialProducer() {
        return this.supportsPartialProducer;
    }

    public int getProducerNameOffset() {
        return this.producerNameOffset;
    }

    public int getProducerNameLength() {
        return this.producerNameLength;
    }

    public int getAddressOffset() {
        return this.addressOffset;
    }

    public int getAddressLength() {
        return this.addressLength;
    }

    public int getConnectedSinceOffset() {
        return this.connectedSinceOffset;
    }

    public int getConnectedSinceLength() {
        return this.connectedSinceLength;
    }

    public int getClientVersionOffset() {
        return this.clientVersionOffset;
    }

    public int getClientVersionLength() {
        return this.clientVersionLength;
    }

    public StringBuilder getStringBuffer() {
        return this.stringBuffer;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonIgnore
    public void setCount(int count) {
        this.count = count;
    }

    public void setAccessMode(ProducerAccessMode accessMode) {
        this.accessMode = accessMode;
    }

    public void setMsgRateIn(double msgRateIn) {
        this.msgRateIn = msgRateIn;
    }

    public void setMsgThroughputIn(double msgThroughputIn) {
        this.msgThroughputIn = msgThroughputIn;
    }

    public void setAverageMsgSize(double averageMsgSize) {
        this.averageMsgSize = averageMsgSize;
    }

    public void setChunkedMessageRate(double chunkedMessageRate) {
        this.chunkedMessageRate = chunkedMessageRate;
    }

    public void setProducerId(long producerId) {
        this.producerId = producerId;
    }

    public void setSupportsPartialProducer(boolean supportsPartialProducer) {
        this.supportsPartialProducer = supportsPartialProducer;
    }

    @JsonIgnore
    public void setProducerNameOffset(int producerNameOffset) {
        this.producerNameOffset = producerNameOffset;
    }

    @JsonIgnore
    public void setProducerNameLength(int producerNameLength) {
        this.producerNameLength = producerNameLength;
    }

    @JsonIgnore
    public void setAddressOffset(int addressOffset) {
        this.addressOffset = addressOffset;
    }

    @JsonIgnore
    public void setAddressLength(int addressLength) {
        this.addressLength = addressLength;
    }

    @JsonIgnore
    public void setConnectedSinceOffset(int connectedSinceOffset) {
        this.connectedSinceOffset = connectedSinceOffset;
    }

    @JsonIgnore
    public void setConnectedSinceLength(int connectedSinceLength) {
        this.connectedSinceLength = connectedSinceLength;
    }

    @JsonIgnore
    public void setClientVersionOffset(int clientVersionOffset) {
        this.clientVersionOffset = clientVersionOffset;
    }

    @JsonIgnore
    public void setClientVersionLength(int clientVersionLength) {
        this.clientVersionLength = clientVersionLength;
    }

    @JsonIgnore
    public void setStringBuffer(StringBuilder stringBuffer) {
        this.stringBuffer = stringBuffer;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PublisherStatsImpl)) {
            return false;
        }
        PublisherStatsImpl other = (PublisherStatsImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        if (Double.compare(this.getMsgRateIn(), other.getMsgRateIn()) != 0) {
            return false;
        }
        if (Double.compare(this.getMsgThroughputIn(), other.getMsgThroughputIn()) != 0) {
            return false;
        }
        if (Double.compare(this.getAverageMsgSize(), other.getAverageMsgSize()) != 0) {
            return false;
        }
        if (Double.compare(this.getChunkedMessageRate(), other.getChunkedMessageRate()) != 0) {
            return false;
        }
        if (this.getProducerId() != other.getProducerId()) {
            return false;
        }
        if (this.isSupportsPartialProducer() != other.isSupportsPartialProducer()) {
            return false;
        }
        if (this.getProducerNameOffset() != other.getProducerNameOffset()) {
            return false;
        }
        if (this.getProducerNameLength() != other.getProducerNameLength()) {
            return false;
        }
        if (this.getAddressOffset() != other.getAddressOffset()) {
            return false;
        }
        if (this.getAddressLength() != other.getAddressLength()) {
            return false;
        }
        if (this.getConnectedSinceOffset() != other.getConnectedSinceOffset()) {
            return false;
        }
        if (this.getConnectedSinceLength() != other.getConnectedSinceLength()) {
            return false;
        }
        if (this.getClientVersionOffset() != other.getClientVersionOffset()) {
            return false;
        }
        if (this.getClientVersionLength() != other.getClientVersionLength()) {
            return false;
        }
        ProducerAccessMode this$accessMode = this.getAccessMode();
        ProducerAccessMode other$accessMode = other.getAccessMode();
        if (this$accessMode == null ? other$accessMode != null : !((Object)((Object)this$accessMode)).equals((Object)other$accessMode)) {
            return false;
        }
        StringBuilder this$stringBuffer = this.getStringBuffer();
        StringBuilder other$stringBuffer = other.getStringBuffer();
        if (this$stringBuffer == null ? other$stringBuffer != null : !this$stringBuffer.equals(other$stringBuffer)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PublisherStatsImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCount();
        long $msgRateIn = Double.doubleToLongBits(this.getMsgRateIn());
        result = result * 59 + (int)($msgRateIn >>> 32 ^ $msgRateIn);
        long $msgThroughputIn = Double.doubleToLongBits(this.getMsgThroughputIn());
        result = result * 59 + (int)($msgThroughputIn >>> 32 ^ $msgThroughputIn);
        long $averageMsgSize = Double.doubleToLongBits(this.getAverageMsgSize());
        result = result * 59 + (int)($averageMsgSize >>> 32 ^ $averageMsgSize);
        long $chunkedMessageRate = Double.doubleToLongBits(this.getChunkedMessageRate());
        result = result * 59 + (int)($chunkedMessageRate >>> 32 ^ $chunkedMessageRate);
        long $producerId = this.getProducerId();
        result = result * 59 + (int)($producerId >>> 32 ^ $producerId);
        result = result * 59 + (this.isSupportsPartialProducer() ? 79 : 97);
        result = result * 59 + this.getProducerNameOffset();
        result = result * 59 + this.getProducerNameLength();
        result = result * 59 + this.getAddressOffset();
        result = result * 59 + this.getAddressLength();
        result = result * 59 + this.getConnectedSinceOffset();
        result = result * 59 + this.getConnectedSinceLength();
        result = result * 59 + this.getClientVersionOffset();
        result = result * 59 + this.getClientVersionLength();
        ProducerAccessMode $accessMode = this.getAccessMode();
        result = result * 59 + ($accessMode == null ? 43 : ((Object)((Object)$accessMode)).hashCode());
        StringBuilder $stringBuffer = this.getStringBuffer();
        result = result * 59 + ($stringBuffer == null ? 43 : $stringBuffer.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    public String toString() {
        return "PublisherStatsImpl(count=" + this.getCount() + ", accessMode=" + (Object)((Object)this.getAccessMode()) + ", msgRateIn=" + this.getMsgRateIn() + ", msgThroughputIn=" + this.getMsgThroughputIn() + ", averageMsgSize=" + this.getAverageMsgSize() + ", chunkedMessageRate=" + this.getChunkedMessageRate() + ", producerId=" + this.getProducerId() + ", supportsPartialProducer=" + this.isSupportsPartialProducer() + ", producerNameOffset=" + this.getProducerNameOffset() + ", producerNameLength=" + this.getProducerNameLength() + ", addressOffset=" + this.getAddressOffset() + ", addressLength=" + this.getAddressLength() + ", connectedSinceOffset=" + this.getConnectedSinceOffset() + ", connectedSinceLength=" + this.getConnectedSinceLength() + ", clientVersionOffset=" + this.getClientVersionOffset() + ", clientVersionLength=" + this.getClientVersionLength() + ", stringBuffer=" + this.getStringBuffer() + ", metadata=" + this.getMetadata() + ")";
    }
}

