/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.storage.ldb;

import java.util.function.Supplier;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.Counter;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.Gauge;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.annotations.StatsDoc;

@StatsDoc(name="bookie", category="server", help="DbLedgerStorage related stats")
class DbLedgerStorageStats {
    private static final String ADD_ENTRY = "add-entry";
    private static final String READ_ENTRY = "read-entry";
    private static final String READ_CACHE_HITS = "read-cache-hits";
    private static final String READ_CACHE_MISSES = "read-cache-misses";
    private static final String READAHEAD_BATCH_COUNT = "readahead-batch-count";
    private static final String READAHEAD_BATCH_SIZE = "readahead-batch-size";
    private static final String FLUSH = "flush";
    private static final String FLUSH_SIZE = "flush-size";
    private static final String THROTTLED_WRITE_REQUESTS = "throttled-write-requests";
    private static final String REJECTED_WRITE_REQUESTS = "rejected-write-requests";
    private static final String WRITE_CACHE_SIZE = "write-cache-size";
    private static final String WRITE_CACHE_COUNT = "write-cache-count";
    private static final String READ_CACHE_SIZE = "read-cache-size";
    private static final String READ_CACHE_COUNT = "read-cache-count";
    @StatsDoc(name="add-entry", help="operation stats of adding entries to db ledger storage", parent="BOOKIE_ADD_ENTRY")
    private final OpStatsLogger addEntryStats;
    @StatsDoc(name="read-entry", help="operation stats of reading entries from db ledger storage", parent="BOOKIE_ADD_ENTRY")
    private final OpStatsLogger readEntryStats;
    @StatsDoc(name="read-cache-hits", help="operation stats of read cache hits", parent="read-entry")
    private final OpStatsLogger readCacheHitStats;
    @StatsDoc(name="read-cache-misses", help="operation stats of read cache misses", parent="read-entry")
    private final OpStatsLogger readCacheMissStats;
    @StatsDoc(name="readahead-batch-count", help="the distribution of num of entries to read in one readahead batch")
    private final OpStatsLogger readAheadBatchCountStats;
    @StatsDoc(name="readahead-batch-size", help="the distribution of num of bytes to read in one readahead batch")
    private final OpStatsLogger readAheadBatchSizeStats;
    @StatsDoc(name="flush", help="operation stats of flushing write cache to entry log files")
    private final OpStatsLogger flushStats;
    @StatsDoc(name="flush-size", help="the distribution of number of bytes flushed from write cache to entry log files")
    private final OpStatsLogger flushSizeStats;
    @StatsDoc(name="throttled-write-requests", help="The number of requests throttled due to write cache is full")
    private final Counter throttledWriteRequests;
    @StatsDoc(name="rejected-write-requests", help="The number of requests rejected due to write cache is full")
    private final Counter rejectedWriteRequests;
    @StatsDoc(name="write-cache-size", help="Current number of bytes in write cache")
    private final Gauge<Long> writeCacheSizeGauge;
    @StatsDoc(name="write-cache-count", help="Current number of entries in write cache")
    private final Gauge<Long> writeCacheCountGauge;
    @StatsDoc(name="read-cache-size", help="Current number of bytes in read cache")
    private final Gauge<Long> readCacheSizeGauge;
    @StatsDoc(name="read-cache-count", help="Current number of entries in read cache")
    private final Gauge<Long> readCacheCountGauge;

    DbLedgerStorageStats(StatsLogger stats, final Supplier<Long> writeCacheSizeSupplier, final Supplier<Long> writeCacheCountSupplier, final Supplier<Long> readCacheSizeSupplier, final Supplier<Long> readCacheCountSupplier) {
        this.addEntryStats = stats.getOpStatsLogger(ADD_ENTRY);
        this.readEntryStats = stats.getOpStatsLogger(READ_ENTRY);
        this.readCacheHitStats = stats.getOpStatsLogger(READ_CACHE_HITS);
        this.readCacheMissStats = stats.getOpStatsLogger(READ_CACHE_MISSES);
        this.readAheadBatchCountStats = stats.getOpStatsLogger(READAHEAD_BATCH_COUNT);
        this.readAheadBatchSizeStats = stats.getOpStatsLogger(READAHEAD_BATCH_SIZE);
        this.flushStats = stats.getOpStatsLogger(FLUSH);
        this.flushSizeStats = stats.getOpStatsLogger(FLUSH_SIZE);
        this.throttledWriteRequests = stats.getCounter(THROTTLED_WRITE_REQUESTS);
        this.rejectedWriteRequests = stats.getCounter(REJECTED_WRITE_REQUESTS);
        this.writeCacheSizeGauge = new Gauge<Long>(){

            public Long getDefaultValue() {
                return 0L;
            }

            public Long getSample() {
                return (Long)writeCacheSizeSupplier.get();
            }
        };
        stats.registerGauge(WRITE_CACHE_SIZE, this.writeCacheSizeGauge);
        this.writeCacheCountGauge = new Gauge<Long>(){

            public Long getDefaultValue() {
                return 0L;
            }

            public Long getSample() {
                return (Long)writeCacheCountSupplier.get();
            }
        };
        stats.registerGauge(WRITE_CACHE_COUNT, this.writeCacheCountGauge);
        this.readCacheSizeGauge = new Gauge<Long>(){

            public Long getDefaultValue() {
                return 0L;
            }

            public Long getSample() {
                return (Long)readCacheSizeSupplier.get();
            }
        };
        stats.registerGauge(READ_CACHE_SIZE, this.readCacheSizeGauge);
        this.readCacheCountGauge = new Gauge<Long>(){

            public Long getDefaultValue() {
                return 0L;
            }

            public Long getSample() {
                return (Long)readCacheCountSupplier.get();
            }
        };
        stats.registerGauge(READ_CACHE_COUNT, this.readCacheCountGauge);
    }

    public OpStatsLogger getAddEntryStats() {
        return this.addEntryStats;
    }

    public OpStatsLogger getReadEntryStats() {
        return this.readEntryStats;
    }

    public OpStatsLogger getReadCacheHitStats() {
        return this.readCacheHitStats;
    }

    public OpStatsLogger getReadCacheMissStats() {
        return this.readCacheMissStats;
    }

    public OpStatsLogger getReadAheadBatchCountStats() {
        return this.readAheadBatchCountStats;
    }

    public OpStatsLogger getReadAheadBatchSizeStats() {
        return this.readAheadBatchSizeStats;
    }

    public OpStatsLogger getFlushStats() {
        return this.flushStats;
    }

    public OpStatsLogger getFlushSizeStats() {
        return this.flushSizeStats;
    }

    public Counter getThrottledWriteRequests() {
        return this.throttledWriteRequests;
    }

    public Counter getRejectedWriteRequests() {
        return this.rejectedWriteRequests;
    }

    public Gauge<Long> getWriteCacheSizeGauge() {
        return this.writeCacheSizeGauge;
    }

    public Gauge<Long> getWriteCacheCountGauge() {
        return this.writeCacheCountGauge;
    }

    public Gauge<Long> getReadCacheSizeGauge() {
        return this.readCacheSizeGauge;
    }

    public Gauge<Long> getReadCacheCountGauge() {
        return this.readCacheCountGauge;
    }
}

