/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client;

import java.util.function.Function;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.api.BKException;

public abstract class BKException
extends org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.api.BKException {
    public static final Function<Throwable, BKException> HANDLER = cause -> {
        if (cause == null) {
            return null;
        }
        if (cause instanceof BKException) {
            return (BKException)cause;
        }
        BKUnexpectedConditionException ex = new BKUnexpectedConditionException();
        ex.initCause((Throwable)cause);
        return ex;
    };

    BKException(int code) {
        super(code);
    }

    BKException(int code, Throwable cause) {
        super(code, cause);
    }

    public static BKException create(int code) {
        switch (code) {
            case -1: {
                return new BKReadException();
            }
            case -2: {
                return new BKQuorumException();
            }
            case -3: {
                return new BKBookieException();
            }
            case -4: {
                return new BKDigestNotInitializedException();
            }
            case -5: {
                return new BKDigestMatchException();
            }
            case -6: {
                return new BKNotEnoughBookiesException();
            }
            case -7: {
                return new BKNoSuchLedgerExistsException();
            }
            case -25: {
                return new BKNoSuchLedgerExistsOnMetadataServerException();
            }
            case -8: {
                return new BKBookieHandleNotAvailableException();
            }
            case -9: {
                return new ZKException();
            }
            case -18: {
                return new MetaStoreException();
            }
            case -10: {
                return new BKLedgerRecoveryException();
            }
            case -11: {
                return new BKLedgerClosedException();
            }
            case -12: {
                return new BKWriteException();
            }
            case -13: {
                return new BKNoSuchEntryException();
            }
            case -14: {
                return new BKIncorrectParameterException();
            }
            case -15: {
                return new BKInterruptedException();
            }
            case -16: {
                return new BKProtocolVersionException();
            }
            case -17: {
                return new BKMetadataVersionException();
            }
            case -101: {
                return new BKLedgerFencedException();
            }
            case -102: {
                return new BKUnauthorizedAccessException();
            }
            case -103: {
                return new BKUnclosedFragmentException();
            }
            case -104: {
                return new BKWriteOnReadOnlyBookieException();
            }
            case -105: {
                return new BKTooManyRequestsException();
            }
            case -200: {
                return new BKReplicationException();
            }
            case -19: {
                return new BKClientClosedException();
            }
            case -20: {
                return new BKLedgerExistException();
            }
            case -100: {
                return new BKIllegalOpException();
            }
            case -21: {
                return new BKAddEntryQuorumTimeoutException();
            }
            case -22: {
                return new BKDuplicateEntryIdException();
            }
            case -23: {
                return new BKTimeoutException();
            }
            case -106: {
                return new BKLedgerIdOverflowException();
            }
            case -24: {
                return new BKSecurityException();
            }
            case -107: {
                return new BKMetadataSerializationException();
            }
        }
        return new BKUnexpectedConditionException();
    }

    public static int getExceptionCode(Throwable t, int defaultCode) {
        if (t == null) {
            return 0;
        }
        if (t instanceof BKException) {
            return ((BKException)t).getCode();
        }
        if (t.getCause() != null) {
            return BKException.getExceptionCode(t.getCause(), defaultCode);
        }
        return defaultCode;
    }

    public static int getExceptionCode(Throwable t) {
        return BKException.getExceptionCode(t, -999);
    }

    public static class BKMetadataSerializationException
    extends BKException {
        public BKMetadataSerializationException() {
            super(-107);
        }

        public BKMetadataSerializationException(Throwable cause) {
            super(-107, cause);
        }
    }

    public static class BKLedgerIdOverflowException
    extends BKException {
        public BKLedgerIdOverflowException() {
            super(-106);
        }
    }

    public static class BKTimeoutException
    extends BKException {
        public BKTimeoutException() {
            super(-23);
        }
    }

    public static class BKClientClosedException
    extends BKException {
        public BKClientClosedException() {
            super(-19);
        }
    }

    public static class BKReplicationException
    extends BKException {
        public BKReplicationException() {
            super(-200);
        }
    }

    public static class BKTooManyRequestsException
    extends BKException {
        public BKTooManyRequestsException() {
            super(-105);
        }
    }

    public static class BKWriteOnReadOnlyBookieException
    extends BKException {
        public BKWriteOnReadOnlyBookieException() {
            super(-104);
        }
    }

    public static class BKUnclosedFragmentException
    extends BKException {
        public BKUnclosedFragmentException() {
            super(-103);
        }
    }

    public static class BKUnauthorizedAccessException
    extends BKException {
        public BKUnauthorizedAccessException() {
            super(-102);
        }
    }

    public static class BKLedgerFencedException
    extends BKException {
        public BKLedgerFencedException() {
            super(-101);
        }
    }

    public static class BKInterruptedException
    extends BKException {
        public BKInterruptedException() {
            super(-15);
        }
    }

    public static class BKIncorrectParameterException
    extends BKException {
        public BKIncorrectParameterException() {
            super(-14);
        }
    }

    public static class BKLedgerClosedException
    extends BKException {
        public BKLedgerClosedException() {
            super(-11);
        }
    }

    public static class BKLedgerRecoveryException
    extends BKException {
        public BKLedgerRecoveryException() {
            super(-10);
        }
    }

    public static class BKLedgerExistException
    extends BKException {
        public BKLedgerExistException() {
            super(-20);
        }
    }

    public static class MetaStoreException
    extends BKException {
        public MetaStoreException() {
            super(-18);
        }

        public MetaStoreException(Throwable cause) {
            super(-18, cause);
        }
    }

    public static class ZKException
    extends BKException {
        public ZKException() {
            super(-9);
        }

        public ZKException(Throwable cause) {
            super(-9, cause);
        }
    }

    public static class BKBookieHandleNotAvailableException
    extends BKException {
        public BKBookieHandleNotAvailableException() {
            super(-8);
        }
    }

    public static class BKNoSuchLedgerExistsOnMetadataServerException
    extends BKException {
        public BKNoSuchLedgerExistsOnMetadataServerException() {
            super(-25);
        }
    }

    public static class BKNoSuchLedgerExistsException
    extends BKException {
        public BKNoSuchLedgerExistsException() {
            super(-7);
        }
    }

    public static class BKMetadataVersionException
    extends BKException {
        public BKMetadataVersionException() {
            super(-17);
        }
    }

    public static class BKProtocolVersionException
    extends BKException {
        public BKProtocolVersionException() {
            super(-16);
        }
    }

    public static class BKWriteException
    extends BKException {
        public BKWriteException() {
            super(-12);
        }
    }

    public static class BKNotEnoughBookiesException
    extends BKException {
        public BKNotEnoughBookiesException() {
            super(-6);
        }

        public BKNotEnoughBookiesException(Throwable cause) {
            super(-6, cause);
        }
    }

    public static class BKUnexpectedConditionException
    extends BKException {
        public BKUnexpectedConditionException() {
            super(-999);
        }
    }

    public static class BKDuplicateEntryIdException
    extends BKException {
        public BKDuplicateEntryIdException() {
            super(-22);
        }
    }

    public static class BKAddEntryQuorumTimeoutException
    extends BKException {
        public BKAddEntryQuorumTimeoutException() {
            super(-21);
        }
    }

    public static class BKIllegalOpException
    extends BKException {
        public BKIllegalOpException() {
            super(-100);
        }
    }

    public static class BKDigestMatchException
    extends BKException {
        public BKDigestMatchException() {
            super(-5);
        }
    }

    public static class BKDigestNotInitializedException
    extends BKException {
        public BKDigestNotInitializedException() {
            super(-4);
        }
    }

    public static class BKBookieException
    extends BKException {
        public BKBookieException() {
            super(-3);
        }
    }

    public static class BKQuorumException
    extends BKException {
        public BKQuorumException() {
            super(-2);
        }
    }

    public static class BKNoSuchEntryException
    extends BKException {
        public BKNoSuchEntryException() {
            super(-13);
        }
    }

    public static class BKReadException
    extends BKException {
        public BKReadException() {
            super(-1);
        }
    }

    public static class BKSecurityException
    extends BKException {
        public BKSecurityException() {
            super(-24);
        }
    }

    public static interface Code
    extends BKException.Code {
    }
}

