/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.metastore;

import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.metastore.InMemoryMetaStore;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.metastore.InMemoryMetastoreCursor;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.metastore.MSException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.metastore.MSWatchedEvent;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.metastore.MetastoreCallback;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.metastore.MetastoreCursor;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.metastore.MetastoreScannableTable;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.metastore.MetastoreTable;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.metastore.MetastoreWatcher;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.metastore.Value;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.versioning.Version;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.versioning.Versioned;

public class InMemoryMetastoreTable
implements MetastoreScannableTable {
    private String name;
    private TreeMap<String, Versioned<Value>> map = new TreeMap();
    private TreeMap<String, MetastoreWatcher> watcherMap = new TreeMap();
    private ScheduledExecutorService scheduler;

    public InMemoryMetastoreTable(InMemoryMetaStore metastore, String name) {
        this.name = name;
        String thName = "InMemoryMetastore-Table(" + name + ")-Scheduler-%d";
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder().setNameFormat(thName);
        this.scheduler = Executors.newSingleThreadScheduledExecutor(tfb.build());
    }

    @Override
    public String getName() {
        return this.name;
    }

    static Versioned<Value> cloneValue(Value value, Version version, Set<String> fields) {
        if (null != value) {
            Value newValue = new Value();
            if (ALL_FIELDS == fields) {
                fields = value.getFields();
            }
            for (String f : fields) {
                newValue.setField(f, value.getField(f));
            }
            value = newValue;
        }
        if (null == version) {
            throw new NullPointerException("Version isn't allowed to be null.");
        }
        if (Version.ANY != version && Version.NEW != version) {
            if (version instanceof MetadataVersion) {
                version = new MetadataVersion(((MetadataVersion)version).version);
            } else {
                throw new IllegalStateException("Wrong version type.");
            }
        }
        return new Versioned<Value>(value, version);
    }

    @Override
    public void get(final String key, final MetastoreCallback<Versioned<Value>> cb, final Object ctx) {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                InMemoryMetastoreTable.this.scheduleGet(key, MetastoreTable.ALL_FIELDS, cb, ctx);
            }
        });
    }

    @Override
    public void get(final String key, final MetastoreWatcher watcher, final MetastoreCallback<Versioned<Value>> cb, final Object ctx) {
        this.scheduler.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InMemoryMetastoreTable.this.scheduleGet(key, MetastoreTable.ALL_FIELDS, cb, ctx);
                TreeMap treeMap = InMemoryMetastoreTable.this.watcherMap;
                synchronized (treeMap) {
                    InMemoryMetastoreTable.this.watcherMap.put(key, watcher);
                }
            }
        });
    }

    @Override
    public void get(final String key, final Set<String> fields, final MetastoreCallback<Versioned<Value>> cb, final Object ctx) {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                InMemoryMetastoreTable.this.scheduleGet(key, fields, cb, ctx);
            }
        });
    }

    public synchronized void scheduleGet(String key, Set<String> fields, MetastoreCallback<Versioned<Value>> cb, Object ctx) {
        int rc;
        if (null == key) {
            cb.complete(MSException.Code.IllegalOp.getCode(), null, ctx);
            return;
        }
        Versioned<Value> vv = this.get(key);
        int n = rc = null == vv ? MSException.Code.NoKey.getCode() : MSException.Code.OK.getCode();
        if (vv != null) {
            vv = InMemoryMetastoreTable.cloneValue(vv.getValue(), vv.getVersion(), fields);
        }
        cb.complete(rc, vv, ctx);
    }

    @Override
    public void put(final String key, final Value value, final Version version, final MetastoreCallback<Version> cb, final Object ctx) {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                if (null == key || null == value || null == version) {
                    cb.complete(MSException.Code.IllegalOp.getCode(), null, ctx);
                    return;
                }
                Result result = InMemoryMetastoreTable.this.put(key, value, version);
                cb.complete(result.code.getCode(), result.value, ctx);
                if (result.code == MSException.Code.OK) {
                    InMemoryMetastoreTable.this.triggerWatch(key, MSWatchedEvent.EventType.CHANGED);
                }
            }
        });
    }

    @Override
    public void remove(final String key, final Version version, final MetastoreCallback<Void> cb, final Object ctx) {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                if (null == key || null == version) {
                    cb.complete(MSException.Code.IllegalOp.getCode(), null, ctx);
                    return;
                }
                MSException.Code code = InMemoryMetastoreTable.this.remove(key, version);
                cb.complete(code.getCode(), null, ctx);
                if (code == MSException.Code.OK) {
                    InMemoryMetastoreTable.this.triggerWatch(key, MSWatchedEvent.EventType.REMOVED);
                }
            }
        });
    }

    @Override
    public void openCursor(MetastoreCallback<MetastoreCursor> cb, Object ctx) {
        this.openCursor(EMPTY_START_KEY, true, EMPTY_END_KEY, true, MetastoreScannableTable.Order.ASC, ALL_FIELDS, cb, ctx);
    }

    @Override
    public void openCursor(Set<String> fields, MetastoreCallback<MetastoreCursor> cb, Object ctx) {
        this.openCursor(EMPTY_START_KEY, true, EMPTY_END_KEY, true, MetastoreScannableTable.Order.ASC, fields, cb, ctx);
    }

    @Override
    public void openCursor(String firstKey, boolean firstInclusive, String lastKey, boolean lastInclusive, MetastoreScannableTable.Order order, MetastoreCallback<MetastoreCursor> cb, Object ctx) {
        this.openCursor(firstKey, firstInclusive, lastKey, lastInclusive, order, ALL_FIELDS, cb, ctx);
    }

    @Override
    public void openCursor(final String firstKey, final boolean firstInclusive, final String lastKey, final boolean lastInclusive, final MetastoreScannableTable.Order order, final Set<String> fields, final MetastoreCallback<MetastoreCursor> cb, final Object ctx) {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                Result result = InMemoryMetastoreTable.this.openCursor(firstKey, firstInclusive, lastKey, lastInclusive, order, fields);
                cb.complete(result.code.getCode(), result.value, ctx);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerWatch(String key, MSWatchedEvent.EventType type) {
        TreeMap<String, MetastoreWatcher> treeMap = this.watcherMap;
        synchronized (treeMap) {
            if (this.watcherMap.containsKey(key)) {
                MSWatchedEvent event = new MSWatchedEvent(key, type);
                this.watcherMap.get(key).process(event);
                this.watcherMap.remove(key);
            }
        }
    }

    private synchronized Versioned<Value> get(String key) {
        return this.map.get(key);
    }

    private synchronized MSException.Code remove(String key, Version version) {
        Versioned<Value> vv = this.map.get(key);
        if (null == vv) {
            return MSException.Code.NoKey;
        }
        if (Version.Occurred.CONCURRENTLY != vv.getVersion().compare(version)) {
            return MSException.Code.BadVersion;
        }
        this.map.remove(key);
        return MSException.Code.OK;
    }

    private synchronized Result<Version> put(String key, Value value, Version version) {
        Versioned<Value> vv = this.map.get(key);
        if (vv == null) {
            if (Version.NEW != version) {
                return new Result<Object>(MSException.Code.NoKey, null);
            }
            vv = InMemoryMetastoreTable.cloneValue(value, version, ALL_FIELDS);
            vv.setVersion(new MetadataVersion(0));
            this.map.put(key, vv);
            return new Result<Version>(MSException.Code.OK, new MetadataVersion(0));
        }
        if (Version.NEW == version) {
            return new Result<Object>(MSException.Code.KeyExists, null);
        }
        if (Version.Occurred.CONCURRENTLY != vv.getVersion().compare(version)) {
            return new Result<Object>(MSException.Code.BadVersion, null);
        }
        vv.setVersion(((MetadataVersion)vv.getVersion()).incrementVersion());
        vv.setValue(vv.getValue().merge(value));
        return new Result<Version>(MSException.Code.OK, new MetadataVersion((MetadataVersion)vv.getVersion()));
    }

    private synchronized Result<MetastoreCursor> openCursor(String firstKey, boolean firstInclusive, String lastKey, boolean lastInclusive, MetastoreScannableTable.Order order, Set<String> fields) {
        if (0 == this.map.size()) {
            return new Result<MetastoreCursor>(MSException.Code.OK, MetastoreCursor.EMPTY_CURSOR);
        }
        boolean isLegalCursor = false;
        NavigableMap<String, Versioned<Value>> myMap = null;
        if (MetastoreScannableTable.Order.ASC == order) {
            myMap = this.map;
            if (EMPTY_END_KEY == lastKey || lastKey.compareTo((String)myMap.lastKey()) > 0) {
                lastKey = (String)myMap.lastKey();
                lastInclusive = true;
            }
            if (EMPTY_START_KEY == firstKey || firstKey.compareTo((String)myMap.firstKey()) < 0) {
                firstKey = (String)myMap.firstKey();
                firstInclusive = true;
            }
            if (firstKey.compareTo(lastKey) <= 0) {
                isLegalCursor = true;
            }
        } else if (MetastoreScannableTable.Order.DESC == order) {
            myMap = this.map.descendingMap();
            if (EMPTY_START_KEY == lastKey || lastKey.compareTo((String)myMap.lastKey()) < 0) {
                lastKey = (String)myMap.lastKey();
                lastInclusive = true;
            }
            if (EMPTY_END_KEY == firstKey || firstKey.compareTo((String)myMap.firstKey()) > 0) {
                firstKey = (String)myMap.firstKey();
                firstInclusive = true;
            }
            if (firstKey.compareTo(lastKey) >= 0) {
                isLegalCursor = true;
            }
        }
        if (!isLegalCursor || null == myMap) {
            return new Result<Object>(MSException.Code.IllegalOp, null);
        }
        InMemoryMetastoreCursor cursor = new InMemoryMetastoreCursor(myMap.subMap(firstKey, firstInclusive, lastKey, lastInclusive), fields, this.scheduler);
        return new Result<MetastoreCursor>(MSException.Code.OK, cursor);
    }

    @Override
    public void close() {
    }

    static class Result<T> {
        MSException.Code code;
        T value;

        public Result(MSException.Code code, T value) {
            this.code = code;
            this.value = value;
        }
    }

    public static class MetadataVersion
    implements Version {
        int version;

        public MetadataVersion(int v) {
            this.version = v;
        }

        public MetadataVersion(MetadataVersion v) {
            this.version = v.version;
        }

        public synchronized MetadataVersion incrementVersion() {
            ++this.version;
            return this;
        }

        @Override
        public Version.Occurred compare(Version v) {
            if (null == v) {
                throw new NullPointerException("Version is not allowed to be null.");
            }
            if (v == Version.NEW) {
                return Version.Occurred.AFTER;
            }
            if (v == Version.ANY) {
                return Version.Occurred.CONCURRENTLY;
            }
            if (!(v instanceof MetadataVersion)) {
                throw new IllegalArgumentException("Invalid version type");
            }
            MetadataVersion mv = (MetadataVersion)v;
            int res = this.version - mv.version;
            if (res == 0) {
                return Version.Occurred.CONCURRENTLY;
            }
            if (res < 0) {
                return Version.Occurred.BEFORE;
            }
            return Version.Occurred.AFTER;
        }

        public boolean equals(Object obj) {
            if (null == obj || !(obj instanceof MetadataVersion)) {
                return false;
            }
            MetadataVersion v = (MetadataVersion)obj;
            return 0 == this.version - v.version;
        }

        public String toString() {
            return "version=" + this.version;
        }

        public int hashCode() {
            return this.version;
        }
    }
}

